/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.common.exception.ExceptionType;
import com.helpshift.common.exception.PlatformException;
import com.helpshift.conversation.activeconversation.ConversationRenderer;
import com.helpshift.conversation.activeconversation.message.ConversationFooterState;
import com.helpshift.conversation.activeconversation.message.HistoryLoadingState;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.support.conversations.ConversationFragmentRouter;
import com.helpshift.support.conversations.MessagesAdapter;
import com.helpshift.support.conversations.TextWatcherAdapter;
import com.helpshift.support.fragments.HSMenuItemType;
import com.helpshift.support.fragments.IToolbarMenuItemRenderer;
import com.helpshift.support.util.KeyboardUtil;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.util.FileUtil;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.IntentUtil;
import com.helpshift.util.Styles;
import java.io.File;
import java.util.List;

class ConversationFragmentRenderer
implements ConversationRenderer {
    protected EditText replyField;
    protected View parentView;
    protected ConversationFragmentRouter conversationFragmentRouter;
    protected View replyBoxView;
    RecyclerView messagesRecyclerView;
    MessagesAdapter messagesAdapter;
    Context context;
    private ImageButton replyButton;
    private View confirmationBoxView;
    private IToolbarMenuItemRenderer menuItemRenderer;
    private View scrollIndicator;
    private View unreadMessagesIndicatorDot;
    private View scrollJumpButton;

    ConversationFragmentRenderer(Context context, RecyclerView messagesRecyclerView, View parentView, View confirmationBoxView, ConversationFragmentRouter conversationFragmentRouter, View scrollIndicator, View unreadMessagesIndicatorDot, IToolbarMenuItemRenderer menuItemRenderer) {
        this.context = context;
        this.messagesRecyclerView = messagesRecyclerView;
        RecyclerView.ItemAnimator itemAnimator = this.messagesRecyclerView.getItemAnimator();
        if (itemAnimator instanceof SimpleItemAnimator) {
            ((SimpleItemAnimator)itemAnimator).setSupportsChangeAnimations(false);
        }
        this.parentView = parentView;
        this.replyBoxView = parentView.findViewById(R.id.relativeLayout1);
        this.replyField = (EditText)this.replyBoxView.findViewById(R.id.hs__messageText);
        this.replyButton = (ImageButton)this.replyBoxView.findViewById(R.id.hs__sendMessageBtn);
        this.scrollJumpButton = parentView.findViewById(R.id.scroll_jump_button);
        this.confirmationBoxView = confirmationBoxView;
        this.conversationFragmentRouter = conversationFragmentRouter;
        this.menuItemRenderer = menuItemRenderer;
        this.scrollIndicator = scrollIndicator;
        this.unreadMessagesIndicatorDot = unreadMessagesIndicatorDot;
    }

    @Override
    public void initializeMessages(List<MessageDM> messages) {
        this.messagesAdapter = new MessagesAdapter(this.context, messages, this.conversationFragmentRouter);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.context);
        linearLayoutManager.setStackFromEnd(true);
        this.messagesRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.messagesRecyclerView.setAdapter((RecyclerView.Adapter)this.messagesAdapter);
    }

    @Override
    public void appendMessages(int startPosition, int itemCount) {
        if (this.messagesAdapter == null) {
            return;
        }
        this.messagesAdapter.onItemRangeInserted(startPosition, itemCount);
    }

    @Override
    public void updateMessages(int startPosition, int itemCount) {
        if (this.messagesAdapter == null) {
            return;
        }
        if (startPosition == 0 && itemCount == this.messagesAdapter.getMessageCount()) {
            this.messagesAdapter.notifyDataSetChanged();
        } else {
            this.messagesAdapter.onItemRangeChanged(startPosition, itemCount);
        }
    }

    @Override
    public void removeMessages(int startPosition, int itemCount) {
        if (this.messagesAdapter == null) {
            return;
        }
        this.messagesAdapter.onItemRangeRemoved(startPosition, itemCount);
    }

    @Override
    public void showImageAttachmentButton() {
        this.changeMenuItemVisibility(HSMenuItemType.SCREENSHOT_ATTACHMENT, true);
    }

    @Override
    public void hideImageAttachmentButton() {
        this.changeMenuItemVisibility(HSMenuItemType.SCREENSHOT_ATTACHMENT, false);
    }

    @Override
    public void enableSendReplyButton() {
        this.replyButton.setEnabled(true);
        com.helpshift.support.util.Styles.setImageAlpha(this.replyButton, 255);
        com.helpshift.support.util.Styles.setSendMessageButtonIconColor(this.context, this.replyButton.getDrawable(), true);
    }

    @Override
    public void disableSendReplyButton() {
        this.replyButton.setEnabled(false);
        com.helpshift.support.util.Styles.setImageAlpha(this.replyButton, 64);
        com.helpshift.support.util.Styles.setSendMessageButtonIconColor(this.context, this.replyButton.getDrawable(), false);
    }

    @Override
    public String getReply() {
        return this.replyField.getText().toString();
    }

    @Override
    public void setReply(String reply) {
        this.replyField.setText((CharSequence)reply);
    }

    @Override
    public void showConversationResolutionQuestionUI() {
        this.hideKeyboard();
        this.confirmationBoxView.setVisibility(0);
    }

    @Override
    public void hideConversationResolutionQuestionUI() {
        this.confirmationBoxView.setVisibility(8);
    }

    @Override
    public void showSendReplyUI() {
        this.setMessagesViewBottomPadding();
        this.replyBoxView.setVisibility(0);
    }

    @Override
    public void hideSendReplyUI() {
        this.messagesRecyclerView.setPadding(0, 0, 0, 0);
        this.replyBoxView.setVisibility(8);
    }

    private void launchAttachmentIntentInternal(Intent intent, File file) {
        if (intent.resolveActivity(this.context.getPackageManager()) != null) {
            this.context.startActivity(intent);
        } else if (HelpshiftContext.getCoreApi().getDelegate().isDelegateRegistered()) {
            HelpshiftContext.getCoreApi().getDelegate().displayAttachmentFile(file);
        } else {
            this.showErrorView(PlatformException.NO_APPS_FOR_OPENING_ATTACHMENT);
        }
    }

    @Override
    public void launchScreenshotAttachment(String filePath, String contentType) {
        File file = FileUtil.validateAndCreateFile(filePath);
        if (file != null) {
            this.launchAttachmentIntentInternal(IntentUtil.createFileProviderIntent(this.context, file, contentType), file);
        } else {
            this.showErrorView(PlatformException.FILE_NOT_FOUND);
        }
    }

    @Override
    public void launchAttachment(String filePath, String contentType) {
        File file = FileUtil.validateAndCreateFile(filePath);
        if (file != null) {
            Intent intent;
            if (Build.VERSION.SDK_INT >= 24) {
                intent = IntentUtil.createFileProviderIntent(this.context, file, contentType);
            } else {
                intent = new Intent("android.intent.action.VIEW");
                Uri uri = Uri.fromFile((File)file);
                intent.setDataAndType(uri, contentType);
            }
            this.launchAttachmentIntentInternal(intent, file);
        } else {
            this.showErrorView(PlatformException.FILE_NOT_FOUND);
        }
    }

    @Override
    public void showErrorView(ExceptionType exceptionType) {
        SnackbarUtil.showSnackbar(exceptionType, this.parentView);
    }

    @Override
    public void openAppReviewStore(String reviewUrl) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)reviewUrl));
        if (intent.resolveActivity(this.context.getPackageManager()) != null) {
            this.context.startActivity(intent);
        } else {
            this.showErrorView(PlatformException.NO_APPS_FOR_OPENING_ATTACHMENT);
        }
    }

    @Override
    public void updateConversationFooterState(ConversationFooterState conversationFooterState) {
        if (this.messagesAdapter != null) {
            if (conversationFooterState != ConversationFooterState.NONE) {
                this.hideKeyboard();
            }
            this.messagesAdapter.setConversationFooterState(conversationFooterState);
        }
    }

    @Override
    public void updateHistoryLoadingState(HistoryLoadingState historyLoadingState) {
        if (this.messagesAdapter != null) {
            this.messagesAdapter.setHistoryLoadingState(historyLoadingState);
        }
    }

    @Override
    public void showCSATSubmittedView() {
        SnackbarUtil.showSnackbar(this.parentView, this.context.getResources().getString(R.string.hs__csat_submit_toast), 0);
    }

    @Override
    public void openFreshConversationScreen() {
        this.conversationFragmentRouter.openFreshConversationScreen();
    }

    @Override
    public void showAgentTypingIndicator() {
        if (this.messagesAdapter != null) {
            this.messagesAdapter.setAgentTypingIndicatorVisibility(true);
        }
    }

    @Override
    public void hideAgentTypingIndicator() {
        if (this.messagesAdapter != null) {
            this.messagesAdapter.setAgentTypingIndicatorVisibility(false);
        }
    }

    @Override
    public void onAuthenticationFailure() {
        if (this.conversationFragmentRouter != null) {
            this.conversationFragmentRouter.onAuthenticationFailure();
        }
    }

    @Override
    public boolean isReplyBoxVisible() {
        return this.replyBoxView.getVisibility() == 0;
    }

    @Override
    public void setReplyboxListeners() {
        this.replyField.addTextChangedListener((TextWatcher)new TextWatcherAdapter(){

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                if (ConversationFragmentRenderer.this.conversationFragmentRouter != null) {
                    ConversationFragmentRenderer.this.conversationFragmentRouter.onTextChanged(charSequence, i, i1, i2);
                }
            }
        });
        this.replyField.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 4) {
                    ConversationFragmentRenderer.this.replyButton.performClick();
                }
                return false;
            }
        });
        this.replyButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ConversationFragmentRenderer.this.conversationFragmentRouter != null) {
                    ConversationFragmentRenderer.this.conversationFragmentRouter.onSendButtonClick();
                }
            }
        });
    }

    @Override
    public void requestReplyFieldFocus() {
        this.replyField.requestFocus();
    }

    @Override
    public void showKeyboard() {
        KeyboardUtil.showKeyboard(this.context, (View)this.replyField);
    }

    @Override
    public void hideKeyboard() {
        KeyboardUtil.hideKeyboard(this.context, (View)this.replyField);
    }

    @Override
    public void notifyRefreshList() {
        if (this.messagesAdapter != null) {
            this.messagesAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public void destroy() {
        this.conversationFragmentRouter = null;
    }

    @Override
    public void showScrollJumperView(boolean showUnreadMessageCountIndicator) {
        String jumpButtonContentDescription;
        this.scrollIndicator.setVisibility(0);
        if (showUnreadMessageCountIndicator) {
            this.unreadMessagesIndicatorDot.setVisibility(0);
            jumpButtonContentDescription = this.context.getString(R.string.hs__jump_button_with_new_message_voice_over);
        } else {
            this.unreadMessagesIndicatorDot.setVisibility(8);
            jumpButtonContentDescription = this.context.getString(R.string.hs__jump_button_voice_over);
        }
        this.scrollJumpButton.setContentDescription((CharSequence)jumpButtonContentDescription);
    }

    @Override
    public void hideScrollJumperView() {
        this.scrollIndicator.setVisibility(8);
        this.unreadMessagesIndicatorDot.setVisibility(8);
    }

    @Override
    public void scrollToBottom() {
        if (this.messagesAdapter == null) {
            return;
        }
        int count = this.messagesAdapter.getItemCount();
        if (count > 0) {
            this.messagesRecyclerView.scrollToPosition(count - 1);
        }
    }

    protected void setMessagesViewBottomPadding() {
        int bottomPadding = (int)Styles.dpToPx(this.context, 12.0f);
        this.messagesRecyclerView.setPadding(0, 0, 0, bottomPadding);
    }

    private void changeMenuItemVisibility(HSMenuItemType type, boolean isVisible) {
        if (this.menuItemRenderer != null) {
            this.menuItemRenderer.updateMenuItemVisibility(type, isVisible);
        }
    }

    public void unregisterFragmentRenderer() {
        if (this.messagesAdapter != null) {
            this.messagesAdapter.unregisterAdapterClickListener();
        }
    }
}

