/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations;

import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewStub;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.AutoRetryFailedEventDM;
import com.helpshift.common.StringUtils;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.ConversationalRenderer;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.OptionInputMessageDM;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import com.helpshift.conversation.viewmodel.ConversationalVM;
import com.helpshift.conversation.viewmodel.OptionUIModel;
import com.helpshift.network.HSNetworkConnectivityReceiver;
import com.helpshift.support.conversations.ConversationFragment;
import com.helpshift.support.conversations.ConversationalFragmentRenderer;
import com.helpshift.support.conversations.ConversationalFragmentRouter;
import com.helpshift.support.fragments.SingleQuestionFragment;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.util.HelpshiftContext;
import java.util.HashMap;

public class ConversationalFragment
extends ConversationFragment
implements HSNetworkConnectivityReceiver.HSNetworkConnectivityListener,
ConversationalFragmentRouter {
    private HSNetworkConnectivityReceiver networkConnectivityReceiver;
    private boolean shouldShowConversationHistory;

    public static ConversationalFragment newInstance(Bundle bundle) {
        ConversationalFragment conversationalFragment = new ConversationalFragment();
        conversationalFragment.setArguments(bundle);
        return conversationalFragment;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.shouldShowConversationHistory = this.getArguments().getBoolean("show_conv_history");
        super.onViewCreated(view, savedInstanceState);
    }

    @Override
    protected void inflateReplyBoxView(View view) {
        ViewStub replyBoxViewStub = (ViewStub)view.findViewById(R.id.replyBoxViewStub);
        replyBoxViewStub.setLayoutResource(R.layout.hs__conversational_labelledreplyboxview);
        replyBoxViewStub.inflate();
    }

    @Override
    protected void initConversationVM() {
        this.conversationVM = HelpshiftContext.getCoreApi().getConversationalViewModel(this.shouldShowConversationHistory, this.conversationId, (ConversationalRenderer)((Object)this.renderer), this.retainMessageBoxOnUI);
    }

    @Override
    protected void initRenderer(RecyclerView messagesRecyclerView, View confirmationBoxView, View scrollIndicator, View unreadMessagesIndicatorDot) {
        this.renderer = new ConversationalFragmentRenderer(this.getContext(), messagesRecyclerView, this.getView(), confirmationBoxView, this, scrollIndicator, unreadMessagesIndicatorDot, this.getSupportFragment(), this);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.networkConnectivityReceiver = new HSNetworkConnectivityReceiver(this.getContext());
        this.networkConnectivityReceiver.addListener(this);
        this.getActivity().registerReceiver((BroadcastReceiver)this.networkConnectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        HelpshiftContext.getCoreApi().getAutoRetryFailedEventDM().resetBackoff();
        ConversationDM activeConversation = this.conversationVM.viewableConversation.getActiveConversation();
        String serverId = activeConversation.serverId;
        String preConversationServerId = activeConversation.preConversationServerId;
        if (StringUtils.isEmpty(serverId)) {
            HashMap<String, Object> data = null;
            if (!StringUtils.isEmpty(preConversationServerId)) {
                data = new HashMap<String, Object>();
                data.put("preissue_id", preConversationServerId);
            }
            this.conversationVM.pushAnalyticsEvent(AnalyticsEventType.REPORTED_ISSUE, data);
        }
        HelpshiftContext.getCoreApi().getAutoRetryFailedEventDM().sendEvents(AutoRetryFailedEventDM.EventType.CONVERSATION);
    }

    @Override
    public void onPause() {
        this.networkConnectivityReceiver.removeListener(this);
        this.getActivity().unregisterReceiver((BroadcastReceiver)this.networkConnectivityReceiver);
        super.onPause();
    }

    @Override
    public void handleOptionSelected(OptionInputMessageDM message, OptionInput.Option selectedOption, boolean isSkipped) {
        ((ConversationalVM)this.conversationVM).handleOptionSelected(message, selectedOption, isSkipped);
    }

    @Override
    public void onAdminSuggestedQuestionSelected(final MessageDM messageDM, final String questionPublishId, String language) {
        this.getSupportController().onAdminSuggestedQuestionSelected(questionPublishId, language, new SingleQuestionFragment.QuestionReadListener(){

            @Override
            public void onQuestionRead(String questionServerId) {
                ((ConversationalVM)ConversationalFragment.this.conversationVM).handleAdminSuggestedQuestionRead(messageDM, questionServerId, questionPublishId);
            }
        });
    }

    @Override
    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        ((ConversationalRenderer)((Object)this.renderer)).hideReplyValidationFailedError();
        super.onTextChanged(charSequence, i, i1, i2);
    }

    @Override
    public void retryPreIssueCreation() {
        ((ConversationalVM)this.conversationVM).createPreIssue();
    }

    @Override
    public void networkAvailable() {
        ((ConversationalVM)this.conversationVM).onNetworkAvailable();
    }

    @Override
    public void networkUnavailable() {
        ((ConversationalVM)this.conversationVM).onNetworkUnAvailable();
    }

    @Override
    public void onStartNewConversationButtonClick() {
        this.conversationVM.onNewConversationButtonClicked();
    }

    @Override
    public void onListPickerSearchQueryChange(String query) {
        ((ConversationalVM)this.conversationVM).onListPickerSearchQueryChange(query);
    }

    @Override
    public void handleOptionSelectedForPicker(OptionUIModel optionUIModel, boolean isSkipped) {
        ((ConversationalVM)this.conversationVM).handleOptionSelectedForPicker(optionUIModel, isSkipped);
    }

    @Override
    public void setToolbarImportanceForAccessibility(int mode) {
        SupportFragment supportFragment = this.getSupportFragment();
        if (supportFragment != null) {
            supportFragment.setToolbarImportanceForAccessibility(mode);
        }
    }

    @Override
    public void resetToolbarImportanceForAccessibility() {
        SupportFragment supportFragment = this.getSupportFragment();
        if (supportFragment != null) {
            supportFragment.resetToolbarImportanceForAccessibility();
        }
    }

    public boolean onBackPressed() {
        return ((ConversationalRenderer)((Object)this.renderer)).onBackPressed();
    }

    public void onFocusChanged(boolean hasFocus) {
        if (this.renderer != null) {
            ((ConversationalRenderer)((Object)this.renderer)).onFocusChanged(hasFocus);
        }
    }
}

