/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.design.widget.BottomSheetBehavior;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.CardView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.common.StringUtils;
import com.helpshift.common.util.HSDateFormatSpec;
import com.helpshift.conversation.activeconversation.ConversationalRenderer;
import com.helpshift.conversation.activeconversation.message.input.Input;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import com.helpshift.conversation.activeconversation.message.input.TextInput;
import com.helpshift.conversation.viewmodel.OptionUIModel;
import com.helpshift.support.conversations.ConversationFragmentRenderer;
import com.helpshift.support.conversations.ConversationFragmentRouter;
import com.helpshift.support.conversations.ConversationalFragmentRouter;
import com.helpshift.support.conversations.TextWatcherAdapter;
import com.helpshift.support.conversations.picker.PickerAdapter;
import com.helpshift.support.fragments.IToolbarMenuItemRenderer;
import com.helpshift.support.util.KeyboardUtil;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.Styles;
import com.helpshift.views.bottomsheet.HSBottomSheet;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class ConversationalFragmentRenderer
extends ConversationFragmentRenderer
implements ConversationalRenderer {
    private static final int OPTIONS_PICKER_PEEK_HEIGHT = 142;
    TextView skipBubbleTextView;
    LinearLayout skipOutterBubble;
    TextView replyValidationFailedView;
    RecyclerView.ItemDecoration lastMessageItemDecor;
    LinearLayout networkErrorFooter;
    private final ConversationalFragmentRouter conversationalFragmentRouter;
    HSBottomSheet pickerBottomSheet;
    BottomSheetBehavior bottomSheetBehavior;
    TextView pickerExpandedHeaderText;
    TextView pickerCollapsedHeaderText;
    View pickerCollapsedShadow;
    View pickerExpandedShadow;
    View pickerExpandedHeader;
    View pickerCollapsedHeader;
    RecyclerView pickerOptionsRecycler;
    ImageView pickerCollapseView;
    ImageView pickerSearchView;
    ImageView pickerClearView;
    ImageView pickerBackView;
    ImageView pickerExpandView;
    EditText pickerHeaderSearchView;
    PickerAdapter pickerAdapter;
    View pickerEmptySearchResultsView;

    ConversationalFragmentRenderer(Context context, RecyclerView messagesRecyclerView, View parentView, View confirmationBoxView, ConversationFragmentRouter conversationFragmentRouter, View scrollIndicator, View unreadIndicatorRedDot, IToolbarMenuItemRenderer menuItemRenderer, ConversationalFragmentRouter conversationalFragmentRouter) {
        super(context, messagesRecyclerView, parentView, confirmationBoxView, conversationFragmentRouter, scrollIndicator, unreadIndicatorRedDot, menuItemRenderer);
        this.skipBubbleTextView = (TextView)parentView.findViewById(R.id.skipBubbleTextView);
        this.skipOutterBubble = (LinearLayout)parentView.findViewById(R.id.skipOuterBubble);
        this.replyValidationFailedView = (TextView)parentView.findViewById(R.id.errorReplyTextView);
        this.networkErrorFooter = (LinearLayout)parentView.findViewById(R.id.networkErrorFooter);
        this.conversationalFragmentRouter = conversationalFragmentRouter;
    }

    @Override
    public void showInput(Input input) {
        if (input == null) {
            this.resetReplyFieldToNormalTextInput();
            return;
        }
        if (input instanceof TextInput) {
            this.renderForTextInput((TextInput)input);
        } else if (input instanceof OptionInput) {
            this.hideSendReplyUI();
            this.hideKeyboard();
        }
        this.setMessagesViewBottomPadding();
    }

    @Override
    public void showSkipButton() {
        Styles.setColorFilter(this.parentView.getContext(), this.skipBubbleTextView.getBackground(), R.attr.hs__selectableOptionColor);
        Styles.setColorFilter(this.parentView.getContext(), this.skipOutterBubble.getBackground(), 16842836);
        this.skipOutterBubble.setVisibility(0);
        this.messagesRecyclerView.removeItemDecoration(this.lastMessageItemDecor);
        this.createRecyclerViewLastItemDecor();
        this.messagesRecyclerView.addItemDecoration(this.lastMessageItemDecor);
    }

    @Override
    public void hideSkipButton() {
        this.skipOutterBubble.setVisibility(8);
        this.messagesRecyclerView.removeItemDecoration(this.lastMessageItemDecor);
    }

    @Override
    public void showReplyValidationFailedError(int keyboardType) {
        boolean isInLandscape = this.parentView.getResources().getConfiguration().orientation == 2;
        String errorMessage = "";
        Resources resources = this.context.getResources();
        switch (keyboardType) {
            case 2: {
                if (isInLandscape) {
                    errorMessage = resources.getString(R.string.hs__landscape_email_input_validation_error);
                    break;
                }
                errorMessage = resources.getString(R.string.hs__email_input_validation_error);
                break;
            }
            case 3: {
                if (isInLandscape) {
                    errorMessage = resources.getString(R.string.hs__landscape_number_input_validation_error);
                    break;
                }
                errorMessage = resources.getString(R.string.hs__number_input_validation_error);
                break;
            }
            case 4: {
                if (isInLandscape) {
                    errorMessage = resources.getString(R.string.hs__landscape_date_input_validation_error);
                    break;
                }
                errorMessage = resources.getString(R.string.hs__date_input_validation_error);
                break;
            }
            case 1: {
                errorMessage = resources.getString(R.string.hs__conversation_detail_error);
            }
        }
        if (isInLandscape) {
            AlertDialog.Builder errorMessageDialogBuilder = new AlertDialog.Builder(this.parentView.getContext());
            errorMessageDialogBuilder.setTitle((CharSequence)resources.getString(R.string.hs__landscape_input_validation_dialog_title));
            errorMessageDialogBuilder.setCancelable(true);
            errorMessageDialogBuilder.setMessage((CharSequence)errorMessage);
            errorMessageDialogBuilder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            });
            errorMessageDialogBuilder.create().show();
        } else {
            this.replyValidationFailedView.setText((CharSequence)errorMessage);
            this.replyValidationFailedView.setVisibility(0);
        }
    }

    @Override
    public void hideReplyValidationFailedError() {
        this.replyValidationFailedView.setVisibility(8);
    }

    @Override
    public void showNetworkErrorFooter(int networkError) {
        this.networkErrorFooter.setVisibility(0);
        final TextView networkErrorText = (TextView)this.networkErrorFooter.findViewById(R.id.networkErrorFooterText);
        final TextView tapToRetry = (TextView)this.networkErrorFooter.findViewById(R.id.networkErrorFooterTryAgainText);
        final ProgressBar networkConnectivityProgress = (ProgressBar)this.networkErrorFooter.findViewById(R.id.networkErrorProgressBar);
        final ImageView networkErrorIcon = (ImageView)this.networkErrorFooter.findViewById(R.id.networkErrorIcon);
        networkErrorIcon.setVisibility(0);
        Styles.setDrawable(this.context, (View)networkErrorIcon, R.drawable.hs__network_error, R.attr.hs__errorTextColor);
        networkConnectivityProgress.setVisibility(8);
        final Resources resources = this.context.getResources();
        switch (networkError) {
            case 0: {
                networkErrorText.setText((CharSequence)resources.getString(R.string.hs__network_error_pre_issue_creation));
                tapToRetry.setVisibility(0);
                tapToRetry.setText((CharSequence)(" " + resources.getString(R.string.hs__tap_to_retry)));
                tapToRetry.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        networkErrorText.setText((CharSequence)resources.getString(R.string.hs__connecting));
                        tapToRetry.setVisibility(8);
                        networkErrorIcon.setVisibility(8);
                        networkConnectivityProgress.setVisibility(0);
                        ConversationalFragmentRenderer.this.conversationFragmentRouter.retryPreIssueCreation();
                    }
                });
                break;
            }
            case 1: {
                tapToRetry.setVisibility(8);
                networkErrorText.setText((CharSequence)resources.getString(R.string.hs__no_internet_error));
                break;
            }
            case 2: {
                networkErrorText.setText((CharSequence)resources.getString(R.string.hs__network_reconnecting_error));
                tapToRetry.setVisibility(8);
                networkErrorIcon.setVisibility(8);
                networkConnectivityProgress.setVisibility(0);
            }
        }
    }

    @Override
    public void hideNetworkErrorFooter() {
        this.networkErrorFooter.setVisibility(8);
    }

    @Override
    public void updateListPickerOptions(List<OptionUIModel> optionUIModels) {
        if (this.pickerAdapter != null) {
            this.showPickerContent();
            this.pickerAdapter.dispatchUpdates(optionUIModels);
        }
    }

    @Override
    public void hideListPicker(boolean hideSmoothly) {
        if (this.bottomSheetBehavior == null || this.pickerBottomSheet == null) {
            return;
        }
        if (hideSmoothly) {
            this.bottomSheetBehavior.setHideable(true);
            this.pickerBottomSheet.removeAllBottomSheetCallbacks();
            this.pickerBottomSheet.addBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(){

                public void onStateChanged(@NonNull View view, int i) {
                    if (i == 5) {
                        ConversationalFragmentRenderer.this.removePickerViewFromWindow();
                    }
                }

                public void onSlide(@NonNull View view, float slideOffset) {
                }
            });
            this.bottomSheetBehavior.setState(5);
        } else {
            this.removePickerViewFromWindow();
        }
        this.resetAccessibilityForToolbar();
        this.hideKeyboard();
        this.setBottomOffset(this.parentView, 0);
        this.hideSkipButton();
    }

    void removePickerViewFromWindow() {
        this.pickerBottomSheet.remove();
        this.pickerBottomSheet = null;
    }

    private void setBottomOffset(View view, int offset) {
        int paddingLeft = view.getPaddingLeft();
        int paddingRight = view.getPaddingRight();
        int paddingTop = view.getPaddingTop();
        int newBottomPadding = (int)Styles.dpToPx(this.context, offset);
        view.setPadding(paddingLeft, paddingTop, paddingRight, newBottomPadding);
    }

    @Override
    public void showEmptyListPickerView() {
        this.showEmptyPickerView();
    }

    private void showPickerContent() {
        if (this.pickerEmptySearchResultsView.isShown()) {
            this.pickerEmptySearchResultsView.setVisibility(8);
        }
        if (!this.pickerOptionsRecycler.isShown()) {
            this.pickerOptionsRecycler.setVisibility(0);
        }
    }

    private void showEmptyPickerView() {
        if (!this.pickerEmptySearchResultsView.isShown()) {
            this.pickerEmptySearchResultsView.setVisibility(0);
        }
        if (this.pickerOptionsRecycler.isShown()) {
            this.pickerOptionsRecycler.setVisibility(8);
        }
    }

    @Override
    public void showListPicker(List<OptionUIModel> optionUIModels, String pickerTitle, boolean required, String skipLabel) {
        if (this.pickerBottomSheet != null) {
            return;
        }
        boolean isTablet = com.helpshift.support.util.Styles.isTablet(this.parentView.getContext());
        float dimOpacity = isTablet ? 0.8f : 1.0f;
        this.pickerBottomSheet = new HSBottomSheet.Builder(((Activity)this.context).getWindow()).contentView(R.layout.hs__picker_layout).referenceView((View)this.messagesRecyclerView).enableDimAnimation(true).dimOpacity(dimOpacity).inflateAndBuild();
        this.initPickerViews(pickerTitle);
        this.bottomSheetBehavior.setPeekHeight((int)Styles.dpToPx(this.context, 142.0f));
        this.pickerAdapter = new PickerAdapter(optionUIModels, this.conversationalFragmentRouter);
        this.pickerOptionsRecycler.setAdapter((RecyclerView.Adapter)this.pickerAdapter);
        Styles.setGradientBackground(this.pickerCollapsedShadow, ContextCompat.getColor((Context)this.context, (int)R.color.hs__color_40000000), 0, GradientDrawable.Orientation.BOTTOM_TOP);
        this.hideSendReplyUI();
        this.handleSkipButtonRenderingForPicker(required, skipLabel);
        this.hideKeyboard();
        int offset = this.calculatePickerBottomOffset(isTablet);
        this.setBottomOffset(this.parentView, 142 - offset);
        this.registerListeners();
        this.initBottomSheetCallback();
        this.showPickerContent();
        this.pickerBottomSheet.show();
    }

    private int calculatePickerBottomOffset(boolean isTablet) {
        int offset = 14;
        if (isTablet) {
            offset += (int)this.parentView.getResources().getDimension(R.dimen.activity_horizontal_margin_large);
            offset += 4;
            CardView convOutterCardView = (CardView)this.parentView.findViewById(R.id.hs__conversation_cardview_container);
            offset = (int)((float)offset + convOutterCardView.getCardElevation());
        }
        return offset;
    }

    private void handleSkipButtonRenderingForPicker(boolean required, String skipLabel) {
        if (!required && !StringUtils.isEmpty(skipLabel)) {
            this.setPickerOptionsInputSkipListener();
            this.skipBubbleTextView.setText((CharSequence)skipLabel);
            this.showSkipButton();
        } else {
            this.hideSkipButton();
        }
    }

    private void initBottomSheetCallback() {
        this.pickerBottomSheet.addBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(){

            public void onStateChanged(@NonNull View view, int state) {
                if (4 == state) {
                    ConversationalFragmentRenderer.this.onOptionPickerCollapsed();
                } else if (3 == state) {
                    ConversationalFragmentRenderer.this.onOptionPickerExpanded();
                }
            }

            public void onSlide(@NonNull View view, float slideOffset) {
                if ((double)slideOffset > 0.5 && ConversationalFragmentRenderer.this.bottomSheetBehavior.getState() == 2) {
                    ConversationalFragmentRenderer.this.onOptionPickerExpanded();
                } else if (ConversationalFragmentRenderer.this.bottomSheetBehavior.getState() == 2) {
                    ConversationalFragmentRenderer.this.onOptionPickerCollapsed();
                }
            }
        });
    }

    @Override
    public void hidePickerClearButton() {
        if (this.pickerClearView.isShown()) {
            this.pickerClearView.setVisibility(8);
        }
    }

    @Override
    public void showPickerClearButton() {
        if (!this.pickerClearView.isShown()) {
            this.pickerClearView.setVisibility(0);
        }
    }

    @Override
    public boolean onBackPressed() {
        if (this.pickerBottomSheet != null && this.bottomSheetBehavior.getState() == 3) {
            this.bottomSheetBehavior.setState(4);
            return true;
        }
        return false;
    }

    private void onOptionPickerExpanded() {
        this.pickerCollapsedShadow.setVisibility(8);
        Styles.setGradientBackground(this.pickerExpandedShadow, ContextCompat.getColor((Context)this.context, (int)R.color.hs__color_40000000), 0, GradientDrawable.Orientation.TOP_BOTTOM);
        this.pickerExpandedHeader.setVisibility(0);
        this.pickerCollapsedHeader.setVisibility(8);
        if (Build.VERSION.SDK_INT >= 19 && this.parentView != null) {
            this.parentView.setImportantForAccessibility(4);
            this.conversationalFragmentRouter.setToolbarImportanceForAccessibility(4);
        }
    }

    private void onOptionPickerCollapsed() {
        this.pickerCollapsedShadow.setVisibility(0);
        Styles.setGradientBackground(this.pickerCollapsedShadow, ContextCompat.getColor((Context)this.context, (int)R.color.hs__color_40000000), 0, GradientDrawable.Orientation.BOTTOM_TOP);
        this.showPickerContent();
        this.resetPickerSearchViewToNormalHeader();
        this.pickerCollapsedHeader.setVisibility(0);
        this.pickerExpandedHeader.setVisibility(8);
        this.pickerOptionsRecycler.scrollToPosition(0);
        this.resetAccessibilityForToolbar();
    }

    private void resetAccessibilityForToolbar() {
        if (Build.VERSION.SDK_INT >= 19 && this.parentView != null) {
            this.parentView.setImportantForAccessibility(0);
            this.conversationalFragmentRouter.resetToolbarImportanceForAccessibility();
        }
    }

    private void registerListeners() {
        this.pickerHeaderSearchView.addTextChangedListener((TextWatcher)new TextWatcherAdapter(){

            @Override
            public void onTextChanged(CharSequence charSequence, int start, int count, int after) {
                if (charSequence != null) {
                    ConversationalFragmentRenderer.this.conversationalFragmentRouter.onListPickerSearchQueryChange(charSequence.toString());
                }
            }
        });
        this.pickerHeaderSearchView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int actionId, KeyEvent event) {
                if (actionId == 3) {
                    ConversationalFragmentRenderer.this.hideKeyboard();
                    return true;
                }
                return false;
            }
        });
        this.pickerSearchView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationalFragmentRenderer.this.pickerHeaderSearchView.setVisibility(0);
                ConversationalFragmentRenderer.this.pickerExpandedHeaderText.setVisibility(8);
                ConversationalFragmentRenderer.this.pickerSearchView.setVisibility(8);
                ConversationalFragmentRenderer.this.pickerHeaderSearchView.requestFocus();
                ConversationalFragmentRenderer.this.pickerBottomSheet.setDraggable(false);
                ConversationalFragmentRenderer.this.pickerCollapseView.setVisibility(8);
                ConversationalFragmentRenderer.this.pickerBackView.setVisibility(0);
                KeyboardUtil.showKeyboard(ConversationalFragmentRenderer.this.context, (View)ConversationalFragmentRenderer.this.pickerHeaderSearchView);
                ConversationalFragmentRenderer.this.pickerBottomSheet.setDraggable(false);
            }
        });
        this.pickerBackView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationalFragmentRenderer.this.resetPickerSearchViewToNormalHeader();
            }
        });
        this.pickerClearView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationalFragmentRenderer.this.pickerHeaderSearchView.setText((CharSequence)"");
                ConversationalFragmentRenderer.this.pickerClearView.setVisibility(8);
            }
        });
        this.pickerCollapseView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationalFragmentRenderer.this.bottomSheetBehavior.setState(4);
                ConversationalFragmentRenderer.this.hideKeyboard();
            }
        });
        this.pickerCollapsedHeader.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationalFragmentRenderer.this.bottomSheetBehavior.setState(3);
            }
        });
    }

    void resetPickerSearchViewToNormalHeader() {
        this.pickerHeaderSearchView.setVisibility(8);
        this.pickerExpandedHeaderText.setVisibility(0);
        this.pickerHeaderSearchView.setText((CharSequence)"");
        this.pickerBackView.setVisibility(8);
        this.pickerCollapseView.setVisibility(0);
        this.pickerClearView.setVisibility(8);
        this.pickerSearchView.setVisibility(0);
        this.hideKeyboard();
        this.pickerBottomSheet.setDraggable(true);
    }

    private void initPickerViews(String pickerTitle) {
        this.bottomSheetBehavior = this.pickerBottomSheet.getBottomSheetBehaviour();
        View pickerSheetContent = this.pickerBottomSheet.getBottomSheetContentView();
        this.pickerCollapsedShadow = pickerSheetContent.findViewById(R.id.hs__picker_collapsed_shadow);
        this.pickerExpandedShadow = pickerSheetContent.findViewById(R.id.hs__picker_expanded_shadow);
        this.pickerOptionsRecycler = (RecyclerView)pickerSheetContent.findViewById(R.id.hs__optionsList);
        this.pickerOptionsRecycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(pickerSheetContent.getContext(), 1, false));
        this.pickerSearchView = (ImageView)pickerSheetContent.findViewById(R.id.hs__picker_action_search);
        this.pickerClearView = (ImageView)pickerSheetContent.findViewById(R.id.hs__picker_action_clear);
        this.pickerCollapseView = (ImageView)pickerSheetContent.findViewById(R.id.hs__picker_action_collapse);
        this.pickerBackView = (ImageView)pickerSheetContent.findViewById(R.id.hs__picker_action_back);
        this.pickerHeaderSearchView = (EditText)pickerSheetContent.findViewById(R.id.hs__picker_header_search);
        this.pickerExpandedHeaderText = (TextView)pickerSheetContent.findViewById(R.id.hs__expanded_picker_header_text);
        this.pickerExpandedHeader = pickerSheetContent.findViewById(R.id.hs__picker_expanded_header);
        this.pickerCollapsedHeader = pickerSheetContent.findViewById(R.id.hs__picker_collapsed_header);
        this.pickerCollapsedHeaderText = (TextView)pickerSheetContent.findViewById(R.id.hs__collapsed_picker_header_text);
        this.pickerEmptySearchResultsView = pickerSheetContent.findViewById(R.id.hs__empty_picker_view);
        this.pickerExpandView = (ImageView)pickerSheetContent.findViewById(R.id.hs__picker_action_expand);
        this.pickerExpandedHeaderText.setText((CharSequence)pickerTitle);
        this.pickerCollapsedHeaderText.setText((CharSequence)pickerTitle);
        String collapsedPickerHeaderVoiceOver = this.parentView.getResources().getString(R.string.hs__picker_options_expand_header_voice_over, new Object[]{pickerTitle});
        this.pickerCollapsedHeader.setContentDescription((CharSequence)collapsedPickerHeaderVoiceOver);
        this.pickerCollapsedHeaderText.setContentDescription((CharSequence)collapsedPickerHeaderVoiceOver);
        Styles.setColorFilter(this.context, this.pickerSearchView.getDrawable(), R.attr.hs__expandedPickerIconColor);
        Styles.setColorFilter(this.context, this.pickerBackView.getDrawable(), R.attr.hs__expandedPickerIconColor);
        Styles.setColorFilter(this.context, this.pickerCollapseView.getDrawable(), R.attr.hs__expandedPickerIconColor);
        Styles.setColorFilter(this.context, this.pickerClearView.getDrawable(), R.attr.hs__expandedPickerIconColor);
        Styles.setColorFilter(this.context, this.pickerExpandView.getDrawable(), R.attr.hs__collapsedPickerIconColor);
    }

    private void resetReplyFieldToNormalTextInput() {
        this.replyField.setInputType(147457);
        this.replyField.setHint(R.string.hs__chat_hint);
    }

    @Override
    public void onFocusChanged(boolean hasFocus) {
        if (!hasFocus) {
            this.hideListPicker(true);
        }
    }

    @Override
    public void destroy() {
        this.hideListPicker(true);
        super.destroy();
    }

    @Override
    public void showSendReplyUI() {
        super.showSendReplyUI();
        LinearLayout labelLayout = (LinearLayout)this.parentView.findViewById(R.id.replyBoxLabelLayout);
        labelLayout.setVisibility(8);
        this.replyField.setFocusableInTouchMode(true);
        this.replyField.setOnClickListener(null);
        this.resetReplyFieldToNormalTextInput();
        this.hideSkipButton();
    }

    @Override
    public void hideSendReplyUI() {
        super.hideSendReplyUI();
        this.hideSkipButton();
    }

    private void setTextInputSkipListener() {
        this.skipBubbleTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationalFragmentRenderer.this.conversationFragmentRouter.onSkipClick();
            }
        });
    }

    private void setPickerOptionsInputSkipListener() {
        this.skipBubbleTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConversationalFragmentRenderer.this.conversationalFragmentRouter.handleOptionSelectedForPicker(null, true);
            }
        });
    }

    private void createRecyclerViewLastItemDecor() {
        if (this.lastMessageItemDecor != null) {
            return;
        }
        this.lastMessageItemDecor = new RecyclerView.ItemDecoration(){

            public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
                int itemPosition = parent.getChildAdapterPosition(view);
                if (itemPosition == -1) {
                    return;
                }
                RecyclerView.Adapter adapter = parent.getAdapter();
                if (adapter != null && ConversationalFragmentRenderer.this.skipOutterBubble.getVisibility() == 0 && itemPosition == adapter.getItemCount() - 1) {
                    DisplayMetrics metrics = parent.getContext().getResources().getDisplayMetrics();
                    int padding = (int)TypedValue.applyDimension((int)1, (float)80.0f, (DisplayMetrics)metrics);
                    outRect.set(outRect.left, outRect.top, outRect.right, padding);
                }
            }
        };
    }

    DatePickerDialog createDatePickerForReplyField() {
        DatePickerDialog.OnDateSetListener onDateSetListener = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                Calendar newDate = Calendar.getInstance();
                newDate.set(year, monthOfYear, dayOfMonth);
                Locale locale = HelpshiftContext.getCoreApi().getLocaleProviderDM().getCurrentLocale();
                String formatterDate = HSDateFormatSpec.getDateFormatter("EEEE, MMMM dd, yyyy", locale).format(newDate.getTime());
                ConversationalFragmentRenderer.this.replyField.setText((CharSequence)formatterDate);
            }
        };
        Calendar calendar = Calendar.getInstance();
        try {
            String draft = this.replyField.getText().toString();
            if (!StringUtils.isEmpty(draft)) {
                Locale locale = HelpshiftContext.getCoreApi().getLocaleProviderDM().getCurrentLocale();
                Date draftDate = HSDateFormatSpec.getDateFormatter("EEEE, MMMM dd, yyyy", locale).parse(draft);
                calendar.setTime(draftDate);
            }
        }
        catch (ParseException draft) {
            // empty catch block
        }
        DatePickerDialog dialog = new DatePickerDialog(this.parentView.getContext(), onDateSetListener, calendar.get(1), calendar.get(2), calendar.get(5));
        return dialog;
    }

    private void renderForTextInput(TextInput textInput) {
        this.replyField.setFocusableInTouchMode(true);
        this.replyField.setOnClickListener(null);
        if (!TextUtils.isEmpty((CharSequence)textInput.inputLabel)) {
            LinearLayout labelLayout = (LinearLayout)this.parentView.findViewById(R.id.replyBoxLabelLayout);
            labelLayout.setVisibility(0);
            TextView labelText = (TextView)this.replyBoxView.findViewById(R.id.replyFieldLabel);
            labelText.setText((CharSequence)textInput.inputLabel);
        }
        String hintText = TextUtils.isEmpty((CharSequence)textInput.placeholder) ? "" : textInput.placeholder;
        this.replyField.setHint((CharSequence)hintText);
        int inputType = 131072;
        switch (textInput.keyboard) {
            case 1: {
                inputType = inputType | 1 | 0 | 0x4000;
                break;
            }
            case 3: {
                inputType = inputType | 2 | 0x2000;
                break;
            }
            case 2: {
                inputType = inputType | 1 | 0x20;
                break;
            }
            case 4: {
                this.hideKeyboard();
                inputType = 0;
                this.replyField.setFocusableInTouchMode(false);
                this.replyField.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        DatePickerDialog dialog = ConversationalFragmentRenderer.this.createDatePickerForReplyField();
                        dialog.show();
                    }
                });
                break;
            }
            default: {
                this.resetReplyFieldToNormalTextInput();
            }
        }
        this.replyField.setInputType(inputType);
        if (!textInput.required && !TextUtils.isEmpty((CharSequence)textInput.skipLabel)) {
            this.setTextInputSkipListener();
            this.skipBubbleTextView.setText((CharSequence)textInput.skipLabel);
            this.showSkipButton();
        } else {
            this.hideSkipButton();
        }
        this.replyBoxView.setVisibility(0);
    }
}

