/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations;

import android.os.Handler;
import android.support.v7.widget.RecyclerView;
import android.view.View;

public class HSRecyclerViewScrollListener
extends RecyclerView.OnScrollListener {
    private final Handler uiHandler;
    private final RecyclerViewScrollCallback callback;
    private boolean isScrollStateChangeHandled = false;

    public HSRecyclerViewScrollListener(Handler handler, RecyclerViewScrollCallback callback) {
        this.uiHandler = handler;
        this.callback = callback;
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        this.isScrollStateChangeHandled = false;
        if (newState == 0) {
            this.computeAndNotifyCallback(recyclerView);
        }
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        if (this.isScrollStateChangeHandled && recyclerView.getScrollState() != 0) {
            return;
        }
        this.isScrollStateChangeHandled = true;
        this.computeAndNotifyCallback(recyclerView);
    }

    private void computeAndNotifyCallback(RecyclerView recyclerView) {
        boolean canScrollMoreToTop;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        boolean isLastChildOfAdapterVisible = true;
        if (layoutManager != null) {
            View lastChildView;
            int totalItemInAdapter = layoutManager.getItemCount();
            int totalChildCountInView = layoutManager.getChildCount();
            if (totalChildCountInView > 0 && (lastChildView = layoutManager.getChildAt(totalChildCountInView - 1)) != null) {
                int adapterPositionOfTheView = layoutManager.getPosition(lastChildView);
                int absoluteAdapterPositionOfTheView = adapterPositionOfTheView + 1;
                if (adapterPositionOfTheView != -1 && totalItemInAdapter != absoluteAdapterPositionOfTheView) {
                    isLastChildOfAdapterVisible = false;
                }
            }
        }
        if (!(canScrollMoreToTop = recyclerView.canScrollVertically(-1))) {
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    HSRecyclerViewScrollListener.this.callback.onScrolledToTop();
                }
            });
        }
        if (isLastChildOfAdapterVisible) {
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    HSRecyclerViewScrollListener.this.callback.onScrolledToBottom();
                }
            });
        }
        if (!isLastChildOfAdapterVisible) {
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    HSRecyclerViewScrollListener.this.callback.onScrolling();
                }
            });
        }
    }

    static interface RecyclerViewScrollCallback {
        public void onScrolledToTop();

        public void onScrolledToBottom();

        public void onScrolling();
    }
}

