/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ContextMenu;
import android.view.ViewGroup;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.ConversationFooterState;
import com.helpshift.conversation.activeconversation.message.HistoryLoadingState;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.OptionInputMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import com.helpshift.support.conversations.messages.ConversationFooterViewBinder;
import com.helpshift.support.conversations.messages.HistoryLoadingViewBinder;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.support.conversations.messages.MessageViewType;
import com.helpshift.support.conversations.messages.MessageViewTypeConverter;
import com.helpshift.support.conversations.messages.MessagesAdapterClickListener;
import java.util.List;

public class MessagesAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements MessageViewDataBinder.MessageItemClickListener,
ConversationFooterViewBinder.ConversationFooterClickListener,
HistoryLoadingViewBinder.HistoryLoadingClickListener {
    private MessageViewTypeConverter messageViewTypeConverter;
    private List<MessageDM> messages;
    private MessagesAdapterClickListener messagesAdapterClickListener;
    private ConversationFooterState conversationFooterState = ConversationFooterState.NONE;
    private boolean isAgentTypingIndicatorVisible = false;
    private HistoryLoadingState historyLoadingState = HistoryLoadingState.NONE;

    public MessagesAdapter(Context context, List<MessageDM> messages, MessagesAdapterClickListener messagesAdapterClickListener) {
        this.messageViewTypeConverter = new MessageViewTypeConverter(context);
        this.messages = messages;
        this.messagesAdapterClickListener = messagesAdapterClickListener;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == MessageViewType.HISTORY_LOADING_VIEW.key) {
            HistoryLoadingViewBinder historyLoadingViewBinder = this.messageViewTypeConverter.getHistoryLoadingViewBinder();
            historyLoadingViewBinder.setHistoryLoadingClickListener(this);
            return historyLoadingViewBinder.createViewHolder(parent);
        }
        if (viewType == MessageViewType.CONVERSATION_FOOTER.key) {
            ConversationFooterViewBinder conversationFooterViewBinder = this.messageViewTypeConverter.getConversationFooterViewBinder();
            conversationFooterViewBinder.setConversationFooterClickListener(this);
            return conversationFooterViewBinder.createViewHolder(parent);
        }
        if (viewType == MessageViewType.AGENT_TYPING_FOOTER.key) {
            return this.messageViewTypeConverter.getAgentTypingMessageDataBinder().createViewHolder(parent);
        }
        MessageViewDataBinder messageViewDataBinder = this.messageViewTypeConverter.viewTypeToDataBinder(viewType);
        messageViewDataBinder.setMessageItemClickListener(this);
        return messageViewDataBinder.createViewHolder(parent);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int adapterPosition) {
        int viewType = holder.getItemViewType();
        if (viewType == MessageViewType.HISTORY_LOADING_VIEW.key) {
            this.messageViewTypeConverter.getHistoryLoadingViewBinder().bind((HistoryLoadingViewBinder.ViewHolder)holder, this.historyLoadingState);
        } else if (viewType == MessageViewType.CONVERSATION_FOOTER.key) {
            this.messageViewTypeConverter.getConversationFooterViewBinder().bind((ConversationFooterViewBinder.ViewHolder)holder, this.conversationFooterState);
        } else if (viewType != MessageViewType.AGENT_TYPING_FOOTER.key) {
            MessageDM message = this.getMessageFromUIMessageList(adapterPosition);
            this.messageViewTypeConverter.viewTypeToDataBinder(viewType).bind(holder, message);
        }
    }

    public int getItemViewType(int adapterPosition) {
        if (adapterPosition < this.getHeaderCount()) {
            return this.getHeaderViewType();
        }
        if (adapterPosition < this.getHeaderCount() + this.getMessageCount()) {
            return this.messageViewTypeConverter.messageToViewType(this.getMessageFromUIMessageList(adapterPosition));
        }
        return this.getFooterViewType(adapterPosition);
    }

    public int getItemCount() {
        return this.getHeaderCount() + this.getMessageCount() + this.getFooterCount();
    }

    public void onItemRangeInserted(int startPosition, int itemCount) {
        this.notifyItemRangeInserted(startPosition + this.getHeaderCount(), itemCount);
    }

    public void onItemRangeChanged(int startPosition, int itemCount) {
        this.notifyItemRangeChanged(startPosition + this.getHeaderCount(), itemCount);
    }

    public void onItemRangeRemoved(int startPosition, int itemCount) {
        this.notifyItemRangeRemoved(startPosition + this.getHeaderCount(), itemCount);
    }

    private int getHeaderCount() {
        int count = 0;
        if (this.historyLoadingState != HistoryLoadingState.NONE) {
            ++count;
        }
        return count;
    }

    private int getFooterCount() {
        int count = 0;
        if (this.isAgentTypingIndicatorVisible) {
            ++count;
        }
        if (this.conversationFooterState != ConversationFooterState.NONE) {
            ++count;
        }
        return count;
    }

    private MessageDM getMessageFromUIMessageList(int adapterPosition) {
        int index = adapterPosition - this.getHeaderCount();
        return this.messages.get(index);
    }

    @Override
    public void onAdminMessageLinkClicked(String url, MessageDM messageDM) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.onAdminMessageLinkClicked(url, messageDM);
        }
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu2, String textToCopy) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.onCreateContextMenu(menu2, textToCopy);
        }
    }

    @Override
    public void retryMessage(int adapterPosition) {
        if (this.messagesAdapterClickListener != null) {
            MessageDM readableMessage = this.getMessageFromUIMessageList(adapterPosition);
            this.messagesAdapterClickListener.retryMessage(readableMessage);
        }
    }

    @Override
    public void launchImagePicker(RequestScreenshotMessageDM message) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.launchImagePicker(message);
        }
    }

    @Override
    public void handleReplyReviewButtonClick(RequestAppReviewMessageDM message) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.handleReplyReviewButtonClick(message);
        }
    }

    @Override
    public void onScreenshotMessageClicked(ScreenshotMessageDM message) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.onScreenshotMessageClicked(message);
        }
    }

    @Override
    public void handleGenericAttachmentMessageClick(AdminAttachmentMessageDM message) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.handleGenericAttachmentMessageClick(message);
        }
    }

    @Override
    public void handleAdminImageAttachmentMessageClick(AdminImageAttachmentMessageDM message) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.handleAdminImageAttachmentMessageClick(message);
        }
    }

    @Override
    public void handleOptionSelected(OptionInputMessageDM message, OptionInput.Option selectedOption, boolean isSkipped) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.handleOptionSelected(message, selectedOption, isSkipped);
        }
    }

    @Override
    public void onAdminSuggestedQuestionSelected(MessageDM messageDM, String questionPublishId, String language) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.onAdminSuggestedQuestionSelected(messageDM, questionPublishId, language);
        }
    }

    public void setAgentTypingIndicatorVisibility(boolean agentTypingIndicatorVisible) {
        if (this.isAgentTypingIndicatorVisible != agentTypingIndicatorVisible) {
            this.isAgentTypingIndicatorVisible = agentTypingIndicatorVisible;
            if (agentTypingIndicatorVisible) {
                this.notifyItemRangeInserted(this.messages.size(), 1);
            } else {
                this.notifyItemRangeRemoved(this.messages.size(), 1);
            }
        }
    }

    public void setHistoryLoadingState(HistoryLoadingState newHistoryLoadingState) {
        if (newHistoryLoadingState == null || this.historyLoadingState == newHistoryLoadingState) {
            return;
        }
        if (this.historyLoadingState == HistoryLoadingState.NONE) {
            this.historyLoadingState = newHistoryLoadingState;
            this.notifyItemInserted(0);
        } else if (newHistoryLoadingState == HistoryLoadingState.NONE) {
            this.historyLoadingState = newHistoryLoadingState;
            this.notifyItemRemoved(0);
        } else {
            this.historyLoadingState = newHistoryLoadingState;
            this.notifyItemChanged(0);
        }
    }

    private int getHeaderViewType() {
        return MessageViewType.HISTORY_LOADING_VIEW.key;
    }

    private int getFooterViewType(int adapterPosition) {
        int position = adapterPosition - (this.getHeaderCount() + this.getMessageCount());
        int returnType = -1;
        boolean isConversationFooterVisible = this.conversationFooterState != ConversationFooterState.NONE;
        switch (position) {
            case 0: {
                if (this.isAgentTypingIndicatorVisible) {
                    returnType = MessageViewType.AGENT_TYPING_FOOTER.key;
                    break;
                }
                if (!isConversationFooterVisible) break;
                returnType = MessageViewType.CONVERSATION_FOOTER.key;
                break;
            }
            case 1: {
                if (!isConversationFooterVisible) break;
                returnType = MessageViewType.CONVERSATION_FOOTER.key;
            }
        }
        return returnType;
    }

    public void setConversationFooterState(ConversationFooterState conversationFooter) {
        if (conversationFooter == null) {
            conversationFooter = ConversationFooterState.NONE;
        }
        this.conversationFooterState = conversationFooter;
        this.notifyDataSetChanged();
    }

    @Override
    public void onStartNewConversationButtonClick() {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.onStartNewConversationButtonClick();
        }
    }

    @Override
    public void onCSATSurveySubmitted(int rating, String feedback) {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.onCSATSurveySubmitted(rating, feedback);
        }
    }

    public void unregisterAdapterClickListener() {
        this.messagesAdapterClickListener = null;
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    @Override
    public void onHistoryLoadingRetryClicked() {
        if (this.messagesAdapterClickListener != null) {
            this.messagesAdapterClickListener.onHistoryLoadingRetryClicked();
        }
    }
}

