/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations;

import android.os.Bundle;
import android.support.design.widget.TextInputEditText;
import android.support.design.widget.TextInputLayout;
import android.support.v7.widget.CardView;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.viewmodel.NewConversationVM;
import com.helpshift.support.Faq;
import com.helpshift.support.conversations.BaseConversationFragment;
import com.helpshift.support.conversations.NewConversationFragmentRenderer;
import com.helpshift.support.conversations.NewConversationRouter;
import com.helpshift.support.conversations.TextWatcherAdapter;
import com.helpshift.support.fragments.HSMenuItemType;
import com.helpshift.support.fragments.ScreenshotPreviewFragment;
import com.helpshift.support.util.AppSessionConstants;
import com.helpshift.support.util.KeyboardUtil;
import com.helpshift.util.HelpshiftContext;
import java.util.ArrayList;

public class NewConversationFragment
extends BaseConversationFragment
implements NewConversationRouter {
    public static final String SEARCH_PERFORMED = "search_performed";
    public static final String SOURCE_SEARCH_QUERY = "source_search_query";
    public static final String SHOULD_DROP_META = "dropMeta";
    public static final String FRAGMENT_TAG = "HSNewConversationFragment";
    NewConversationVM newConversationVM;
    private NewConversationFragmentRenderer renderer;
    private TextInputEditText descriptionField;
    private ImagePickerFile selectedImageFile;
    private boolean shouldUpdateAttachment;

    public static NewConversationFragment newInstance(Bundle bundle) {
        NewConversationFragment fragment = new NewConversationFragment();
        fragment.setArguments(bundle);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__new_conversation_fragment, container, false);
    }

    @Override
    public void onStart() {
        super.onStart();
        if (!this.isChangingConfigurations()) {
            HelpshiftContext.getCoreApi().getConversationInboxDM().deleteCachedFilesForResolvedConversations();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        this.newConversationVM.initialize();
        if (!this.isChangingConfigurations()) {
            HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.REPORTED_ISSUE);
        }
        this.descriptionField.requestFocus();
        KeyboardUtil.showKeyboard(this.getContext(), (View)this.descriptionField);
        this.newConversationVM.setConversationViewState(1);
    }

    @Override
    protected int getScreenshotMode() {
        return 1;
    }

    @Override
    protected AppSessionConstants.Screen getViewName() {
        return AppSessionConstants.Screen.NEW_CONVERSATION;
    }

    @Override
    protected String getToolbarTitle() {
        return this.getString(R.string.hs__new_conversation_header);
    }

    @Override
    protected void onPermissionGranted(int requestCode) {
        switch (requestCode) {
            case 2: {
                Bundle bundle = new Bundle();
                bundle.putInt("key_screenshot_mode", this.getScreenshotMode());
                this.getSupportFragment().launchImagePicker(false, bundle);
            }
        }
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.initialize(view);
        super.onViewCreated(view, savedInstanceState);
        this.setViewListeners(view);
    }

    @Override
    public void onDestroyView() {
        this.newConversationVM.unregisterRenderer(this.renderer);
        this.newConversationVM.setConversationViewState(-1);
        super.onDestroyView();
    }

    @Override
    public void onPause() {
        super.onPause();
        KeyboardUtil.hideKeyboard(this.getContext(), (View)this.descriptionField);
    }

    private void initialize(View view) {
        TextInputLayout descriptionFieldWrapper = (TextInputLayout)view.findViewById(R.id.hs__conversationDetailWrapper);
        descriptionFieldWrapper.setHintEnabled(false);
        descriptionFieldWrapper.setHintAnimationEnabled(false);
        this.descriptionField = (TextInputEditText)view.findViewById(R.id.hs__conversationDetail);
        TextInputLayout nameFieldWrapper = (TextInputLayout)view.findViewById(R.id.hs__usernameWrapper);
        nameFieldWrapper.setHintEnabled(false);
        nameFieldWrapper.setHintAnimationEnabled(false);
        TextInputEditText nameField = (TextInputEditText)view.findViewById(R.id.hs__username);
        TextInputLayout emailFieldWrapper = (TextInputLayout)view.findViewById(R.id.hs__emailWrapper);
        emailFieldWrapper.setHintEnabled(false);
        emailFieldWrapper.setHintAnimationEnabled(false);
        TextInputEditText emailField = (TextInputEditText)view.findViewById(R.id.hs__email);
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.progress_bar);
        ImageView attachmentImage = (ImageView)view.findViewById(R.id.hs__screenshot);
        TextView attachmentFileName = (TextView)view.findViewById(R.id.attachment_file_name);
        TextView attachmentFileSize = (TextView)view.findViewById(R.id.attachment_file_size);
        CardView attachmentContainer = (CardView)view.findViewById(R.id.screenshot_view_container);
        ImageButton attachmentClearButton = (ImageButton)view.findViewById(16908314);
        this.renderer = new NewConversationFragmentRenderer(this.getContext(), descriptionFieldWrapper, this.descriptionField, nameFieldWrapper, nameField, emailFieldWrapper, emailField, progressBar, attachmentImage, attachmentFileName, attachmentFileSize, attachmentContainer, attachmentClearButton, this.getView(), this, this.getSupportFragment());
        this.newConversationVM = HelpshiftContext.getCoreApi().getNewConversationViewModel(this.renderer);
        if (this.shouldUpdateAttachment) {
            this.newConversationVM.setImageAttachment(this.selectedImageFile);
            this.shouldUpdateAttachment = false;
        }
        this.descriptionField.addTextChangedListener((TextWatcher)new TextWatcherAdapter(){

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                NewConversationFragment.this.newConversationVM.setDescription(charSequence.toString());
            }
        });
        nameField.addTextChangedListener((TextWatcher)new TextWatcherAdapter(){

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                NewConversationFragment.this.newConversationVM.setName(charSequence.toString());
            }
        });
        emailField.addTextChangedListener((TextWatcher)new TextWatcherAdapter(){

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                NewConversationFragment.this.newConversationVM.setEmail(charSequence.toString());
            }
        });
        Bundle extras = this.getArguments();
        if (extras != null) {
            String searchQuery = extras.getString(SOURCE_SEARCH_QUERY);
            this.newConversationVM.setSearchQuery(searchQuery);
            boolean shouldDropMeta = extras.getBoolean(SHOULD_DROP_META);
            this.newConversationVM.setShouldDropCustomMetadata(shouldDropMeta);
            boolean wasSearchPerformed = this.getArguments().getBoolean(SEARCH_PERFORMED, false);
            this.newConversationVM.setWasSearchPerformed(wasSearchPerformed);
        }
    }

    private void setViewListeners(View view) {
        this.descriptionField = (TextInputEditText)view.findViewById(R.id.hs__conversationDetail);
        this.descriptionField.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                if (view.getId() == R.id.hs__conversationDetail) {
                    view.getParent().requestDisallowInterceptTouchEvent(true);
                    switch (event.getAction() & 0xFF) {
                        case 1: {
                            view.getParent().requestDisallowInterceptTouchEvent(false);
                        }
                    }
                }
                return false;
            }
        });
        ImageButton clearButton = (ImageButton)view.findViewById(16908314);
        clearButton.setVisibility(8);
        ImageView attachmentImage = (ImageView)view.findViewById(R.id.hs__screenshot);
        clearButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                NewConversationFragment.this.newConversationVM.handleImageAttachmentClearButtonClick();
            }
        });
        attachmentImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                NewConversationFragment.this.newConversationVM.handleImageAttachmentClick();
            }
        });
    }

    public boolean handleScreenshotAction(ScreenshotPreviewFragment.ScreenshotAction action, ImagePickerFile imagePickerFile) {
        switch (action) {
            case ADD: {
                if (this.newConversationVM == null) {
                    this.selectedImageFile = imagePickerFile;
                    this.shouldUpdateAttachment = true;
                } else {
                    this.newConversationVM.setImageAttachment(imagePickerFile);
                }
                return true;
            }
            case REMOVE: {
                if (this.newConversationVM == null) {
                    this.selectedImageFile = null;
                    this.shouldUpdateAttachment = true;
                } else {
                    this.newConversationVM.setImageAttachment(null);
                }
                return true;
            }
        }
        return false;
    }

    public void startNewConversation() {
        this.newConversationVM.startNewConversation();
    }

    @Override
    public void showSearchResultFragment(ArrayList<Faq> questions) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("search_fragment_results", questions);
        this.getSupportController().showConversationSearchResultFragment(bundle);
    }

    @Override
    public void exitNewConversationView() {
        this.getSupportFragment().exitSdkSession();
    }

    @Override
    public void showConversationScreen() {
        if (this.isResumed()) {
            this.getSupportController().startConversationFlow();
        }
    }

    @Override
    public void showAttachmentPreviewScreenFromDraft(ImagePickerFile imagePickerFile) {
        Bundle bundle = new Bundle();
        bundle.putInt("key_screenshot_mode", 2);
        this.getSupportController().startScreenshotPreviewFragment(imagePickerFile, bundle, ScreenshotPreviewFragment.LaunchSource.ATTACHMENT_DRAFT);
    }

    @Override
    public void onAuthenticationFailure() {
        this.getSupportController().onAuthenticationFailure();
    }

    @Override
    public void onCreateOptionMenuCalled() {
        this.newConversationVM.initialize();
    }

    @Override
    public void onMenuItemClicked(HSMenuItemType type) {
        switch (type) {
            case START_NEW_CONVERSATION: {
                this.newConversationVM.showSearchOrStartNewConversation();
                break;
            }
            case SCREENSHOT_ATTACHMENT: {
                Bundle bundle = new Bundle();
                bundle.putInt("key_screenshot_mode", this.getScreenshotMode());
                bundle.putString("key_refers_id", null);
                this.getSupportFragment().launchImagePicker(true, bundle);
            }
        }
    }
}

