/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.design.widget.TextInputEditText;
import android.support.design.widget.TextInputLayout;
import android.support.v7.widget.CardView;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.helpshift.R;
import com.helpshift.common.exception.ExceptionType;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.conversation.viewmodel.NewConversationRenderer;
import com.helpshift.support.conversations.NewConversationRouter;
import com.helpshift.support.fragments.HSMenuItemType;
import com.helpshift.support.fragments.IToolbarMenuItemRenderer;
import com.helpshift.support.model.AttachmentFileSize;
import com.helpshift.support.util.AttachmentUtil;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.views.HSToast;
import java.util.ArrayList;

public class NewConversationFragmentRenderer
implements NewConversationRenderer {
    private final Context context;
    private final TextInputLayout descriptionFieldWrapper;
    private final TextInputEditText descriptionField;
    private final TextInputLayout nameFieldWrapper;
    private final TextInputEditText nameField;
    private final TextInputLayout emailFieldWrapper;
    private final TextInputEditText emailField;
    private final ProgressBar progressBar;
    private final ImageView attachmentImage;
    private final TextView attachmentFileName;
    private final TextView attachmentFileSize;
    private final CardView attachmentContainer;
    private final ImageButton attachmentClearButton;
    private final NewConversationRouter newConversationRouter;
    private final View parentView;
    private final IToolbarMenuItemRenderer menuItemRenderer;

    NewConversationFragmentRenderer(Context context, TextInputLayout descriptionFieldWrapper, TextInputEditText descriptionField, TextInputLayout nameFieldWrapper, TextInputEditText nameField, TextInputLayout emailFieldWrapper, TextInputEditText emailField, ProgressBar progressBar, ImageView attachmentImage, TextView attachmentFileName, TextView attachmentFileSize, CardView attachmentContainer, ImageButton attachmentClearButton, View parentView, NewConversationRouter newConversationRouter, IToolbarMenuItemRenderer menuItemRenderer) {
        this.context = context;
        this.descriptionFieldWrapper = descriptionFieldWrapper;
        this.descriptionField = descriptionField;
        this.nameFieldWrapper = nameFieldWrapper;
        this.nameField = nameField;
        this.emailFieldWrapper = emailFieldWrapper;
        this.emailField = emailField;
        this.progressBar = progressBar;
        this.attachmentImage = attachmentImage;
        this.attachmentFileName = attachmentFileName;
        this.attachmentFileSize = attachmentFileSize;
        this.attachmentContainer = attachmentContainer;
        this.attachmentClearButton = attachmentClearButton;
        this.parentView = parentView;
        this.newConversationRouter = newConversationRouter;
        this.menuItemRenderer = menuItemRenderer;
    }

    private String getText(int resId) {
        return this.context.getText(resId).toString();
    }

    @Override
    public void showDescriptionEmptyError() {
        this.setError(this.descriptionFieldWrapper, this.getText(R.string.hs__conversation_detail_error));
    }

    @Override
    public void showDescriptionLessThanMinimumError() {
        this.setError(this.descriptionFieldWrapper, this.getText(R.string.hs__description_invalid_length_error));
    }

    @Override
    public void showDescriptionOnlySpecialCharactersError() {
        this.setError(this.descriptionFieldWrapper, this.getText(R.string.hs__invalid_description_error));
    }

    @Override
    public void clearDescriptionError() {
        this.setError(this.descriptionFieldWrapper, null);
    }

    @Override
    public void showNameEmptyError() {
        this.setError(this.nameFieldWrapper, this.getText(R.string.hs__username_blank_error));
    }

    @Override
    public void showNameOnlySpecialCharactersError() {
        this.setError(this.nameFieldWrapper, this.getText(R.string.hs__username_blank_error));
    }

    @Override
    public void clearNameError() {
        this.setError(this.nameFieldWrapper, null);
    }

    @Override
    public void showEmailInvalidError() {
        this.setError(this.emailFieldWrapper, this.getText(R.string.hs__invalid_email_error));
    }

    @Override
    public void showEmailEmptyError() {
        this.setError(this.emailFieldWrapper, this.getText(R.string.hs__invalid_email_error));
    }

    @Override
    public void clearEmailError() {
        this.setError(this.emailFieldWrapper, null);
    }

    @Override
    public void hideImageAttachmentButton() {
        this.changeMenuItemVisibility(HSMenuItemType.SCREENSHOT_ATTACHMENT, false);
    }

    @Override
    public void showImageAttachmentButton() {
        this.changeMenuItemVisibility(HSMenuItemType.SCREENSHOT_ATTACHMENT, true);
    }

    @Override
    public void showImageAttachmentContainer(@NonNull String attachmentPath, String attachmentName, Long attachmentSize) {
        Bitmap bitmap = AttachmentUtil.getBitmap(attachmentPath, -1);
        if (bitmap != null) {
            this.attachmentImage.setImageBitmap(bitmap);
            this.attachmentFileName.setText((CharSequence)(attachmentName == null ? "" : attachmentName));
            String formattedFileSize = "";
            if (attachmentSize != null) {
                formattedFileSize = new AttachmentFileSize(attachmentSize.longValue()).getFormattedFileSize();
            }
            this.attachmentFileSize.setText((CharSequence)formattedFileSize);
            this.attachmentImage.setVisibility(0);
            this.attachmentClearButton.setVisibility(0);
            this.attachmentContainer.setVisibility(0);
        }
    }

    @Override
    public void hideImageAttachmentContainer() {
        this.attachmentContainer.setVisibility(8);
        this.attachmentImage.setVisibility(8);
        this.attachmentClearButton.setVisibility(8);
    }

    @Override
    public void setDescription(String description) {
        this.descriptionField.setText((CharSequence)description);
        this.descriptionField.setSelection(this.descriptionField.getText().length());
    }

    @Override
    public void setName(String name) {
        this.nameField.setText((CharSequence)name);
        this.nameField.setSelection(this.nameField.getText().length());
    }

    @Override
    public void setEmail(String email) {
        this.emailField.setText((CharSequence)email);
        this.emailField.setSelection(this.emailField.getText().length());
    }

    @Override
    public void showProfileForm() {
        this.nameField.setVisibility(0);
        this.emailField.setVisibility(0);
    }

    @Override
    public void hideProfileForm() {
        this.nameField.setVisibility(8);
        this.emailField.setVisibility(8);
    }

    @Override
    public void setEmailRequired() {
        this.emailField.setHint((CharSequence)this.getText(R.string.hs__email_required_hint));
    }

    @Override
    public void showStartConversationButton() {
        this.changeMenuItemVisibility(HSMenuItemType.START_NEW_CONVERSATION, true);
    }

    @Override
    public void hideStartConversationButton() {
        this.changeMenuItemVisibility(HSMenuItemType.START_NEW_CONVERSATION, false);
    }

    @Override
    public void gotoConversation(long conversationId) {
        this.newConversationRouter.showConversationScreen();
    }

    @Override
    public void exit() {
        this.newConversationRouter.exitNewConversationView();
    }

    @Override
    public void showAttachmentPreviewScreenFromDraft(ImagePickerFile imagePickerFile) {
        this.newConversationRouter.showAttachmentPreviewScreenFromDraft(imagePickerFile);
    }

    @Override
    public void showProgressBar() {
        this.progressBar.setVisibility(0);
    }

    @Override
    public void hideProgressBar() {
        this.progressBar.setVisibility(8);
    }

    @Override
    public void showConversationStartedMessage() {
        Toast toast = HSToast.makeText(this.context, R.string.hs__conversation_started_message, 0);
        toast.setGravity(16, 0, 0);
        toast.show();
    }

    @Override
    public void disableImageAttachmentClickable() {
    }

    @Override
    public void enableImageAttachmentClickable() {
    }

    @Override
    public void showSearchResultFragment(ArrayList questions) {
        this.newConversationRouter.showSearchResultFragment(questions);
    }

    @Override
    public void showErrorView(ExceptionType exceptionCode) {
        SnackbarUtil.showSnackbar(exceptionCode, this.parentView);
    }

    @Override
    public void onAuthenticationFailure() {
        this.newConversationRouter.onAuthenticationFailure();
    }

    private void setError(TextInputLayout textInputLayout, CharSequence error) {
        textInputLayout.setErrorEnabled(!TextUtils.isEmpty((CharSequence)error));
        textInputLayout.setError(error);
    }

    private void changeMenuItemVisibility(HSMenuItemType type, boolean isVisible) {
        if (this.menuItemRenderer != null) {
            this.menuItemRenderer.updateMenuItemVisibility(type, isVisible);
        }
    }
}

