/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.UIViewState;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.util.Styles;

class AdminAttachmentMessageDataBinder
extends MessageViewDataBinder<ViewHolder, AdminAttachmentMessageDM> {
    AdminAttachmentMessageDataBinder(Context context) {
        super(context);
    }

    @Override
    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hs__msg_attachment_generic, parentView, false);
        return new ViewHolder(view);
    }

    @Override
    public void bind(ViewHolder viewHolder, final AdminAttachmentMessageDM message) {
        boolean isDownloadIconVisible = false;
        boolean isAttachmentIconVisible = false;
        boolean isProgressBarVisible = false;
        int fileNameTextColor = com.helpshift.support.util.Styles.getColor(this.context, 16842806);
        String fileSize = message.getFormattedFileSize();
        String attachmentDescription = "";
        switch (message.state) {
            case DOWNLOAD_NOT_STARTED: {
                isDownloadIconVisible = true;
                attachmentDescription = this.context.getString(R.string.hs__attachment_not_downloaded_voice_over, new Object[]{message.fileName, message.getFormattedFileSize()});
                break;
            }
            case DOWNLOADING: {
                isProgressBarVisible = true;
                fileSize = message.getDownloadProgressAndFileSize();
                attachmentDescription = this.context.getString(R.string.hs__attachment_downloading_voice_over, new Object[]{message.fileName, message.getDownloadedProgressSize(), message.getFormattedFileSize()});
                break;
            }
            case DOWNLOADED: {
                isAttachmentIconVisible = true;
                fileNameTextColor = com.helpshift.support.util.Styles.getColor(this.context, R.attr.colorAccent);
                attachmentDescription = this.context.getString(R.string.hs__attachment_downloaded__voice_over, new Object[]{message.fileName});
            }
        }
        this.setViewVisibility(viewHolder.downloadButton, isDownloadIconVisible);
        this.setViewVisibility((View)viewHolder.attachmentIcon, isAttachmentIconVisible);
        this.setViewVisibility((View)viewHolder.progress, isProgressBarVisible);
        UIViewState uiViewState = message.getUiViewState();
        if (uiViewState.isFooterVisible()) {
            viewHolder.subText.setText((CharSequence)message.getSubText());
        }
        this.setViewVisibility((View)viewHolder.subText, uiViewState.isFooterVisible());
        viewHolder.fileName.setText((CharSequence)message.fileName);
        viewHolder.fileSize.setText((CharSequence)fileSize);
        viewHolder.fileName.setTextColor(fileNameTextColor);
        viewHolder.messageContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AdminAttachmentMessageDataBinder.this.messageClickListener != null) {
                    AdminAttachmentMessageDataBinder.this.messageClickListener.handleGenericAttachmentMessageClick(message);
                }
            }
        });
        viewHolder.messageContainer.setContentDescription((CharSequence)attachmentDescription);
        viewHolder.messageLayout.setContentDescription((CharSequence)this.getAdminMessageContentDesciption(message));
    }

    protected final class ViewHolder
    extends RecyclerView.ViewHolder {
        final View messageLayout;
        final TextView fileName;
        final TextView fileSize;
        final View messageContainer;
        final ProgressBar progress;
        final View downloadButton;
        final ImageView attachmentIcon;
        final TextView subText;

        ViewHolder(View itemView) {
            super(itemView);
            this.messageLayout = itemView.findViewById(R.id.admin_attachment_message_layout);
            this.fileName = (TextView)itemView.findViewById(R.id.attachment_file_name);
            this.fileSize = (TextView)itemView.findViewById(R.id.attachment_file_size);
            this.messageContainer = itemView.findViewById(R.id.admin_message);
            this.downloadButton = itemView.findViewById(R.id.download_button);
            this.progress = (ProgressBar)itemView.findViewById(R.id.progress);
            this.attachmentIcon = (ImageView)itemView.findViewById(R.id.attachment_icon);
            this.subText = (TextView)itemView.findViewById(R.id.attachment_date);
            ImageView downloadForegroundView = (ImageView)itemView.findViewById(R.id.hs_download_foreground_view);
            Styles.setColorFilter(AdminAttachmentMessageDataBinder.this.context, downloadForegroundView.getDrawable(), R.attr.hs__chatBubbleMediaBackgroundColor);
            Styles.setColorFilter(AdminAttachmentMessageDataBinder.this.context, this.messageContainer.getBackground(), R.attr.hs__chatBubbleMediaBackgroundColor);
            com.helpshift.support.util.Styles.setAccentColor(AdminAttachmentMessageDataBinder.this.context, this.progress.getIndeterminateDrawable());
            com.helpshift.support.util.Styles.setAccentColor(AdminAttachmentMessageDataBinder.this.context, this.attachmentIcon.getDrawable());
        }
    }
}

