/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.UIViewState;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.support.views.HSRoundedImageView;
import com.helpshift.util.Styles;

class AdminImageAttachmentMessageDataBinder
extends MessageViewDataBinder<ViewHolder, AdminImageAttachmentMessageDM> {
    AdminImageAttachmentMessageDataBinder(Context context) {
        super(context);
    }

    @Override
    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hs__msg_attachment_image, parentView, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void bind(ViewHolder viewHolder, final AdminImageAttachmentMessageDM message) {
        boolean progressBarContainerVisibility = true;
        boolean progressBarVisibility = true;
        boolean downloadButtonVisibility = false;
        boolean imageOverlayVisibility = true;
        boolean isImageClickable = true;
        boolean isFileSizeViewVisible = true;
        String imagePath = null;
        String imageDescription = "";
        String fileSize = message.getFormattedFileSize();
        switch (message.state) {
            case DOWNLOAD_NOT_STARTED: {
                downloadButtonVisibility = true;
                progressBarVisibility = false;
                imageDescription = this.context.getString(R.string.hs__image_not_downloaded_voice_over, new Object[]{message.getFormattedFileSize()});
                break;
            }
            case THUMBNAIL_DOWNLOADING: {
                downloadButtonVisibility = true;
                progressBarVisibility = false;
                imageDescription = this.context.getString(R.string.hs__image_not_downloaded_voice_over, new Object[]{message.getFormattedFileSize()});
                break;
            }
            case THUMBNAIL_DOWNLOADED: {
                imagePath = message.checkAndGetThumbnailFilePath();
                downloadButtonVisibility = true;
                progressBarVisibility = false;
                imageDescription = this.context.getString(R.string.hs__image_not_downloaded_voice_over, new Object[]{message.getFormattedFileSize()});
                break;
            }
            case IMAGE_DOWNLOADING: {
                imagePath = message.checkAndGetThumbnailFilePath();
                isImageClickable = false;
                fileSize = message.getDownloadProgressAndFileSize();
                imageDescription = this.context.getString(R.string.hs__image_downloading_voice_over, new Object[]{message.getDownloadedProgressSize(), message.getFormattedFileSize()});
                break;
            }
            case IMAGE_DOWNLOADED: {
                imageOverlayVisibility = false;
                imagePath = message.checkAndGetFilePath();
                progressBarVisibility = false;
                progressBarContainerVisibility = false;
                imageDescription = this.context.getString(R.string.hs__image_downloaded_voice_over);
            }
        }
        this.setViewVisibility(viewHolder.downloadProgressbarContainer, progressBarContainerVisibility);
        this.setViewVisibility((View)viewHolder.progressBarView, progressBarVisibility);
        this.setViewVisibility(viewHolder.downloadButtonView, downloadButtonVisibility);
        if (imageOverlayVisibility) {
            viewHolder.roundedImageView.setAlpha(0.25f);
        } else {
            viewHolder.roundedImageView.setAlpha(1.0f);
        }
        this.setViewVisibility((View)viewHolder.fileSize, isFileSizeViewVisible);
        viewHolder.roundedImageView.loadImage(imagePath);
        UIViewState uiViewState = message.getUiViewState();
        if (uiViewState.isFooterVisible()) {
            viewHolder.subText.setText((CharSequence)message.getSubText());
        }
        this.setViewVisibility((View)viewHolder.subText, uiViewState.isFooterVisible());
        if (isFileSizeViewVisible) {
            viewHolder.fileSize.setText((CharSequence)fileSize);
        }
        View.OnClickListener clickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (AdminImageAttachmentMessageDataBinder.this.messageClickListener != null) {
                    AdminImageAttachmentMessageDataBinder.this.messageClickListener.handleAdminImageAttachmentMessageClick(message);
                }
            }
        };
        if (downloadButtonVisibility) {
            viewHolder.downloadButtonView.setOnClickListener(clickListener);
        } else {
            viewHolder.downloadButtonView.setOnClickListener(null);
        }
        if (isImageClickable) {
            viewHolder.roundedImageView.setOnClickListener(clickListener);
        } else {
            viewHolder.roundedImageView.setOnClickListener(null);
        }
        viewHolder.roundedImageView.setContentDescription(imageDescription);
        viewHolder.messageLayout.setContentDescription((CharSequence)this.getAdminMessageContentDesciption(message));
    }

    protected final class ViewHolder
    extends RecyclerView.ViewHolder {
        final View messageLayout;
        final HSRoundedImageView roundedImageView;
        final ProgressBar progressBarView;
        final View downloadButtonView;
        final View downloadProgressbarContainer;
        final TextView fileSize;
        final TextView subText;

        ViewHolder(View itemView) {
            super(itemView);
            this.messageLayout = itemView.findViewById(R.id.admin_image_message_layout);
            this.roundedImageView = (HSRoundedImageView)itemView.findViewById(R.id.admin_attachment_imageview);
            this.downloadButtonView = itemView.findViewById(R.id.download_button);
            this.downloadProgressbarContainer = itemView.findViewById(R.id.download_progressbar_container);
            this.progressBarView = (ProgressBar)itemView.findViewById(R.id.download_attachment_progressbar);
            this.fileSize = (TextView)itemView.findViewById(R.id.attachment_file_size);
            this.subText = (TextView)itemView.findViewById(R.id.date);
            ImageView downloadForegroundView = (ImageView)itemView.findViewById(R.id.hs_download_foreground_view);
            Styles.setColorFilter(AdminImageAttachmentMessageDataBinder.this.context, downloadForegroundView.getDrawable(), R.attr.hs__chatBubbleMediaBackgroundColor);
            com.helpshift.support.util.Styles.setAccentColor(AdminImageAttachmentMessageDataBinder.this.context, this.progressBarView.getIndeterminateDrawable());
        }
    }
}

