/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.common.StringUtils;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.UIViewState;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.util.HSLinkify;

class AdminMessageViewDataBinder
extends MessageViewDataBinder<ViewHolder, MessageDM> {
    AdminMessageViewDataBinder(Context context) {
        super(context);
    }

    @Override
    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)parentView.getContext()).inflate(R.layout.hs__msg_txt_admin, parentView, false);
        ViewHolder viewHolder = new ViewHolder(view);
        viewHolder.setListeners();
        return viewHolder;
    }

    @Override
    public void bind(ViewHolder viewHolder, final MessageDM message) {
        if (StringUtils.isEmpty(message.body)) {
            viewHolder.messageLayout.setVisibility(8);
            return;
        }
        viewHolder.messageLayout.setVisibility(0);
        String escapedBodyText = this.escapeHtml(message.body);
        String messageText = message.isRedacted ? this.getRedactedBodyText(escapedBodyText) : escapedBodyText;
        viewHolder.messageText.setText((CharSequence)messageText);
        this.applyRedactionStyleIfNeeded(message, viewHolder.messageText);
        UIViewState uiViewState = message.getUiViewState();
        int drawableId = uiViewState.isRoundedBackground() ? R.drawable.hs__chat_bubble_rounded : R.drawable.hs__chat_bubble_admin;
        this.setDrawable(viewHolder.messageContainer, drawableId, R.attr.hs__chatBubbleAdminBackgroundColor);
        this.setViewVisibility((View)viewHolder.dateText, uiViewState.isFooterVisible());
        if (uiViewState.isFooterVisible()) {
            viewHolder.dateText.setText((CharSequence)message.getSubText());
        }
        viewHolder.messageLayout.setContentDescription((CharSequence)this.getAdminMessageContentDesciption(message));
        this.linkify(viewHolder.messageText, new HSLinkify.LinkClickListener(){

            @Override
            public void onLinkClicked(String url) {
                if (AdminMessageViewDataBinder.this.messageClickListener != null) {
                    AdminMessageViewDataBinder.this.messageClickListener.onAdminMessageLinkClicked(url, message);
                }
            }
        });
    }

    protected final class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnCreateContextMenuListener {
        final View messageLayout;
        final TextView messageText;
        final TextView dateText;
        final View messageContainer;

        ViewHolder(View itemView) {
            super(itemView);
            this.messageLayout = itemView.findViewById(R.id.admin_text_message_layout);
            this.messageText = (TextView)itemView.findViewById(R.id.admin_message_text);
            this.dateText = (TextView)itemView.findViewById(R.id.admin_date_text);
            this.messageContainer = itemView.findViewById(R.id.admin_message_container);
        }

        void setListeners() {
            this.messageText.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
        }

        public void onCreateContextMenu(ContextMenu menu2, View view, ContextMenu.ContextMenuInfo menuInfo) {
            if (AdminMessageViewDataBinder.this.messageClickListener != null) {
                String textToCopy = ((TextView)view).getText().toString();
                AdminMessageViewDataBinder.this.messageClickListener.onCreateContextMenu(menu2, textToCopy);
            }
        }
    }
}

