/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.common.StringUtils;
import com.helpshift.conversation.activeconversation.message.FAQListMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.UIViewState;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.util.HSLinkify;

public class AdminSuggestionsMessageViewDataBinder
extends MessageViewDataBinder<ViewHolder, FAQListMessageDM> {
    AdminSuggestionsMessageViewDataBinder(Context context) {
        super(context);
    }

    @Override
    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hs__msg_admin_suggesstions_container, parentView, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void bind(ViewHolder viewHolder, final FAQListMessageDM message) {
        this.bindAdminMessage(viewHolder, message);
        viewHolder.suggestionsList.removeAllViews();
        TableRow lastDividerRow = null;
        for (final FAQListMessageDM.FAQ faq : message.faqs) {
            View suggestionItemView = LayoutInflater.from((Context)this.context).inflate(R.layout.hs__msg_admin_suggesstion_item, null);
            TextView textView = (TextView)suggestionItemView.findViewById(R.id.admin_suggestion_message);
            textView.setText((CharSequence)faq.title);
            TableRow suggestionTableRow = new TableRow(this.context);
            suggestionTableRow.addView(suggestionItemView);
            View divider = LayoutInflater.from((Context)this.context).inflate(R.layout.hs__section_divider, null);
            TableRow dividerRow = new TableRow(this.context);
            dividerRow.addView(divider);
            lastDividerRow = dividerRow;
            viewHolder.suggestionsList.addView((View)suggestionTableRow);
            viewHolder.suggestionsList.addView((View)dividerRow);
            suggestionItemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AdminSuggestionsMessageViewDataBinder.this.messageClickListener.onAdminSuggestedQuestionSelected(message, faq.publishId, faq.language);
                }
            });
        }
        viewHolder.suggestionsList.removeView(lastDividerRow);
        UIViewState uiViewState = message.getUiViewState();
        this.setViewVisibility((View)viewHolder.dateText, uiViewState.isFooterVisible());
        if (uiViewState.isFooterVisible()) {
            viewHolder.dateText.setText((CharSequence)message.getSubText());
        }
        viewHolder.messageLayout.setContentDescription((CharSequence)this.getAdminMessageContentDesciption(message));
    }

    private void bindAdminMessage(ViewHolder viewHolder, final MessageDM message) {
        if (StringUtils.isEmpty(message.body)) {
            viewHolder.messageContainer.setVisibility(8);
        } else {
            viewHolder.messageContainer.setVisibility(0);
            viewHolder.messageText.setText((CharSequence)this.escapeHtml(message.body));
            UIViewState uiViewState = message.getUiViewState();
            int drawableId = uiViewState.isRoundedBackground() ? R.drawable.hs__chat_bubble_rounded : R.drawable.hs__chat_bubble_admin;
            this.setDrawable(viewHolder.messageContainer, drawableId, R.attr.hs__chatBubbleAdminBackgroundColor);
            viewHolder.messageContainer.setContentDescription((CharSequence)this.getAdminMessageContentDesciption(message));
            this.linkify(viewHolder.messageText, new HSLinkify.LinkClickListener(){

                @Override
                public void onLinkClicked(String url) {
                    if (AdminSuggestionsMessageViewDataBinder.this.messageClickListener != null) {
                        AdminSuggestionsMessageViewDataBinder.this.messageClickListener.onAdminMessageLinkClicked(url, message);
                    }
                }
            });
        }
    }

    protected final class ViewHolder
    extends RecyclerView.ViewHolder {
        final TableLayout suggestionsList;
        final TextView messageText;
        final TextView dateText;
        final View messageContainer;
        final View messageLayout;

        ViewHolder(View itemView) {
            super(itemView);
            this.messageLayout = itemView.findViewById(R.id.admin_suggestion_message_layout);
            this.suggestionsList = (TableLayout)itemView.findViewById(R.id.suggestionsListStub);
            this.messageText = (TextView)itemView.findViewById(R.id.admin_message_text);
            this.messageContainer = itemView.findViewById(R.id.admin_message_container);
            this.dateText = (TextView)itemView.findViewById(R.id.admin_date_text);
        }
    }
}

