/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import com.helpshift.R;
import com.helpshift.conversation.activeconversation.message.HistoryLoadingState;
import com.helpshift.support.util.Styles;

public class HistoryLoadingViewBinder {
    private Context context;
    private HistoryLoadingClickListener historyLoadingClickListener;

    public HistoryLoadingViewBinder(Context context) {
        this.context = context;
    }

    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)parentView.getContext()).inflate(R.layout.hs__history_loading_view_layout, parentView, false);
        return new ViewHolder(view);
    }

    public void bind(ViewHolder viewHolder, HistoryLoadingState historyLoadingState) {
        boolean showLayoutView = true;
        boolean showErrorStateView = false;
        boolean showLoadingStateView = false;
        switch (historyLoadingState) {
            case NONE: {
                showLayoutView = false;
                break;
            }
            case LOADING: {
                showLoadingStateView = true;
                break;
            }
            case ERROR: {
                showErrorStateView = true;
            }
        }
        viewHolder.layoutView.setVisibility(showLayoutView ? 0 : 8);
        viewHolder.loadingStateView.setVisibility(showLoadingStateView ? 0 : 8);
        viewHolder.errorStateView.setVisibility(showErrorStateView ? 0 : 8);
    }

    public void setHistoryLoadingClickListener(HistoryLoadingClickListener historyLoadingClickListener) {
        this.historyLoadingClickListener = historyLoadingClickListener;
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private final View layoutView;
        private final View loadingStateView;
        private final View errorStateView;
        private final View loadingErrorTapToRetry;
        private final ProgressBar progress;

        public ViewHolder(View view) {
            super(view);
            this.layoutView = this.itemView.findViewById(R.id.history_loading_layout_view);
            this.loadingStateView = this.itemView.findViewById(R.id.loading_state_view);
            this.errorStateView = this.itemView.findViewById(R.id.loading_error_state_view);
            this.loadingErrorTapToRetry = this.itemView.findViewById(R.id.loading_error_tap_to_retry);
            this.loadingErrorTapToRetry.setOnClickListener((View.OnClickListener)this);
            this.progress = (ProgressBar)this.itemView.findViewById(R.id.loading_progressbar);
            Styles.setAccentColor(HistoryLoadingViewBinder.this.context, this.progress.getIndeterminateDrawable());
        }

        public void onClick(View v) {
            if (HistoryLoadingViewBinder.this.historyLoadingClickListener != null) {
                HistoryLoadingViewBinder.this.historyLoadingClickListener.onHistoryLoadingRetryClicked();
            }
        }
    }

    public static interface HistoryLoadingClickListener {
        public void onHistoryLoadingRetryClicked();
    }
}

