/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.ContextMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.common.StringUtils;
import com.helpshift.conversation.activeconversation.message.AdminAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.AdminImageAttachmentMessageDM;
import com.helpshift.conversation.activeconversation.message.MessageDM;
import com.helpshift.conversation.activeconversation.message.OptionInputMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestAppReviewMessageDM;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import com.helpshift.util.HSLinkify;
import com.helpshift.util.HSPattern;
import com.helpshift.util.Styles;

public abstract class MessageViewDataBinder<VH extends RecyclerView.ViewHolder, M extends MessageDM> {
    protected static final float BUBBLE_OPAGUE = 1.0f;
    protected static final float BUBBLE_TRANSLUCENT = 0.5f;
    protected Context context;
    protected MessageItemClickListener messageClickListener;

    public MessageViewDataBinder(Context context) {
        this.context = context;
    }

    public void setMessageItemClickListener(MessageItemClickListener messageClickListener) {
        this.messageClickListener = messageClickListener;
    }

    protected void linkify(TextView textView, HSLinkify.LinkClickListener linkClickListener) {
        HSLinkify.addLinks(textView, 14, linkClickListener);
        HSLinkify.addLinks(textView, HSPattern.getUrlPattern(), null, null, null, linkClickListener);
    }

    public abstract VH createViewHolder(ViewGroup var1);

    public abstract void bind(VH var1, M var2);

    String escapeHtml(String input) {
        return Html.fromHtml((String)input.replace("\n", "<br/>")).toString();
    }

    String getRedactedBodyText(String text) {
        return text + "\u00a0";
    }

    protected void setViewVisibility(View view, boolean value) {
        if (value) {
            view.setVisibility(0);
        } else {
            view.setVisibility(8);
        }
    }

    protected void setDrawable(View view, int drawableId, int color2) {
        Styles.setDrawable(this.context, view, drawableId, color2);
    }

    protected String getAdminMessageContentDesciption(MessageDM message) {
        String authorName = message.getDisplayedAuthorName();
        String messageTime = message.getAccessbilityMessageTime();
        String contentDescription = StringUtils.isEmpty(authorName) ? this.context.getString(R.string.hs__agent_message_voice_over, new Object[]{messageTime}) : this.context.getString(R.string.hs__agent_message_with_name_voice_over, new Object[]{authorName, messageTime});
        return contentDescription;
    }

    void applyRedactionStyleIfNeeded(MessageDM messageDM, TextView textView) {
        if (messageDM.isRedacted) {
            textView.setTypeface(textView.getTypeface(), 2);
            textView.setAlpha(0.55f);
        } else {
            textView.setAlpha(1.0f);
            textView.setTypeface(textView.getTypeface(), 0);
        }
    }

    public static interface MessageItemClickListener {
        public void onAdminMessageLinkClicked(String var1, MessageDM var2);

        public void onCreateContextMenu(ContextMenu var1, String var2);

        public void retryMessage(int var1);

        public void onScreenshotMessageClicked(ScreenshotMessageDM var1);

        public void launchImagePicker(RequestScreenshotMessageDM var1);

        public void handleReplyReviewButtonClick(RequestAppReviewMessageDM var1);

        public void handleGenericAttachmentMessageClick(AdminAttachmentMessageDM var1);

        public void handleAdminImageAttachmentMessageClick(AdminImageAttachmentMessageDM var1);

        public void handleOptionSelected(OptionInputMessageDM var1, OptionInput.Option var2, boolean var3);

        public void onAdminSuggestedQuestionSelected(MessageDM var1, String var2, String var3);
    }
}

