/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.conversation.activeconversation.message.RequestScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.UIViewState;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.support.util.Styles;
import com.helpshift.util.HSLinkify;

public class RequestScreenshotMessageDataBinder
extends MessageViewDataBinder<ViewHolder, RequestScreenshotMessageDM> {
    public RequestScreenshotMessageDataBinder(Context context) {
        super(context);
    }

    @Override
    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)parentView.getContext()).inflate(R.layout.hs__msg_request_screenshot, parentView, false);
        return new ViewHolder(view);
    }

    @Override
    public void bind(ViewHolder viewHolder, final RequestScreenshotMessageDM message) {
        viewHolder.adminRequestText.setText((CharSequence)this.escapeHtml(message.body));
        this.setViewVisibility((View)viewHolder.attachButton, !message.isAnswered);
        UIViewState uiViewState = message.getUiViewState();
        int drawableId = uiViewState.isRoundedBackground() ? R.drawable.hs__chat_bubble_rounded : R.drawable.hs__chat_bubble_admin;
        this.setDrawable((View)viewHolder.adminMessage, drawableId, R.attr.hs__chatBubbleAdminBackgroundColor);
        if (uiViewState.isFooterVisible()) {
            viewHolder.subText.setText((CharSequence)message.getSubText());
        }
        this.setViewVisibility((View)viewHolder.subText, uiViewState.isFooterVisible());
        viewHolder.attachButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (message.isAttachmentButtonClickable() && RequestScreenshotMessageDataBinder.this.messageClickListener != null) {
                    RequestScreenshotMessageDataBinder.this.messageClickListener.launchImagePicker(message);
                }
            }
        });
        viewHolder.messageLayout.setContentDescription((CharSequence)this.getAdminMessageContentDesciption(message));
        this.linkify(viewHolder.adminRequestText, new HSLinkify.LinkClickListener(){

            @Override
            public void onLinkClicked(String url) {
                if (RequestScreenshotMessageDataBinder.this.messageClickListener != null) {
                    RequestScreenshotMessageDataBinder.this.messageClickListener.onAdminMessageLinkClicked(url, message);
                }
            }
        });
    }

    protected final class ViewHolder
    extends RecyclerView.ViewHolder {
        final View messageLayout;
        final TextView adminRequestText;
        final Button attachButton;
        final TextView subText;
        private final LinearLayout adminMessage;

        ViewHolder(View itemView) {
            super(itemView);
            this.messageLayout = itemView.findViewById(R.id.agent_screenshot_request_message_layout);
            this.adminRequestText = (TextView)itemView.findViewById(R.id.admin_attachment_request_text);
            this.attachButton = (Button)itemView.findViewById(R.id.admin_attach_screenshot_button);
            this.adminMessage = (LinearLayout)itemView.findViewById(R.id.admin_message);
            this.subText = (TextView)itemView.findViewById(R.id.admin_date_text);
            Styles.setAdminChatBubbleColor(RequestScreenshotMessageDataBinder.this.context, this.adminMessage.getBackground());
        }
    }
}

