/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.conversation.activeconversation.message.ScreenshotMessageDM;
import com.helpshift.conversation.activeconversation.message.UIViewState;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.support.util.Styles;
import com.helpshift.support.views.HSRoundedImageView;
import com.helpshift.util.TextUtils;

public class ScreenshotMessageViewDataBinder
extends MessageViewDataBinder<ViewHolder, ScreenshotMessageDM> {
    public ScreenshotMessageViewDataBinder(Context context) {
        super(context);
    }

    @Override
    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hs__msg_screenshot_status, parentView, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void bind(ViewHolder viewHolder, final ScreenshotMessageDM message) {
        String imagePath = message.getFilePath();
        boolean isProgressBarVisible = false;
        boolean retryButtonVisibility = false;
        boolean sentAndClickable = false;
        ViewHolder clickListener = null;
        String subtext = null;
        int subtextColor = Styles.getColor(this.context, 16842808);
        boolean isImageViewVisible = !TextUtils.isEmpty(imagePath);
        float roundedImageAlphaOverlay = 0.5f;
        String layoutDescription = "";
        switch (message.state) {
            case UNSENT_RETRYABLE: {
                retryButtonVisibility = true;
                clickListener = viewHolder;
                subtext = this.context.getResources().getString(R.string.hs__sending_fail_msg);
                subtextColor = Styles.getColor(this.context, R.attr.hs__errorTextColor);
                layoutDescription = this.context.getString(R.string.hs__user_failed_message_voice_over);
                break;
            }
            case UNSENT_NOT_RETRYABLE: {
                subtext = this.context.getResources().getString(R.string.hs__sending_fail_msg);
                subtextColor = Styles.getColor(this.context, R.attr.hs__errorTextColor);
                layoutDescription = this.context.getString(R.string.hs__user_failed_message_voice_over);
                break;
            }
            case SENDING: {
                isProgressBarVisible = true;
                subtext = this.context.getResources().getString(R.string.hs__sending_msg);
                layoutDescription = this.context.getString(R.string.hs__user_sending_message_voice_over);
                break;
            }
            case SENT: {
                roundedImageAlphaOverlay = 1.0f;
                subtext = message.getSubText();
                if (TextUtils.isEmpty(imagePath)) {
                    isProgressBarVisible = true;
                } else {
                    sentAndClickable = true;
                }
                layoutDescription = this.context.getString(R.string.hs__user_sent_message_voice_over, new Object[]{message.getAccessbilityMessageTime()});
            }
        }
        UIViewState uiViewState = message.getUiViewState();
        viewHolder.roundedImageView.loadImage(imagePath);
        viewHolder.roundedImageView.setAlpha(roundedImageAlphaOverlay);
        this.setViewVisibility((View)viewHolder.roundedImageView, isImageViewVisible);
        viewHolder.subText.setVisibility(0);
        if (uiViewState.isFooterVisible()) {
            viewHolder.subText.setText((CharSequence)subtext);
            viewHolder.subText.setTextColor(subtextColor);
        }
        this.setViewVisibility((View)viewHolder.subText, uiViewState.isFooterVisible());
        this.setViewVisibility((View)viewHolder.progress, isProgressBarVisible);
        this.setViewVisibility((View)viewHolder.retryButton, retryButtonVisibility);
        if (retryButtonVisibility) {
            viewHolder.retryButton.setOnClickListener((View.OnClickListener)clickListener);
        } else {
            viewHolder.retryButton.setOnClickListener(null);
        }
        if (sentAndClickable) {
            viewHolder.roundedImageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ScreenshotMessageViewDataBinder.this.messageClickListener.onScreenshotMessageClicked(message);
                }
            });
        } else {
            viewHolder.roundedImageView.setOnClickListener(null);
        }
        viewHolder.messageLayout.setContentDescription((CharSequence)layoutDescription);
    }

    protected final class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        final View messageLayout;
        final HSRoundedImageView roundedImageView;
        final TextView subText;
        final ImageView retryButton;
        private final ProgressBar progress;

        ViewHolder(View itemView) {
            super(itemView);
            this.messageLayout = itemView.findViewById(R.id.user_image_message_layout);
            this.progress = (ProgressBar)itemView.findViewById(R.id.upload_attachment_progressbar);
            this.roundedImageView = (HSRoundedImageView)itemView.findViewById(R.id.user_attachment_imageview);
            this.subText = (TextView)itemView.findViewById(R.id.date);
            this.retryButton = (ImageView)itemView.findViewById(R.id.user_message_retry_button);
            Styles.setAccentColor(ScreenshotMessageViewDataBinder.this.context, this.progress.getIndeterminateDrawable());
        }

        public void onClick(View v) {
            if (ScreenshotMessageViewDataBinder.this.messageClickListener != null) {
                ScreenshotMessageViewDataBinder.this.messageClickListener.retryMessage(this.getAdapterPosition());
            }
        }
    }
}

