/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.TypedValue;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.conversation.activeconversation.message.UIViewState;
import com.helpshift.conversation.activeconversation.message.UserMessageDM;
import com.helpshift.conversation.activeconversation.message.UserMessageState;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.util.Styles;

public class UserMessageViewDataBinder
extends MessageViewDataBinder<ViewHolder, UserMessageDM> {
    public UserMessageViewDataBinder(Context context) {
        super(context);
    }

    @Override
    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)parentView.getContext()).inflate(R.layout.hs__msg_txt_user, parentView, false);
        ViewHolder viewHolder = new ViewHolder(view);
        ViewGroup.LayoutParams layoutParams = viewHolder.messageBubble.getLayoutParams();
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
        float widthPixels = this.context.getResources().getDisplayMetrics().widthPixels;
        TypedValue outValue = new TypedValue();
        this.context.getResources().getValue(R.dimen.hs__screen_to_conversation_view_ratio, outValue, true);
        float screenToConversationViewRatio = outValue.getFloat();
        int leftMargin = (int)(widthPixels * screenToConversationViewRatio * 0.2f);
        marginLayoutParams.setMargins(leftMargin, marginLayoutParams.topMargin, marginLayoutParams.rightMargin, marginLayoutParams.bottomMargin);
        viewHolder.setListeners();
        return viewHolder;
    }

    @Override
    public void bind(ViewHolder viewHolder, UserMessageDM message) {
        UserMessageState state = message.getState();
        String escapedBodyText = this.escapeHtml(message.body);
        String messageText = message.isRedacted ? this.getRedactedBodyText(escapedBodyText) : escapedBodyText;
        viewHolder.messageText.setText((CharSequence)messageText);
        this.applyRedactionStyleIfNeeded(message, viewHolder.messageText);
        boolean retryButtonVisibility = false;
        boolean isMessageTextEnable = true;
        boolean shouldLinkify = true;
        float chatBubbleAlpha = 0.5f;
        String messageSubText = "";
        int subTextColor = Styles.getColor(this.context, 16842808);
        String layoutDescription = "";
        switch (state) {
            case UNSENT_NOT_RETRYABLE: {
                messageSubText = this.context.getString(R.string.hs__sending_fail_msg);
                layoutDescription = this.context.getString(R.string.hs__user_failed_message_voice_over);
                subTextColor = Styles.getColor(this.context, R.attr.hs__errorTextColor);
                break;
            }
            case UNSENT_RETRYABLE: {
                retryButtonVisibility = true;
                messageSubText = this.context.getString(R.string.hs__sending_fail_msg);
                layoutDescription = this.context.getString(R.string.hs__user_failed_message_voice_over);
                subTextColor = Styles.getColor(this.context, R.attr.hs__errorTextColor);
                shouldLinkify = false;
                break;
            }
            case SENDING: {
                messageSubText = this.context.getString(R.string.hs__sending_msg);
                layoutDescription = this.context.getString(R.string.hs__user_sending_message_voice_over);
                isMessageTextEnable = false;
                shouldLinkify = false;
                break;
            }
            case SENT: {
                messageSubText = message.getSubText();
                layoutDescription = this.context.getString(R.string.hs__user_sent_message_voice_over, new Object[]{message.getAccessbilityMessageTime()});
                chatBubbleAlpha = 1.0f;
            }
        }
        viewHolder.messageLayout.setContentDescription((CharSequence)layoutDescription);
        viewHolder.subText.setText((CharSequence)messageSubText);
        viewHolder.subText.setTextColor(subTextColor);
        viewHolder.messageBubble.setAlpha(chatBubbleAlpha);
        if (shouldLinkify) {
            this.linkify(viewHolder.messageText, null);
        }
        viewHolder.messageText.setEnabled(isMessageTextEnable);
        this.setViewVisibility((View)viewHolder.retryButton, retryButtonVisibility);
        UIViewState uiViewState = message.getUiViewState();
        this.setViewVisibility((View)viewHolder.subText, uiViewState.isFooterVisible());
        int drawableId = uiViewState.isRoundedBackground() ? R.drawable.hs__chat_bubble_rounded : R.drawable.hs__chat_bubble_user;
        this.setDrawable((View)viewHolder.messageBubble, drawableId, R.attr.hs__chatBubbleUserBackgroundColor);
        if (retryButtonVisibility) {
            viewHolder.retryButton.setOnClickListener((View.OnClickListener)viewHolder);
        } else {
            viewHolder.retryButton.setOnClickListener(null);
        }
    }

    protected final class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnCreateContextMenuListener,
    View.OnClickListener {
        final TextView messageText;
        final TextView subText;
        final ImageView retryButton;
        final FrameLayout messageBubble;
        final View messageLayout;

        ViewHolder(View itemView) {
            super(itemView);
            this.messageText = (TextView)itemView.findViewById(R.id.user_message_text);
            this.subText = (TextView)itemView.findViewById(R.id.user_date_text);
            this.messageBubble = (FrameLayout)itemView.findViewById(R.id.user_message_container);
            this.retryButton = (ImageView)itemView.findViewById(R.id.user_message_retry_button);
            this.messageLayout = itemView.findViewById(R.id.user_text_message_layout);
        }

        void setListeners() {
            this.messageText.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
        }

        public void onCreateContextMenu(ContextMenu menu2, View view, ContextMenu.ContextMenuInfo menuInfo) {
            if (UserMessageViewDataBinder.this.messageClickListener != null) {
                String textToCopy = ((TextView)view).getText().toString();
                UserMessageViewDataBinder.this.messageClickListener.onCreateContextMenu(menu2, textToCopy);
            }
        }

        public void onClick(View view) {
            if (UserMessageViewDataBinder.this.messageClickListener != null) {
                UserMessageViewDataBinder.this.messageClickListener.retryMessage(this.getAdapterPosition());
            }
        }
    }
}

