/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.messages;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.animation.CollapseViewAnimation;
import com.helpshift.common.StringUtils;
import com.helpshift.conversation.activeconversation.message.OptionInputMessageDM;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import com.helpshift.support.conversations.messages.MessageViewDataBinder;
import com.helpshift.support.util.Styles;
import com.helpshift.support.views.HSAdjustableSelectOptionsViewInflater;

public class UserSelectableOptionViewDataBinder
extends MessageViewDataBinder<ViewHolder, OptionInputMessageDM> {
    UserSelectableOptionViewDataBinder(Context context) {
        super(context);
    }

    @Override
    public ViewHolder createViewHolder(ViewGroup parentView) {
        View view = LayoutInflater.from((Context)parentView.getContext()).inflate(R.layout.hs__msg_user_selectable_options_container, parentView, false);
        ViewHolder holder = new ViewHolder(view);
        holder.setIsRecyclable(false);
        return holder;
    }

    @Override
    public void bind(ViewHolder viewHolder, OptionInputMessageDM message) {
        viewHolder.optionsContainer.removeAllViews();
        if (!StringUtils.isEmpty(message.input.inputLabel)) {
            viewHolder.optionsHeaderTextView.setVisibility(0);
            viewHolder.optionsHeaderTextView.setText((CharSequence)message.input.inputLabel);
        } else {
            viewHolder.optionsHeaderTextView.setVisibility(8);
        }
        OnOptionSelectedListener onOptionSelectedListener = new OnOptionSelectedListener(viewHolder, this.messageClickListener, message, false);
        double maxAvailableWidthScaleFactor = Styles.isTablet(this.context) ? 0.6000000000000001 : 0.8;
        int rightEndPadding = (int)this.context.getResources().getDimension(R.dimen.activity_horizontal_margin_medium);
        HSAdjustableSelectOptionsViewInflater adjustableOptionSelectionView = new HSAdjustableSelectOptionsViewInflater(this.context, maxAvailableWidthScaleFactor, rightEndPadding, viewHolder.optionsContainer, R.layout.hs__msg_user_selectable_option, R.id.selectable_option_text, R.drawable.hs__pill, R.attr.hs__selectableOptionColor, message.input.options, onOptionSelectedListener);
        adjustableOptionSelectionView.inflate();
        boolean required = message.input.required;
        if (!required && !StringUtils.isEmpty(message.input.skipLabel)) {
            int paddingLeft = viewHolder.optionsSkipTextView.getPaddingLeft();
            int paddingTop = viewHolder.optionsSkipTextView.getPaddingTop();
            int paddingRight = viewHolder.optionsSkipTextView.getPaddingRight();
            int paddingBottom = viewHolder.optionsSkipTextView.getPaddingBottom();
            this.setDrawable((View)viewHolder.optionsSkipTextView, R.drawable.hs__pill_small, R.attr.hs__selectableOptionColor);
            viewHolder.optionsSkipTextView.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            viewHolder.optionsSkipTextView.setText((CharSequence)message.input.skipLabel);
            viewHolder.optionsSkipTextView.setVisibility(0);
            viewHolder.optionsSkipTextView.setOnClickListener((View.OnClickListener)new OnOptionSelectedListener(viewHolder, this.messageClickListener, message, true));
        } else {
            viewHolder.optionsSkipTextView.setVisibility(8);
        }
    }

    private final class OnOptionSelectedListener
    implements View.OnClickListener {
        final ViewHolder viewHolder;
        final MessageViewDataBinder.MessageItemClickListener messageClickListener;
        final OptionInputMessageDM message;
        final boolean isSkip;

        OnOptionSelectedListener(ViewHolder viewHolder, MessageViewDataBinder.MessageItemClickListener messageClickListener, OptionInputMessageDM message, boolean isSkip) {
            this.viewHolder = viewHolder;
            this.messageClickListener = messageClickListener;
            this.message = message;
            this.isSkip = isSkip;
        }

        public void onClick(View v) {
            final TextView clickedView = (TextView)v;
            int animationDuration = 250;
            CollapseViewAnimation collapseAnimation = new CollapseViewAnimation(this.viewHolder.optionsMessageView);
            collapseAnimation.setDuration(animationDuration);
            collapseAnimation.setFillAfter(true);
            AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
            alphaAnimation.setDuration((long)animationDuration);
            alphaAnimation.setFillAfter(true);
            AnimationSet animationSet = new AnimationSet(true);
            animationSet.addAnimation((Animation)alphaAnimation);
            animationSet.addAnimation((Animation)collapseAnimation);
            animationSet.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    OnOptionSelectedListener.this.viewHolder.optionsMessageView.setVisibility(8);
                    if (OnOptionSelectedListener.this.messageClickListener != null) {
                        OnOptionSelectedListener.this.messageClickListener.handleOptionSelected(OnOptionSelectedListener.this.message, (OptionInput.Option)clickedView.getTag(), OnOptionSelectedListener.this.isSkip);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.viewHolder.optionsMessageView.startAnimation((Animation)animationSet);
        }
    }

    protected final class ViewHolder
    extends RecyclerView.ViewHolder {
        final LinearLayout optionsMessageView;
        final LinearLayout optionsContainer;
        final TextView optionsHeaderTextView;
        final TextView optionsSkipTextView;

        ViewHolder(View itemView) {
            super(itemView);
            this.optionsMessageView = (LinearLayout)itemView.findViewById(R.id.options_message_view);
            this.optionsContainer = (LinearLayout)itemView.findViewById(R.id.selectable_options_container);
            this.optionsHeaderTextView = (TextView)itemView.findViewById(R.id.options_header);
            this.optionsSkipTextView = (TextView)itemView.findViewById(R.id.selectable_option_skip);
        }
    }
}

