/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.picker;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.style.BackgroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.common.ListUtils;
import com.helpshift.conversation.viewmodel.HSRange;
import com.helpshift.conversation.viewmodel.OptionUIModel;
import com.helpshift.support.conversations.ConversationalFragmentRouter;
import com.helpshift.util.Styles;
import java.util.List;

public class PickerAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<OptionUIModel> options;
    ConversationalFragmentRouter conversationalFragmentRouter;

    public PickerAdapter(List<OptionUIModel> options, ConversationalFragmentRouter conversationalFragmentRouter) {
        this.options = options;
        this.conversationalFragmentRouter = conversationalFragmentRouter;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int type) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.hs__picker_option, viewGroup, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder viewHolder, int position) {
        OptionUIModel optionUIModel = this.options.get(position);
        String optionTitle = optionUIModel.option.title;
        if (ListUtils.isEmpty(optionUIModel.titleHighlightInfo)) {
            viewHolder.optionView.setText((CharSequence)optionTitle);
        } else {
            int highlightColor = Styles.getColor(viewHolder.optionView.getContext(), R.attr.hs__searchHighlightColor);
            SpannableString spannableTitle = new SpannableString((CharSequence)optionTitle);
            for (HSRange hsRange : optionUIModel.titleHighlightInfo) {
                spannableTitle.setSpan((Object)new BackgroundColorSpan(highlightColor), hsRange.index, hsRange.index + hsRange.length, 33);
            }
            viewHolder.optionView.setText((CharSequence)spannableTitle);
        }
        Context context = viewHolder.optionView.getContext();
        String voiceOverDescription = context.getString(R.string.hs__picker_option_list_item_voice_over, new Object[]{optionTitle});
        viewHolder.layoutView.setContentDescription((CharSequence)voiceOverDescription);
    }

    public int getItemCount() {
        return this.options.size();
    }

    public void dispatchUpdates(List<OptionUIModel> newOptions) {
        this.options.clear();
        this.options.addAll(newOptions);
        this.notifyDataSetChanged();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private final View layoutView;
        private final TextView optionView;

        public ViewHolder(View view) {
            super(view);
            this.optionView = (TextView)this.itemView.findViewById(R.id.hs__option);
            this.layoutView = this.itemView.findViewById(R.id.option_list_item_layout);
            this.layoutView.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            if (PickerAdapter.this.conversationalFragmentRouter != null) {
                PickerAdapter.this.conversationalFragmentRouter.handleOptionSelectedForPicker((OptionUIModel)PickerAdapter.this.options.get(this.getAdapterPosition()), false);
            }
        }
    }
}

