/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.conversations.usersetup;

import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.helpshift.R;
import com.helpshift.conversation.activeconversation.usersetup.UserSetupRenderer;
import com.helpshift.conversation.usersetup.UserSetupVM;
import com.helpshift.network.HSNetworkConnectivityReceiver;
import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.Styles;

public class UserSetupFragment
extends MainFragment
implements UserSetupRenderer,
HSNetworkConnectivityReceiver.HSNetworkConnectivityListener {
    public static final String FRAGMENT_TAG = "HSUserSetupFragment";
    private HSNetworkConnectivityReceiver networkConnectivityReceiver;
    private ProgressBar progressBar;
    private View progressDescriptionView;
    private View offlineErrorView;
    private UserSetupVM userSetupVM;

    public static UserSetupFragment newInstance() {
        return new UserSetupFragment();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__user_setup_fragment, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.initialize(view);
        super.onViewCreated(view, savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        this.setToolbarTitle(this.getString(R.string.hs__conversation_header));
        this.networkConnectivityReceiver = new HSNetworkConnectivityReceiver(this.getContext());
        this.networkConnectivityReceiver.addListener(this);
        this.getActivity().registerReceiver((BroadcastReceiver)this.networkConnectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.userSetupVM.onResume();
    }

    public void onDestroyView() {
        this.userSetupVM.onDestroyView();
        super.onDestroyView();
    }

    private void initialize(View view) {
        this.progressBar = (ProgressBar)view.findViewById(R.id.progressbar);
        com.helpshift.support.util.Styles.setAccentColor(this.getContext(), this.progressBar.getIndeterminateDrawable());
        this.progressDescriptionView = view.findViewById(R.id.progress_description_text_view);
        this.offlineErrorView = view.findViewById(R.id.offline_error_view);
        ImageView infoIconView = (ImageView)view.findViewById(R.id.info_icon);
        Styles.setColorFilter(this.getContext(), infoIconView.getDrawable(), 16842806);
        this.userSetupVM = HelpshiftContext.getCoreApi().getUserSetupVM(this);
    }

    @Override
    public void onPause() {
        this.networkConnectivityReceiver.removeListener(this);
        this.getActivity().unregisterReceiver((BroadcastReceiver)this.networkConnectivityReceiver);
        super.onPause();
    }

    @Override
    public boolean shouldRefreshMenu() {
        return true;
    }

    @Override
    public void showNoInternetView() {
        this.offlineErrorView.setVisibility(0);
    }

    @Override
    public void hideNoInternetView() {
        this.offlineErrorView.setVisibility(8);
    }

    @Override
    public void showProgressBar() {
        this.progressBar.setVisibility(0);
    }

    @Override
    public void hideProgressBar() {
        this.progressBar.setVisibility(8);
    }

    @Override
    public void showProgressDescription() {
        this.progressDescriptionView.setVisibility(0);
    }

    @Override
    public void hideProgressDescription() {
        this.progressDescriptionView.setVisibility(8);
    }

    @Override
    public void onUserSetupComplete() {
        this.getSupportController().onUserSetupSyncCompleted();
    }

    @Override
    public void onAuthenticationFailure() {
        this.getSupportController().onAuthenticationFailure();
    }

    private SupportController getSupportController() {
        SupportFragment supportFragment = (SupportFragment)this.getParentFragment();
        return supportFragment.getSupportController();
    }

    @Override
    public void networkAvailable() {
        this.userSetupVM.onNetworkAvailable();
    }

    @Override
    public void networkUnavailable() {
        this.userSetupVM.onNetworkUnavailable();
    }
}

