/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.external;

import java.util.Locale;

public class DoubleMetaphone {
    private static final String VOWELS = "AEIOUY";
    private static final String[] SILENT_START = new String[]{"GN", "KN", "PN", "WR", "PS"};
    private static final String[] L_R_N_M_B_H_F_V_W_SPACE = new String[]{"L", "R", "N", "M", "B", "H", "F", "V", "W", " "};
    private static final String[] ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER = new String[]{"ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER"};
    private static final String[] L_T_K_S_N_M_B_Z = new String[]{"L", "T", "K", "S", "N", "M", "B", "Z"};
    int maxCodeLen = 4;

    protected static boolean contains(String value, int start, int length, String[] criteria) {
        boolean result = false;
        if (start >= 0 && start + length <= value.length()) {
            String target = value.substring(start, start + length);
            for (String element : criteria) {
                if (!target.equals(element)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public String doubleMetaphone(String value, boolean alternate) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        boolean slavoGermanic = (value = value.toUpperCase(Locale.ENGLISH)).indexOf(87) > -1 || value.indexOf(75) > -1 || value.indexOf("CZ") > -1 || value.indexOf("WITZ") > -1;
        boolean result4 = false;
        for (String element : SILENT_START) {
            if (!value.startsWith(element)) continue;
            result4 = true;
            break;
        }
        int index = result4 ? 1 : 0;
        DoubleMetaphoneResult result = new DoubleMetaphoneResult(this.maxCodeLen);
        block26: while ((result.primary.length() < result.maxLength || result.alternate.length() < result.maxLength) && index <= value.length() - 1) {
            switch (value.charAt(index)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    if (index == 0) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('A');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('A');
                        }
                    }
                    ++index;
                    continue block26;
                }
                case 'B': {
                    if (result.primary.length() < result.maxLength) {
                        result.primary.append('P');
                    }
                    if (result.alternate.length() < result.maxLength) {
                        result.alternate.append('P');
                    }
                    index = this.charAt(value, index + 1) == 'B' ? index + 2 : index + 1;
                    continue block26;
                }
                case '\u00c7': {
                    if (result.primary.length() < result.maxLength) {
                        result.primary.append('S');
                    }
                    if (result.alternate.length() < result.maxLength) {
                        result.alternate.append('S');
                    }
                    ++index;
                    continue block26;
                }
                case 'C': {
                    int addChars;
                    int addChars1;
                    int index2;
                    int returnValue;
                    boolean result2;
                    int index1 = index;
                    if (DoubleMetaphone.contains(value, index1, 4, new String[]{"CHIA"})) {
                        result2 = true;
                    } else if (index1 <= 1) {
                        result2 = false;
                    } else if (VOWELS.indexOf(this.charAt(value, index1 - 2)) != -1) {
                        result2 = false;
                    } else if (!DoubleMetaphone.contains(value, index1 - 1, 3, new String[]{"ACH"})) {
                        result2 = false;
                    } else {
                        char c = this.charAt(value, index1 + 2);
                        boolean bl = result2 = c != 'I' && c != 'E' || DoubleMetaphone.contains(value, index1 - 2, 6, new String[]{"BACHER", "MACHER"});
                    }
                    if (result2) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('K');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('K');
                        }
                        returnValue = index1 += 2;
                    } else if (index1 == 0 && DoubleMetaphone.contains(value, index1, 6, new String[]{"CAESAR"})) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('S');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('S');
                        }
                        returnValue = index1 += 2;
                    } else if (DoubleMetaphone.contains(value, index1, 2, new String[]{"CH"})) {
                        int result1;
                        boolean result3 = index1 != 0 ? false : (!DoubleMetaphone.contains(value, index1 + 1, 5, new String[]{"HARAC", "HARIS"}) && !DoubleMetaphone.contains(value, index1 + 1, 3, new String[]{"HOR", "HYM", "HIA", "HEM"}) ? false : !DoubleMetaphone.contains(value, 0, 5, new String[]{"CHORE"}));
                        if (index1 > 0 && DoubleMetaphone.contains(value, index1, 4, new String[]{"CHAE"})) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('K');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('X');
                            }
                            result1 = index1 + 2;
                        } else if (result3) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('K');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('K');
                            }
                            result1 = index1 + 2;
                        } else if (DoubleMetaphone.contains(value, 0, 4, new String[]{"VAN ", "VON "}) || DoubleMetaphone.contains(value, 0, 3, new String[]{"SCH"}) || DoubleMetaphone.contains(value, index1 - 2, 6, new String[]{"ORCHES", "ARCHIT", "ORCHID"}) || DoubleMetaphone.contains(value, index1 + 2, 1, new String[]{"T", "S"}) || (DoubleMetaphone.contains(value, index1 - 1, 1, new String[]{"A", "O", "U", "E"}) || index1 == 0) && (DoubleMetaphone.contains(value, index1 + 2, 1, L_R_N_M_B_H_F_V_W_SPACE) || index1 + 1 == value.length() - 1)) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('K');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('K');
                            }
                            result1 = index1 + 2;
                        } else {
                            if (index1 > 0) {
                                if (DoubleMetaphone.contains(value, 0, 2, new String[]{"MC"})) {
                                    if (result.primary.length() < result.maxLength) {
                                        result.primary.append('K');
                                    }
                                    if (result.alternate.length() < result.maxLength) {
                                        result.alternate.append('K');
                                    }
                                } else {
                                    if (result.primary.length() < result.maxLength) {
                                        result.primary.append('X');
                                    }
                                    if (result.alternate.length() < result.maxLength) {
                                        result.alternate.append('K');
                                    }
                                }
                            } else {
                                if (result.primary.length() < result.maxLength) {
                                    result.primary.append('X');
                                }
                                if (result.alternate.length() < result.maxLength) {
                                    result.alternate.append('X');
                                }
                            }
                            result1 = index1 + 2;
                        }
                        returnValue = index1 = result1;
                    } else if (DoubleMetaphone.contains(value, index1, 2, new String[]{"CZ"}) && !DoubleMetaphone.contains(value, index1 - 2, 4, new String[]{"WICZ"})) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('S');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('X');
                        }
                        returnValue = index1 += 2;
                    } else if (DoubleMetaphone.contains(value, index1 + 1, 3, new String[]{"CIA"})) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('X');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('X');
                        }
                        returnValue = index1 += 3;
                    } else if (DoubleMetaphone.contains(value, index1, 2, new String[]{"CC"}) && (index1 != 1 || this.charAt(value, 0) != 'M')) {
                        index2 = index1;
                        if (DoubleMetaphone.contains(value, index2 + 2, 1, new String[]{"I", "E", "H"}) && !DoubleMetaphone.contains(value, index2 + 2, 2, new String[]{"HU"})) {
                            if (index2 == 1 && this.charAt(value, index2 - 1) == 'A' || DoubleMetaphone.contains(value, index2 - 1, 5, new String[]{"UCCEE", "UCCES"})) {
                                addChars1 = result.maxLength - result.primary.length();
                                if ("KS".length() <= addChars1) {
                                    result.primary.append("KS");
                                } else {
                                    result.primary.append("KS".substring(0, addChars1));
                                }
                                addChars = result.maxLength - result.alternate.length();
                                if ("KS".length() <= addChars) {
                                    result.alternate.append("KS");
                                } else {
                                    result.alternate.append("KS".substring(0, addChars));
                                }
                            } else {
                                if (result.primary.length() < result.maxLength) {
                                    result.primary.append('X');
                                }
                                if (result.alternate.length() < result.maxLength) {
                                    result.alternate.append('X');
                                }
                            }
                            index2 += 3;
                        } else {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('K');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('K');
                            }
                            index2 += 2;
                        }
                        returnValue = index2;
                    } else if (DoubleMetaphone.contains(value, index1, 2, new String[]{"CK", "CG", "CQ"})) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('K');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('K');
                        }
                        returnValue = index1 += 2;
                    } else if (DoubleMetaphone.contains(value, index1, 2, new String[]{"CI", "CE", "CY"})) {
                        if (DoubleMetaphone.contains(value, index1, 3, new String[]{"CIO", "CIE", "CIA"})) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('S');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('X');
                            }
                        } else {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('S');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('S');
                            }
                        }
                        returnValue = index1 += 2;
                    } else {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('K');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('K');
                        }
                        if (DoubleMetaphone.contains(value, index1 + 1, 2, new String[]{" C", " Q", " G"})) {
                            index1 += 3;
                        } else if (DoubleMetaphone.contains(value, index1 + 1, 1, new String[]{"C", "K", "Q"}) && !DoubleMetaphone.contains(value, index1 + 1, 2, new String[]{"CE", "CI"})) {
                            index1 += 2;
                        }
                        returnValue = ++index1;
                    }
                    index = returnValue;
                    continue block26;
                }
                case 'D': {
                    int addChars;
                    int addChars1;
                    int index2 = index;
                    if (DoubleMetaphone.contains(value, index2, 2, new String[]{"DG"})) {
                        if (DoubleMetaphone.contains(value, index2 + 2, 1, new String[]{"I", "E", "Y"})) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('J');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('J');
                            }
                            index2 += 3;
                        } else {
                            addChars1 = result.maxLength - result.primary.length();
                            if ("TK".length() <= addChars1) {
                                result.primary.append("TK");
                            } else {
                                result.primary.append("TK".substring(0, addChars1));
                            }
                            addChars = result.maxLength - result.alternate.length();
                            if ("TK".length() <= addChars) {
                                result.alternate.append("TK");
                            } else {
                                result.alternate.append("TK".substring(0, addChars));
                            }
                            index2 += 2;
                        }
                    } else if (DoubleMetaphone.contains(value, index2, 2, new String[]{"DT", "DD"})) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('T');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('T');
                        }
                        index2 += 2;
                    } else {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('T');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('T');
                        }
                    }
                    index = ++index2;
                    continue block26;
                }
                case 'F': {
                    if (result.primary.length() < result.maxLength) {
                        result.primary.append('F');
                    }
                    if (result.alternate.length() < result.maxLength) {
                        result.alternate.append('F');
                    }
                    index = this.charAt(value, index + 1) == 'F' ? index + 2 : index + 1;
                    continue block26;
                }
                case 'G': {
                    int addChars;
                    int addChars1;
                    int index4;
                    int index3 = index;
                    if (this.charAt(value, index3 + 1) == 'H') {
                        index4 = index3;
                        if (index4 > 0 && VOWELS.indexOf(this.charAt(value, index4 - 1)) == -1) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('K');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('K');
                            }
                            index4 += 2;
                        } else if (index4 == 0) {
                            if (this.charAt(value, index4 + 2) == 'I') {
                                if (result.primary.length() < result.maxLength) {
                                    result.primary.append('J');
                                }
                                if (result.alternate.length() < result.maxLength) {
                                    result.alternate.append('J');
                                }
                            } else {
                                if (result.primary.length() < result.maxLength) {
                                    result.primary.append('K');
                                }
                                if (result.alternate.length() < result.maxLength) {
                                    result.alternate.append('K');
                                }
                            }
                            index4 += 2;
                        } else if (index4 > 1 && DoubleMetaphone.contains(value, index4 - 2, 1, new String[]{"B", "H", "D"}) || index4 > 2 && DoubleMetaphone.contains(value, index4 - 3, 1, new String[]{"B", "H", "D"}) || index4 > 3 && DoubleMetaphone.contains(value, index4 - 4, 1, new String[]{"B", "H"})) {
                            index4 += 2;
                        } else {
                            if (index4 > 2 && this.charAt(value, index4 - 1) == 'U' && DoubleMetaphone.contains(value, index4 - 3, 1, new String[]{"C", "G", "L", "R", "T"})) {
                                if (result.primary.length() < result.maxLength) {
                                    result.primary.append('F');
                                }
                                if (result.alternate.length() < result.maxLength) {
                                    result.alternate.append('F');
                                }
                            } else if (index4 > 0 && this.charAt(value, index4 - 1) != 'I') {
                                if (result.primary.length() < result.maxLength) {
                                    result.primary.append('K');
                                }
                                if (result.alternate.length() < result.maxLength) {
                                    result.alternate.append('K');
                                }
                            }
                            index4 += 2;
                        }
                        index3 = index4;
                    } else if (this.charAt(value, index3 + 1) == 'N') {
                        if (index3 == 1 && VOWELS.indexOf(this.charAt(value, 0)) != -1 && !slavoGermanic) {
                            addChars1 = result.maxLength - result.primary.length();
                            if ("KN".length() <= addChars1) {
                                result.primary.append("KN");
                            } else {
                                result.primary.append("KN".substring(0, addChars1));
                            }
                            addChars = result.maxLength - result.alternate.length();
                            if ("N".length() <= addChars) {
                                result.alternate.append("N");
                            } else {
                                result.alternate.append("N".substring(0, addChars));
                            }
                        } else if (!DoubleMetaphone.contains(value, index3 + 2, 2, new String[]{"EY"}) && this.charAt(value, index3 + 1) != 'Y' && !slavoGermanic) {
                            addChars1 = result.maxLength - result.primary.length();
                            if ("N".length() <= addChars1) {
                                result.primary.append("N");
                            } else {
                                result.primary.append("N".substring(0, addChars1));
                            }
                            addChars = result.maxLength - result.alternate.length();
                            if ("KN".length() <= addChars) {
                                result.alternate.append("KN");
                            } else {
                                result.alternate.append("KN".substring(0, addChars));
                            }
                        } else {
                            addChars1 = result.maxLength - result.primary.length();
                            if ("KN".length() <= addChars1) {
                                result.primary.append("KN");
                            } else {
                                result.primary.append("KN".substring(0, addChars1));
                            }
                            addChars = result.maxLength - result.alternate.length();
                            if ("KN".length() <= addChars) {
                                result.alternate.append("KN");
                            } else {
                                result.alternate.append("KN".substring(0, addChars));
                            }
                        }
                        index3 += 2;
                    } else if (DoubleMetaphone.contains(value, index3 + 1, 2, new String[]{"LI"}) && !slavoGermanic) {
                        addChars1 = result.maxLength - result.primary.length();
                        if ("KL".length() <= addChars1) {
                            result.primary.append("KL");
                        } else {
                            result.primary.append("KL".substring(0, addChars1));
                        }
                        addChars = result.maxLength - result.alternate.length();
                        if ("L".length() <= addChars) {
                            result.alternate.append("L");
                        } else {
                            result.alternate.append("L".substring(0, addChars));
                        }
                        index3 += 2;
                    } else if (index3 == 0 && (this.charAt(value, index3 + 1) == 'Y' || DoubleMetaphone.contains(value, index3 + 1, 2, ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER))) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('K');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('J');
                        }
                        index3 += 2;
                    } else if (!(!DoubleMetaphone.contains(value, index3 + 1, 2, new String[]{"ER"}) && this.charAt(value, index3 + 1) != 'Y' || DoubleMetaphone.contains(value, 0, 6, new String[]{"DANGER", "RANGER", "MANGER"}) || DoubleMetaphone.contains(value, index3 - 1, 1, new String[]{"E", "I"}) || DoubleMetaphone.contains(value, index3 - 1, 3, new String[]{"RGY", "OGY"}))) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('K');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('J');
                        }
                        index3 += 2;
                    } else if (DoubleMetaphone.contains(value, index3 + 1, 1, new String[]{"E", "I", "Y"}) || DoubleMetaphone.contains(value, index3 - 1, 4, new String[]{"AGGI", "OGGI"})) {
                        if (DoubleMetaphone.contains(value, 0, 4, new String[]{"VAN ", "VON "}) || DoubleMetaphone.contains(value, 0, 3, new String[]{"SCH"}) || DoubleMetaphone.contains(value, index3 + 1, 2, new String[]{"ET"})) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('K');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('K');
                            }
                        } else if (DoubleMetaphone.contains(value, index3 + 1, 3, new String[]{"IER"})) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('J');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('J');
                            }
                        } else {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('J');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('K');
                            }
                        }
                        index3 += 2;
                    } else if (this.charAt(value, index3 + 1) == 'G') {
                        index3 += 2;
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('K');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('K');
                        }
                    } else {
                        ++index3;
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('K');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('K');
                        }
                    }
                    index = index3;
                    continue block26;
                }
                case 'H': {
                    int index4 = index;
                    if ((index4 == 0 || VOWELS.indexOf(this.charAt(value, index4 - 1)) != -1) && VOWELS.indexOf(this.charAt(value, index4 + 1)) != -1) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('H');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('H');
                        }
                        index4 += 2;
                    }
                    index = ++index4;
                    continue block26;
                }
                case 'J': {
                    int index5 = index;
                    if (DoubleMetaphone.contains(value, index5, 4, new String[]{"JOSE"}) || DoubleMetaphone.contains(value, 0, 4, new String[]{"SAN "})) {
                        if (index5 == 0 && this.charAt(value, index5 + 4) == ' ' || value.length() == 4 || DoubleMetaphone.contains(value, 0, 4, new String[]{"SAN "})) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('H');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('H');
                            }
                        } else {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('J');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('H');
                            }
                        }
                    } else {
                        if (index5 == 0 && !DoubleMetaphone.contains(value, index5, 4, new String[]{"JOSE"})) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('J');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('A');
                            }
                        } else if (!(VOWELS.indexOf(this.charAt(value, index5 - 1)) == -1 || slavoGermanic || this.charAt(value, index5 + 1) != 'A' && this.charAt(value, index5 + 1) != 'O')) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('J');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('H');
                            }
                        } else if (index5 == value.length() - 1) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('J');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append(' ');
                            }
                        } else if (!DoubleMetaphone.contains(value, index5 + 1, 1, L_T_K_S_N_M_B_Z) && !DoubleMetaphone.contains(value, index5 - 1, 1, new String[]{"S", "K", "L"})) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('J');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('J');
                            }
                        }
                        index5 = this.charAt(value, index5 + 1) == 'J' ? (index5 += 2) : ++index5;
                    }
                    index = ++index5;
                    continue block26;
                }
                case 'K': {
                    if (result.primary.length() < result.maxLength) {
                        result.primary.append('K');
                    }
                    if (result.alternate.length() < result.maxLength) {
                        result.alternate.append('K');
                    }
                    index = this.charAt(value, index + 1) == 'K' ? index + 2 : index + 1;
                    continue block26;
                }
                case 'L': {
                    int index6 = index;
                    if (this.charAt(value, index6 + 1) == 'L') {
                        boolean result1 = index6 == value.length() - 3 && DoubleMetaphone.contains(value, index6 - 1, 4, new String[]{"ILLO", "ILLA", "ALLE"}) ? true : (DoubleMetaphone.contains(value, value.length() - 2, 2, new String[]{"AS", "OS"}) || DoubleMetaphone.contains(value, value.length() - 1, 1, new String[]{"A", "O"})) && DoubleMetaphone.contains(value, index6 - 1, 4, new String[]{"ALLE"});
                        if (result1) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('L');
                            }
                        } else {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('L');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('L');
                            }
                        }
                        index6 += 2;
                    } else {
                        ++index6;
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('L');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('L');
                        }
                    }
                    index = index6;
                    continue block26;
                }
                case 'M': {
                    if (result.primary.length() < result.maxLength) {
                        result.primary.append('M');
                    }
                    if (result.alternate.length() < result.maxLength) {
                        result.alternate.append('M');
                    }
                    boolean conditionBoolean = this.charAt(value, index + 1) == 'M' ? true : DoubleMetaphone.contains(value, index - 1, 3, new String[]{"UMB"}) && (index + 1 == value.length() - 1 || DoubleMetaphone.contains(value, index + 2, 2, new String[]{"ER"}));
                    index = conditionBoolean ? index + 2 : index + 1;
                    continue block26;
                }
                case 'N': {
                    if (result.primary.length() < result.maxLength) {
                        result.primary.append('N');
                    }
                    if (result.alternate.length() < result.maxLength) {
                        result.alternate.append('N');
                    }
                    index = this.charAt(value, index + 1) == 'N' ? index + 2 : index + 1;
                    continue block26;
                }
                case '\u00d1': {
                    if (result.primary.length() < result.maxLength) {
                        result.primary.append('N');
                    }
                    if (result.alternate.length() < result.maxLength) {
                        result.alternate.append('N');
                    }
                    ++index;
                    continue block26;
                }
                case 'P': {
                    int index7 = index;
                    if (this.charAt(value, index7 + 1) == 'H') {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('F');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('F');
                        }
                        index7 += 2;
                    } else {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('P');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('P');
                        }
                        index7 = DoubleMetaphone.contains(value, index7 + 1, 1, new String[]{"P", "B"}) ? index7 + 2 : index7 + 1;
                    }
                    index = index7;
                    continue block26;
                }
                case 'Q': {
                    if (result.primary.length() < result.maxLength) {
                        result.primary.append('K');
                    }
                    if (result.alternate.length() < result.maxLength) {
                        result.alternate.append('K');
                    }
                    index = this.charAt(value, index + 1) == 'Q' ? index + 2 : index + 1;
                    continue block26;
                }
                case 'R': {
                    if (index == value.length() - 1 && !slavoGermanic && DoubleMetaphone.contains(value, index - 2, 2, new String[]{"IE"}) && !DoubleMetaphone.contains(value, index - 4, 2, new String[]{"ME", "MA"})) {
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('R');
                        }
                    } else {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('R');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('R');
                        }
                    }
                    index = this.charAt(value, index + 1) == 'R' ? index + 2 : index + 1;
                    continue block26;
                }
                case 'S': {
                    int index8 = index;
                    if (!DoubleMetaphone.contains(value, index8 - 1, 3, new String[]{"ISL", "YSL"})) {
                        if (index8 == 0 && DoubleMetaphone.contains(value, index8, 5, new String[]{"SUGAR"})) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('X');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('S');
                            }
                            ++index8;
                        } else if (DoubleMetaphone.contains(value, index8, 2, new String[]{"SH"})) {
                            if (DoubleMetaphone.contains(value, index8 + 1, 4, new String[]{"HEIM", "HOEK", "HOLM", "HOLZ"})) {
                                if (result.primary.length() < result.maxLength) {
                                    result.primary.append('S');
                                }
                                if (result.alternate.length() < result.maxLength) {
                                    result.alternate.append('S');
                                }
                            } else {
                                if (result.primary.length() < result.maxLength) {
                                    result.primary.append('X');
                                }
                                if (result.alternate.length() < result.maxLength) {
                                    result.alternate.append('X');
                                }
                            }
                            index8 += 2;
                        } else if (DoubleMetaphone.contains(value, index8, 3, new String[]{"SIO", "SIA"}) || DoubleMetaphone.contains(value, index8, 4, new String[]{"SIAN"})) {
                            if (slavoGermanic) {
                                if (result.primary.length() < result.maxLength) {
                                    result.primary.append('S');
                                }
                                if (result.alternate.length() < result.maxLength) {
                                    result.alternate.append('S');
                                }
                            } else {
                                if (result.primary.length() < result.maxLength) {
                                    result.primary.append('S');
                                }
                                if (result.alternate.length() < result.maxLength) {
                                    result.alternate.append('X');
                                }
                            }
                            index8 += 3;
                        } else if (index8 == 0 && DoubleMetaphone.contains(value, index8 + 1, 1, new String[]{"M", "N", "L", "W"}) || DoubleMetaphone.contains(value, index8 + 1, 1, new String[]{"Z"})) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('S');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('X');
                            }
                            index8 = DoubleMetaphone.contains(value, index8 + 1, 1, new String[]{"Z"}) ? index8 + 2 : index8 + 1;
                        } else if (DoubleMetaphone.contains(value, index8, 2, new String[]{"SC"})) {
                            int addChars;
                            int addChars1;
                            if (this.charAt(value, index8 + 2) == 'H') {
                                if (DoubleMetaphone.contains(value, index8 + 3, 2, new String[]{"OO", "ER", "EN", "UY", "ED", "EM"})) {
                                    if (DoubleMetaphone.contains(value, index8 + 3, 2, new String[]{"ER", "EN"})) {
                                        addChars1 = result.maxLength - result.primary.length();
                                        if ("X".length() <= addChars1) {
                                            result.primary.append("X");
                                        } else {
                                            result.primary.append("X".substring(0, addChars1));
                                        }
                                        addChars = result.maxLength - result.alternate.length();
                                        if ("SK".length() <= addChars) {
                                            result.alternate.append("SK");
                                        } else {
                                            result.alternate.append("SK".substring(0, addChars));
                                        }
                                    } else {
                                        addChars1 = result.maxLength - result.primary.length();
                                        if ("SK".length() <= addChars1) {
                                            result.primary.append("SK");
                                        } else {
                                            result.primary.append("SK".substring(0, addChars1));
                                        }
                                        addChars = result.maxLength - result.alternate.length();
                                        if ("SK".length() <= addChars) {
                                            result.alternate.append("SK");
                                        } else {
                                            result.alternate.append("SK".substring(0, addChars));
                                        }
                                    }
                                } else if (index8 == 0 && VOWELS.indexOf(this.charAt(value, 3)) == -1 && this.charAt(value, 3) != 'W') {
                                    if (result.primary.length() < result.maxLength) {
                                        result.primary.append('X');
                                    }
                                    if (result.alternate.length() < result.maxLength) {
                                        result.alternate.append('S');
                                    }
                                } else {
                                    if (result.primary.length() < result.maxLength) {
                                        result.primary.append('X');
                                    }
                                    if (result.alternate.length() < result.maxLength) {
                                        result.alternate.append('X');
                                    }
                                }
                            } else if (DoubleMetaphone.contains(value, index8 + 2, 1, new String[]{"I", "E", "Y"})) {
                                if (result.primary.length() < result.maxLength) {
                                    result.primary.append('S');
                                }
                                if (result.alternate.length() < result.maxLength) {
                                    result.alternate.append('S');
                                }
                            } else {
                                addChars1 = result.maxLength - result.primary.length();
                                if ("SK".length() <= addChars1) {
                                    result.primary.append("SK");
                                } else {
                                    result.primary.append("SK".substring(0, addChars1));
                                }
                                addChars = result.maxLength - result.alternate.length();
                                if ("SK".length() <= addChars) {
                                    result.alternate.append("SK");
                                } else {
                                    result.alternate.append("SK".substring(0, addChars));
                                }
                            }
                            index8 += 3;
                        } else {
                            if (index8 == value.length() - 1 && DoubleMetaphone.contains(value, index8 - 2, 2, new String[]{"AI", "OI"})) {
                                if (result.alternate.length() < result.maxLength) {
                                    result.alternate.append('S');
                                }
                            } else {
                                if (result.primary.length() < result.maxLength) {
                                    result.primary.append('S');
                                }
                                if (result.alternate.length() < result.maxLength) {
                                    result.alternate.append('S');
                                }
                            }
                            index8 = DoubleMetaphone.contains(value, index8 + 1, 1, new String[]{"S", "Z"}) ? index8 + 2 : index8 + 1;
                        }
                    }
                    index = ++index8;
                    continue block26;
                }
                case 'T': {
                    int index9 = index;
                    if (DoubleMetaphone.contains(value, index9, 4, new String[]{"TION"})) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('X');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('X');
                        }
                        index9 += 3;
                    } else if (DoubleMetaphone.contains(value, index9, 3, new String[]{"TIA", "TCH"})) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('X');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('X');
                        }
                        index9 += 3;
                    } else if (DoubleMetaphone.contains(value, index9, 2, new String[]{"TH"}) || DoubleMetaphone.contains(value, index9, 3, new String[]{"TTH"})) {
                        if (DoubleMetaphone.contains(value, index9 + 2, 2, new String[]{"OM", "AM"}) || DoubleMetaphone.contains(value, 0, 4, new String[]{"VAN ", "VON "}) || DoubleMetaphone.contains(value, 0, 3, new String[]{"SCH"})) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('T');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('T');
                            }
                        } else {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('0');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('T');
                            }
                        }
                        index9 += 2;
                    } else {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('T');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('T');
                        }
                        index9 = DoubleMetaphone.contains(value, index9 + 1, 1, new String[]{"T", "D"}) ? index9 + 2 : index9 + 1;
                    }
                    index = index9;
                    continue block26;
                }
                case 'V': {
                    if (result.primary.length() < result.maxLength) {
                        result.primary.append('F');
                    }
                    if (result.alternate.length() < result.maxLength) {
                        result.alternate.append('F');
                    }
                    index = this.charAt(value, index + 1) == 'V' ? index + 2 : index + 1;
                    continue block26;
                }
                case 'W': {
                    int index10 = index;
                    if (DoubleMetaphone.contains(value, index10, 2, new String[]{"WR"})) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('R');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('R');
                        }
                        index10 += 2;
                    } else if (index10 == 0 && (VOWELS.indexOf(this.charAt(value, index10 + 1)) != -1 || DoubleMetaphone.contains(value, index10, 2, new String[]{"WH"}))) {
                        if (VOWELS.indexOf(this.charAt(value, index10 + 1)) != -1) {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('A');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('F');
                            }
                        } else {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('A');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('A');
                            }
                        }
                    } else if (index10 == value.length() - 1 && VOWELS.indexOf(this.charAt(value, index10 - 1)) != -1 || DoubleMetaphone.contains(value, index10 - 1, 5, new String[]{"EWSKI", "EWSKY", "OWSKI", "OWSKY"}) || DoubleMetaphone.contains(value, 0, 3, new String[]{"SCH"})) {
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('F');
                        }
                        ++index10;
                    } else if (DoubleMetaphone.contains(value, index10, 4, new String[]{"WICZ", "WITZ"})) {
                        int addChars1 = result.maxLength - result.primary.length();
                        if ("TS".length() <= addChars1) {
                            result.primary.append("TS");
                        } else {
                            result.primary.append("TS".substring(0, addChars1));
                        }
                        int addChars = result.maxLength - result.alternate.length();
                        if ("FX".length() <= addChars) {
                            result.alternate.append("FX");
                        } else {
                            result.alternate.append("FX".substring(0, addChars));
                        }
                        index10 += 4;
                    } else {
                        ++index10;
                    }
                    index = ++index10;
                    continue block26;
                }
                case 'X': {
                    int index11 = index;
                    if (index11 == 0) {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('S');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('S');
                        }
                    } else {
                        if (index11 != value.length() - 1 || !DoubleMetaphone.contains(value, index11 - 3, 3, new String[]{"IAU", "EAU"}) && !DoubleMetaphone.contains(value, index11 - 2, 2, new String[]{"AU", "OU"})) {
                            int addChars1 = result.maxLength - result.primary.length();
                            if ("KS".length() <= addChars1) {
                                result.primary.append("KS");
                            } else {
                                result.primary.append("KS".substring(0, addChars1));
                            }
                            int addChars = result.maxLength - result.alternate.length();
                            if ("KS".length() <= addChars) {
                                result.alternate.append("KS");
                            } else {
                                result.alternate.append("KS".substring(0, addChars));
                            }
                        }
                        index11 = DoubleMetaphone.contains(value, index11 + 1, 1, new String[]{"C", "X"}) ? index11 + 2 : index11 + 1;
                    }
                    index = ++index11;
                    continue block26;
                }
                case 'Z': {
                    int index12 = index;
                    if (this.charAt(value, index12 + 1) == 'H') {
                        if (result.primary.length() < result.maxLength) {
                            result.primary.append('J');
                        }
                        if (result.alternate.length() < result.maxLength) {
                            result.alternate.append('J');
                        }
                        index12 += 2;
                    } else {
                        if (DoubleMetaphone.contains(value, index12 + 1, 2, new String[]{"ZO", "ZI", "ZA"}) || slavoGermanic && index12 > 0 && this.charAt(value, index12 - 1) != 'T') {
                            int addChars1 = result.maxLength - result.primary.length();
                            if ("S".length() <= addChars1) {
                                result.primary.append("S");
                            } else {
                                result.primary.append("S".substring(0, addChars1));
                            }
                            int addChars = result.maxLength - result.alternate.length();
                            if ("TS".length() <= addChars) {
                                result.alternate.append("TS");
                            } else {
                                result.alternate.append("TS".substring(0, addChars));
                            }
                        } else {
                            if (result.primary.length() < result.maxLength) {
                                result.primary.append('S');
                            }
                            if (result.alternate.length() < result.maxLength) {
                                result.alternate.append('S');
                            }
                        }
                        index12 = this.charAt(value, index12 + 1) == 'Z' ? index12 + 2 : index12 + 1;
                    }
                    index = index12;
                    continue block26;
                }
            }
            ++index;
        }
        return alternate ? result.alternate.toString() : result.primary.toString();
    }

    protected char charAt(String value, int index) {
        if (index < 0 || index >= value.length()) {
            return '\u0000';
        }
        return value.charAt(index);
    }

    public class DoubleMetaphoneResult {
        final StringBuilder primary;
        final StringBuilder alternate;
        final int maxLength;

        public DoubleMetaphoneResult(int maxLength) {
            this.primary = new StringBuilder(DoubleMetaphone.this.maxCodeLen);
            this.alternate = new StringBuilder(DoubleMetaphone.this.maxCodeLen);
            this.maxLength = maxLength;
        }
    }
}

