/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.flows;

import android.support.annotation.NonNull;
import com.helpshift.support.ApiConfig;
import com.helpshift.support.SupportInternal;
import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.flows.Flow;
import com.helpshift.support.util.ConfigUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FAQsFlow
implements Flow {
    private final int labelResId;
    private final String label;
    private final HashMap config;
    private SupportController supportController;

    public FAQsFlow(int labelResId) {
        this(labelResId, new HashMap());
    }

    public FAQsFlow(int labelResId, Map config) {
        this.labelResId = labelResId;
        this.config = new HashMap(config);
        this.label = null;
    }

    public FAQsFlow(int labelResId, @NonNull ApiConfig config) {
        this(labelResId, ConfigUtil.validateAndConvertToMap(config));
    }

    public FAQsFlow(String label) {
        this(label, new HashMap());
    }

    public FAQsFlow(String label, Map config) {
        this.label = label;
        this.config = new HashMap(config);
        this.labelResId = 0;
    }

    public FAQsFlow(@NonNull String label, @NonNull ApiConfig config) {
        this(label, ConfigUtil.validateAndConvertToMap(config));
    }

    public void setSupportController(SupportController supportController) {
        this.supportController = supportController;
    }

    @Override
    public int getLabelResId() {
        return this.labelResId;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void performAction() {
        List customContactUsFlows = (List)this.config.get("customContactUsFlows");
        this.supportController.startFaqFlow(SupportInternal.cleanConfig(this.config), true, customContactUsFlows);
    }
}

