/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import com.helpshift.R;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.util.FragmentUtil;
import com.helpshift.support.util.Styles;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.views.HSToast;
import java.lang.reflect.Field;

public abstract class MainFragment
extends Fragment {
    public static final String TOOLBAR_ID = "toolbarId";
    private static final String TAG = SupportFragment.class.getSimpleName();
    private static boolean shouldRetainChildFragmentManager;
    protected String fragmentName = ((Object)((Object)this)).getClass().getName();
    private FragmentManager retainedChildFragmentManager;
    private boolean isChangingConfigurations;
    private boolean isScreenLarge;

    public FragmentManager getRetainedChildFragmentManager() {
        if (shouldRetainChildFragmentManager) {
            if (this.retainedChildFragmentManager == null) {
                this.retainedChildFragmentManager = this.getChildFragmentManager();
            }
            return this.retainedChildFragmentManager;
        }
        return this.getChildFragmentManager();
    }

    public boolean isChangingConfigurations() {
        return this.isChangingConfigurations;
    }

    public Context getContext() {
        Context context = super.getContext();
        if (context != null) {
            return context;
        }
        return HelpshiftContext.getApplicationContext();
    }

    public void onAttach(Context context) {
        super.onAttach(ApplicationUtil.getContextWithUpdatedLocaleLegacy(context));
        try {
            this.setRetainInstance(true);
        }
        catch (Exception e) {
            shouldRetainChildFragmentManager = true;
        }
        if (HelpshiftContext.getApplicationContext() == null) {
            HelpshiftContext.setApplicationContext(context.getApplicationContext());
        }
        this.isScreenLarge = Styles.isTablet(this.getContext());
        if (shouldRetainChildFragmentManager && this.retainedChildFragmentManager != null) {
            try {
                Field childFMField = Fragment.class.getDeclaredField("mChildFragmentManager");
                childFMField.setAccessible(true);
                childFMField.set((Object)this, this.retainedChildFragmentManager);
            }
            catch (NoSuchFieldException e) {
                HSLogger.d(TAG, "NoSuchFieldException", e);
            }
            catch (IllegalAccessException e) {
                HSLogger.d(TAG, "IllegalAccessException", e);
            }
        }
    }

    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        if (!(InfoModelFactory.getInstance().appInfoModel.disableAnimations.booleanValue() || enter || this.isRemoving())) {
            AlphaAnimation doNothingAnimation = new AlphaAnimation(1.0f, 1.0f);
            doNothingAnimation.setDuration((long)this.getResources().getInteger(R.integer.hs_animation_duration));
            return doNothingAnimation;
        }
        return super.onCreateAnimation(transit, enter, nextAnim);
    }

    public void onStart() {
        SupportFragment supportFragment;
        super.onStart();
        if (this.shouldRefreshMenu() && (supportFragment = FragmentUtil.getSupportFragment(this)) != null) {
            supportFragment.addVisibleFragment(this.fragmentName);
        }
    }

    public void onPause() {
        this.isChangingConfigurations = this.getActivity(this).isChangingConfigurations();
        super.onPause();
    }

    public void onStop() {
        SupportFragment supportFragment;
        if (this.shouldRefreshMenu() && (supportFragment = FragmentUtil.getSupportFragment(this)) != null) {
            supportFragment.removeVisibleFragment(this.fragmentName);
        }
        super.onStop();
    }

    public Activity getActivity(Fragment fragment) {
        if (fragment == null) {
            return null;
        }
        while (fragment.getParentFragment() != null) {
            fragment = fragment.getParentFragment();
        }
        return fragment.getActivity();
    }

    public abstract boolean shouldRefreshMenu();

    public boolean isScreenLarge() {
        return this.isScreenLarge;
    }

    public void setToolbarTitle(String title) {
        SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
        if (supportFragment != null) {
            supportFragment.setTitle(title);
        }
    }

    protected void copyToClipboard(String text) {
        ClipboardManager clipboard = (ClipboardManager)this.getContext().getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"Copy Text", (CharSequence)text);
        clipboard.setPrimaryClip(clip);
        HSToast.makeText(this.getContext(), this.getString(R.string.hs__copied_to_clipboard), 0).show();
    }
}

