/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.support.ContactUsFilter;
import com.helpshift.support.Faq;
import com.helpshift.support.HSApiData;
import com.helpshift.support.contracts.FaqFlowViewParent;
import com.helpshift.support.contracts.FaqFragmentListener;
import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.fragments.FaqFlowFragment;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.util.FragmentUtil;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.support.webkit.CustomWebChromeClient;
import com.helpshift.support.webkit.CustomWebView;
import com.helpshift.support.webkit.CustomWebViewClient;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftConnectionUtil;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.Styles;
import com.helpshift.views.FontApplier;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;

public class SingleQuestionFragment
extends MainFragment
implements View.OnClickListener,
CustomWebViewClient.CustomWebViewClientListeners {
    public static final String BUNDLE_ARG_QUESTION_PUBLISH_ID = "questionPublishId";
    public static final String BUNDLE_ARG_QUESTION_LANGUAGE = "questionLanguage";
    private static final String TAG = "Helpshift_SingleQstn";
    boolean eventSent;
    private int singleQuestionMode = 1;
    private HSApiData data;
    private CustomWebView webView;
    private View questionFooter;
    private TextView questionFooterMessage;
    private Button yesButton;
    private Button noButton;
    private Button contactUsButton;
    private Faq question;
    private String textColor;
    private String textColorLink;
    private boolean isHighlighted;
    private View progressBar;
    private SupportController supportController;
    private boolean decomp;
    private int isHelpful = 0;
    private boolean showRootLayoutInsideCardView = false;
    private QuestionReadListener questionReadListener;

    public static SingleQuestionFragment newInstance(Bundle bundle, int singleQuestionMode, boolean showRootLayoutInsideCardView, QuestionReadListener questionReadListener) {
        SingleQuestionFragment singleQuestionFragment = new SingleQuestionFragment();
        singleQuestionFragment.setArguments(bundle);
        singleQuestionFragment.singleQuestionMode = singleQuestionMode;
        singleQuestionFragment.showRootLayoutInsideCardView = showRootLayoutInsideCardView;
        singleQuestionFragment.questionReadListener = questionReadListener;
        return singleQuestionFragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.data = new HSApiData(context);
        this.getColorsFromTheme(context);
        SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
        if (supportFragment != null) {
            this.supportController = supportFragment.getSupportController();
        }
        this.fragmentName = this.getClass().getName() + this.singleQuestionMode;
    }

    @Override
    public void onStart() {
        super.onStart();
        if (!this.isChangingConfigurations()) {
            this.eventSent = false;
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        this.webView.onPause();
    }

    @Override
    public void onStop() {
        super.onStop();
        if (this.decomp || !this.isScreenLarge()) {
            this.setToolbarTitle(this.getString(R.string.hs__help_header));
        }
    }

    @Override
    public boolean shouldRefreshMenu() {
        return true;
    }

    private void getColorsFromTheme(Context context) {
        int textColorLinkResId = 16842907;
        if (Build.VERSION.SDK_INT >= 21) {
            textColorLinkResId = 16843829;
        }
        this.textColor = Styles.getHexColor(context, 16842806);
        this.textColorLink = Styles.getHexColor(context, textColorLinkResId);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getArguments();
        if (extras != null) {
            this.decomp = extras.getBoolean("decomp", false);
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int layoutResourceId = R.layout.hs__single_question_fragment;
        if (this.showRootLayoutInsideCardView) {
            layoutResourceId = R.layout.hs__single_question_layout_with_cardview;
        }
        View view = inflater.inflate(layoutResourceId, container, false);
        return view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.webView = (CustomWebView)view.findViewById(R.id.web_view);
        this.webView.setWebViewClient(new CustomWebViewClient(HelpshiftContext.getApplicationContext(), this));
        View decorView = this.getActivity().getWindow().getDecorView();
        View contentView = view.findViewById(R.id.faq_content_view);
        this.webView.setWebChromeClient(new CustomWebChromeClient(decorView, contentView));
        this.yesButton = (Button)view.findViewById(R.id.helpful_button);
        this.yesButton.setOnClickListener((View.OnClickListener)this);
        this.noButton = (Button)view.findViewById(R.id.unhelpful_button);
        this.noButton.setOnClickListener((View.OnClickListener)this);
        this.questionFooter = view.findViewById(R.id.question_footer);
        this.questionFooterMessage = (TextView)view.findViewById(R.id.question_footer_message);
        this.contactUsButton = (Button)view.findViewById(R.id.contact_us_button);
        this.contactUsButton.setOnClickListener((View.OnClickListener)this);
        if (Build.VERSION.SDK_INT >= 24) {
            this.yesButton.setText(R.string.hs__mark_yes);
            this.noButton.setText(R.string.hs__mark_no);
            this.contactUsButton.setText(R.string.hs__contact_us_btn);
        }
        if (this.singleQuestionMode == 2) {
            this.contactUsButton.setText((CharSequence)this.getResources().getString(R.string.hs__send_anyway));
        }
        String questionPublishId = this.getArguments().getString(BUNDLE_ARG_QUESTION_PUBLISH_ID);
        int supportMode = this.getArguments().getInt("support_mode");
        String faqLanguage = this.getArguments().getString(BUNDLE_ARG_QUESTION_LANGUAGE, "");
        boolean isAdminSuggestedFAQ = this.singleQuestionMode == 3;
        boolean shouldFetchFromNetwork = isAdminSuggestedFAQ || supportMode == 3;
        this.data.getQuestion(new Success(this), new Failure(this), shouldFetchFromNetwork, isAdminSuggestedFAQ, questionPublishId, faqLanguage);
        this.progressBar = view.findViewById(R.id.progress_bar);
    }

    public void onResume() {
        String questionId;
        Fragment parent;
        super.onResume();
        if (this.isScreenLarge() && (parent = this.getParentFragment()) instanceof FaqFlowFragment) {
            ((FaqFlowFragment)parent).updateSelectQuestionUI(false);
        }
        this.webView.onResume();
        if (this.decomp || !this.isScreenLarge()) {
            this.setToolbarTitle(this.getString(R.string.hs__question_header));
        }
        if (this.question != null && !TextUtils.isEmpty((CharSequence)(questionId = this.question.getId())) && !this.eventSent) {
            this.reportReadFaqEvent();
        }
    }

    public void onDestroyView() {
        SnackbarUtil.hideSnackbar(this.getView());
        this.questionFooter = null;
        this.webView.setWebViewClient(null);
        this.webView = null;
        this.noButton = null;
        this.yesButton = null;
        this.contactUsButton = null;
        super.onDestroyView();
    }

    void setQuestion(Faq question) {
        this.question = question;
        if (this.webView != null) {
            this.webView.loadDataWithBaseURL(null, this.getStyledBody(question), "text/html", "utf-8", null);
        }
    }

    private String getStyledBody(Faq question) {
        String titleFontSize = "24px";
        String titleLineHeight = "32px";
        String bodyFontSize = "16px";
        String bodyLineHeight = "1.5";
        int faqPadding = 16;
        int faqBottomPadding = 96;
        String fontPath = FontApplier.getFontPath();
        String fontFaceText = "";
        String fontFamilyText = "";
        if (!TextUtils.isEmpty((CharSequence)fontPath)) {
            fontPath = "file:///android_asset/" + fontPath;
            fontFaceText = "@font-face {    font-family: custom;    src: url('" + fontPath + "');}";
            fontFamilyText = "font-family: custom, sans-serif;";
        }
        String bodyText = question.body;
        String titleText = question.title;
        if (bodyText.contains("<iframe")) {
            try {
                bodyText = bodyText.replace("https", "http");
            }
            catch (NullPointerException e) {
                HSLogger.e(TAG, "Error replacing https in bodyText", e);
            }
        }
        StringBuilder styledBody = question.is_rtl != false ? new StringBuilder("<html dir=\"rtl\">") : new StringBuilder("<html>");
        String paddingString = faqPadding + "px " + faqPadding + "px " + faqBottomPadding + "px " + faqPadding + "px;";
        styledBody.append("<head>").append("    <style type='text/css'>").append(fontFaceText).append("        img,").append("        object,").append("        embed {").append("            max-width: 100%;").append("        }").append("        a,").append("        a:visited,").append("        a:active,").append("        a:hover {").append("            color: ").append(this.textColorLink).append(";").append("        }").append("        body {").append("            background-color: transparent;").append("            margin: 0;").append("            padding: ").append(paddingString).append("            font-size: ").append(bodyFontSize).append(";").append(fontFamilyText).append("            line-height: ").append(bodyLineHeight).append(";").append("            white-space: normal;").append("            word-wrap: break-word;").append("            color: ").append(this.textColor).append(";").append("        }").append("        .title {").append("            display: block;").append("            margin: 0;").append("            padding: 0 0 ").append(faqPadding).append(" 0;").append("            font-size: ").append(titleFontSize).append(";").append(fontFamilyText).append("            line-height: ").append(titleLineHeight).append(";").append("        }").append("        h1, h2, h3 { ").append("            line-height: 1.4; ").append("        }").append("    </style>").append("    <script language='javascript'>").append("     window.onload = function () {").append("        var w = window,").append("            d = document,").append("            e = d.documentElement,").append("            g = d.getElementsByTagName('body')[0],").append("            sWidth = Math.min (w.innerWidth || Infinity, e.clientWidth || Infinity, g.clientWidth || Infinity),").append("            sHeight = Math.min (w.innerHeight || Infinity, e.clientHeight || Infinity, g.clientHeight || Infinity);").append("        var frame, fw, fh;").append("        var iframes = document.getElementsByTagName('iframe');").append("        var padding = ").append(faqPadding * 2).append(";").append("        for (var i=0; i < iframes.length; i++) {").append("            frame = iframes[i];").append("            fw = frame.offsetWidth;").append("            fh = frame.offsetHeight;").append("            if (fw >= fh && fw > (sWidth - padding)) {").append("                frame.style.width = sWidth - padding;").append("                frame.style.height = ((sWidth - padding) * fh/fw).toString();").append("            }").append("        }").append("        document.addEventListener('click', function (event) {").append("            if (event.target instanceof HTMLImageElement) {").append("                event.preventDefault();").append("                event.stopPropagation();").append("            }").append("        }, false);").append("    };").append("    </script>").append("</head>").append("<body>").append("    <strong class='title'> ").append(titleText).append(" </strong> ").append(bodyText).append("</body>").append("</html>");
        return styledBody.toString();
    }

    private void markQuestion(boolean helpful) {
        if (this.question == null) {
            return;
        }
        String faqId = this.question.getId();
        this.data.markFaqInDB(faqId, helpful);
        HelpshiftContext.getCoreApi().getFaqDM().markHelpful(faqId, helpful);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.helpful_button) {
            SupportFragment supportFragment;
            this.markQuestion(true);
            this.setIsHelpful(1);
            if (this.singleQuestionMode == 2 && (supportFragment = FragmentUtil.getSupportFragment(this)) != null) {
                SupportController supportController = supportFragment.getSupportController();
                supportController.actionDone();
            }
        } else if (view.getId() == R.id.unhelpful_button) {
            this.markQuestion(false);
            this.setIsHelpful(-1);
        } else if (view.getId() == R.id.contact_us_button && this.supportController != null) {
            if (this.singleQuestionMode == 1) {
                FaqFragmentListener faqFragmentListener = this.getFaqFlowListener();
                if (faqFragmentListener != null) {
                    faqFragmentListener.onContactUsClicked(null);
                }
            } else {
                SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
                if (supportFragment != null) {
                    SupportController supportController = supportFragment.getSupportController();
                    supportController.sendAnyway();
                }
            }
        }
    }

    public FaqFragmentListener getFaqFlowListener() {
        FaqFlowViewParent faqFlowViewParent = (FaqFlowViewParent)this.getParentFragment();
        if (faqFlowViewParent != null) {
            return faqFlowViewParent.getFaqFlowListener();
        }
        return null;
    }

    private void setIsHelpful(int state) {
        if (state != 0) {
            this.isHelpful = state;
        }
        this.updateFooter();
    }

    @Override
    public void onPageStarted() {
        this.showProgress(true);
        this.webView.setBackgroundColor(0);
    }

    @Override
    public void onPageFinished() {
        if (this.isVisible()) {
            this.showProgress(false);
            this.setIsHelpful(this.question.is_helpful);
            if (this.isHighlighted) {
                this.isHighlighted = false;
            } else {
                this.highlightAndReloadQuestion();
            }
            this.webView.setBackgroundColor(0);
        }
    }

    private void highlightAndReloadQuestion() {
        this.isHighlighted = true;
        ArrayList searchTerms = this.getArguments().getStringArrayList("searchTerms");
        Faq highlightedQuestion = com.helpshift.support.util.Styles.getQuestionWithHighlightedSearchTerms(this.getContext(), this.question, searchTerms);
        if (highlightedQuestion != null) {
            this.setQuestion(highlightedQuestion);
        }
    }

    private void showProgress(boolean visible) {
        if (this.progressBar != null) {
            if (visible) {
                this.progressBar.setVisibility(0);
            } else {
                this.progressBar.setVisibility(8);
            }
        }
    }

    private void updateFooter() {
        if (this.singleQuestionMode == 3) {
            this.hideQuestionFooter();
            return;
        }
        switch (this.isHelpful) {
            case 0: {
                this.showQuestionFooter();
                break;
            }
            case 1: {
                this.showHelpfulFooter();
                break;
            }
            case -1: {
                this.showUnhelpfulFooter();
            }
        }
    }

    private void hideQuestionFooter() {
        this.questionFooter.setVisibility(8);
    }

    private void showQuestionFooter() {
        this.questionFooter.setVisibility(0);
        this.questionFooterMessage.setText((CharSequence)this.getResources().getString(R.string.hs__mark_yes_no_question));
        this.contactUsButton.setVisibility(8);
        this.yesButton.setVisibility(0);
        this.noButton.setVisibility(0);
    }

    private void showHelpfulFooter() {
        this.questionFooter.setVisibility(0);
        this.questionFooterMessage.setText((CharSequence)this.getResources().getString(R.string.hs__question_helpful_message));
        this.questionFooterMessage.setGravity(17);
        this.contactUsButton.setVisibility(8);
        this.yesButton.setVisibility(8);
        this.noButton.setVisibility(8);
    }

    private void showUnhelpfulFooter() {
        this.questionFooter.setVisibility(0);
        this.questionFooterMessage.setText((CharSequence)this.getResources().getString(R.string.hs__question_unhelpful_message));
        this.showQuestionFooterContactUs();
        this.yesButton.setVisibility(8);
        this.noButton.setVisibility(8);
    }

    private void showQuestionFooterContactUs() {
        if (ContactUsFilter.showContactUs(ContactUsFilter.LOCATION.QUESTION_FOOTER)) {
            this.contactUsButton.setVisibility(0);
        } else {
            this.contactUsButton.setVisibility(8);
        }
    }

    public String getQuestionId() {
        String questionId = "";
        if (this.question != null) {
            questionId = this.question.getId();
        }
        return questionId;
    }

    void reportReadFaqEvent() {
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("id", this.question.getId());
        eventData.put("nt", HelpshiftConnectionUtil.isOnline(this.getContext()));
        HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.READ_FAQ, eventData);
        if (this.questionReadListener != null) {
            this.questionReadListener.onQuestionRead(this.question.getId());
        }
        this.eventSent = true;
    }

    private static class Failure
    extends Handler {
        private WeakReference<SingleQuestionFragment> singleQuestionFragmentWeakReference;

        public Failure(SingleQuestionFragment singleQuestionFragment) {
            this.singleQuestionFragmentWeakReference = new WeakReference<SingleQuestionFragment>(singleQuestionFragment);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            SingleQuestionFragment singleQuestionFragment = (SingleQuestionFragment)this.singleQuestionFragmentWeakReference.get();
            if (singleQuestionFragment == null || singleQuestionFragment.isDetached()) {
                return;
            }
            if (singleQuestionFragment.question == null) {
                SnackbarUtil.showErrorSnackbar(102, singleQuestionFragment.getView());
            }
        }
    }

    private static class Success
    extends Handler {
        private WeakReference<SingleQuestionFragment> singleQuestionFragmentWeakReference;

        public Success(SingleQuestionFragment singleQuestionFragment) {
            this.singleQuestionFragmentWeakReference = new WeakReference<SingleQuestionFragment>(singleQuestionFragment);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            SingleQuestionFragment singleQuestionFragment = (SingleQuestionFragment)this.singleQuestionFragmentWeakReference.get();
            if (singleQuestionFragment == null) {
                return;
            }
            Faq question = (Faq)msg.obj;
            if (question == null) {
                return;
            }
            singleQuestionFragment.setQuestion(question);
            String questionId = question.getId();
            HSLogger.d(SingleQuestionFragment.TAG, "FAQ question loaded : " + question.title);
            if (!singleQuestionFragment.eventSent && !TextUtils.isEmpty((CharSequence)questionId)) {
                singleQuestionFragment.reportReadFaqEvent();
            }
        }
    }

    public static class SingleQuestionModes {
        public static final int STANDARD = 1;
        public static final int DONE = 2;
        public static final int ADMIN_SUGGESTED = 3;
    }

    public static interface QuestionReadListener {
        public void onQuestionRead(String var1);
    }
}

