/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.helpshift.CoreApi;
import com.helpshift.R;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.common.FetchDataFromThread;
import com.helpshift.conversation.dto.ImagePickerFile;
import com.helpshift.support.ContactUsFilter;
import com.helpshift.support.HSSearch;
import com.helpshift.support.activities.ParentActivity;
import com.helpshift.support.compositions.FaqFragment;
import com.helpshift.support.compositions.SectionPagerFragment;
import com.helpshift.support.contracts.SupportScreenView;
import com.helpshift.support.controllers.FaqFlowController;
import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.conversations.AuthenticationFailureFragment;
import com.helpshift.support.conversations.BaseConversationFragment;
import com.helpshift.support.conversations.ConversationFragment;
import com.helpshift.support.conversations.ConversationalFragment;
import com.helpshift.support.conversations.NewConversationFragment;
import com.helpshift.support.conversations.usersetup.UserSetupFragment;
import com.helpshift.support.fragments.DynamicFormFragment;
import com.helpshift.support.fragments.FaqFlowFragment;
import com.helpshift.support.fragments.HSMenuItemType;
import com.helpshift.support.fragments.IMenuItemEventListener;
import com.helpshift.support.fragments.IToolbarMenuItemRenderer;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.fragments.QuestionListFragment;
import com.helpshift.support.fragments.ScreenshotPreviewFragment;
import com.helpshift.support.fragments.SearchFragment;
import com.helpshift.support.fragments.SingleQuestionFragment;
import com.helpshift.support.util.FragmentUtil;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.support.widget.ImagePicker;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.Styles;
import com.helpshift.views.HSMenuItemCompat;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class SupportFragment
extends MainFragment
implements View.OnClickListener,
SupportScreenView,
FetchDataFromThread<Integer, Integer>,
ImagePicker.ImagePickerListener,
MenuItem.OnMenuItemClickListener,
IToolbarMenuItemRenderer {
    public static final String SUPPORT_MODE = "support_mode";
    private static final String TAG = "Helpshift_SupportFrag";
    private static boolean isForeground;
    private final List<String> visibleFragments = Collections.synchronizedList(new ArrayList());
    MenuItem contactUsMenuItem;
    private SupportController supportController;
    private View viewNoFaqs;
    private View viewFaqsLoading;
    private View viewFaqsLoadError;
    private boolean menuItemsPrepared;
    private MenuItem searchMenuItem;
    private SearchView searchView;
    private MenuItem doneMenuItem;
    private MenuItem startNewConversationMenuItem;
    private MenuItem attachImageMenuItem;
    private boolean faqLoaded;
    private int newMessageCount = 0;
    private int toolbarId;
    private Toolbar toolbar;
    private int toolbarImportanceForAccessibility;
    private boolean handleNewIntent;
    private Bundle newIntentData;
    private List<Integer> fragmentMenuItems;
    private WeakReference<IMenuItemEventListener> menuItemEventListener;
    private ImagePicker imagePicker;

    public static SupportFragment newInstance(Bundle bundle) {
        SupportFragment supportFragment = new SupportFragment();
        supportFragment.setArguments(bundle);
        return supportFragment;
    }

    public static boolean isForeground() {
        return isForeground;
    }

    public SupportController getSupportController() {
        return this.supportController;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        HelpshiftContext.getPlatform().setUIContext(this.getContext());
        this.setRetainInstance(true);
        if (this.supportController == null) {
            this.supportController = new SupportController(HelpshiftContext.getApplicationContext(), this, this.getRetainedChildFragmentManager(), this.getArguments());
        } else {
            this.supportController.onFragmentManagerUpdate(this.getRetainedChildFragmentManager());
        }
        if (!this.isChangingConfigurations()) {
            HelpshiftContext.getCoreApi().getConversationInboxPoller().startAppPoller(true);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if (this.getArguments() == null) {
            this.quitSupportFragment();
            return;
        }
        if (!this.isChangingConfigurations()) {
            HSLogger.d(TAG, "Helpshift session began.");
            HSSearch.init();
            int supportMode = this.getArguments().getInt(SUPPORT_MODE, 0);
            AnalyticsEventType eventType = supportMode == 0 ? AnalyticsEventType.LIBRARY_OPENED : AnalyticsEventType.LIBRARY_OPENED_DECOMP;
            HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(eventType);
            if (this.handleNewIntent) {
                this.supportController.onNewIntent(this.newIntentData);
                this.handleNewIntent = false;
            }
            HelpshiftContext.getCoreApi().onSDKSessionStarted();
        }
        isForeground = true;
    }

    @Override
    public void onPause() {
        if (!this.getActivity(this).isChangingConfigurations()) {
            this.stopLiveUpdates();
        }
        super.onPause();
    }

    @Override
    public void onStop() {
        if (!this.isChangingConfigurations()) {
            HSLogger.d(TAG, "Helpshift session ended.");
            CoreApi coreApi = HelpshiftContext.getCoreApi();
            HSSearch.deinit();
            coreApi.getAnalyticsEventDM().pushEvent(AnalyticsEventType.LIBRARY_QUIT);
            isForeground = false;
            coreApi.sendAnalyticsEvent();
            coreApi.onSDKSessionEnded();
        }
        HelpshiftContext.getCoreApi().getConversationInboxDM().fetchConversationUpdatesListenerReference = null;
        super.onStop();
    }

    @Override
    public boolean shouldRefreshMenu() {
        return false;
    }

    private int getMenuResourceId() {
        return R.menu.hs__support_fragment;
    }

    private void attachMenuListeners(Menu menu2) {
        this.searchMenuItem = menu2.findItem(R.id.hs__search);
        this.searchView = (SearchView)HSMenuItemCompat.getActionView(this.searchMenuItem);
        this.contactUsMenuItem = menu2.findItem(R.id.hs__contact_us);
        this.contactUsMenuItem.setTitle(R.string.hs__contact_us_btn);
        this.contactUsMenuItem.setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this);
        HSMenuItemCompat.getActionView(this.contactUsMenuItem).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SupportFragment.this.onMenuItemClick(SupportFragment.this.contactUsMenuItem);
            }
        });
        this.doneMenuItem = menu2.findItem(R.id.hs__action_done);
        this.doneMenuItem.setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this);
        this.startNewConversationMenuItem = menu2.findItem(R.id.hs__start_new_conversation);
        this.startNewConversationMenuItem.setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this);
        this.attachImageMenuItem = menu2.findItem(R.id.hs__attach_screenshot);
        this.attachImageMenuItem.setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this);
        this.menuItemsPrepared = true;
        this.setSearchListeners(null);
        this.refreshMenu();
    }

    public boolean onMenuItemClick(MenuItem menuItem) {
        int menuItemId = menuItem.getItemId();
        boolean isActionHandled = false;
        if (menuItemId == R.id.hs__contact_us) {
            this.supportController.onContactUsClicked(null);
            isActionHandled = true;
        } else if (menuItemId == R.id.hs__action_done) {
            this.supportController.actionDone();
            isActionHandled = true;
        } else if (menuItemId == R.id.hs__start_new_conversation) {
            this.sendMenuEventClickEvent(HSMenuItemType.START_NEW_CONVERSATION);
            isActionHandled = true;
        } else if (menuItemId == R.id.hs__attach_screenshot) {
            this.sendMenuEventClickEvent(HSMenuItemType.SCREENSHOT_ATTACHMENT);
            isActionHandled = true;
        }
        return isActionHandled;
    }

    private void sendMenuEventClickEvent(HSMenuItemType type) {
        if (this.menuItemEventListener != null && this.menuItemEventListener.get() != null) {
            ((IMenuItemEventListener)this.menuItemEventListener.get()).onMenuItemClicked(type);
        }
    }

    public void unRegisterSearchListener() {
        if (this.menuItemsPrepared) {
            HSMenuItemCompat.setOnActionExpandListener(this.searchMenuItem, null);
            this.searchView.setOnQueryTextListener(null);
        }
    }

    public void setSearchListeners(FaqFlowController faqFlowController) {
        if (this.menuItemsPrepared) {
            FaqFlowFragment faqFlowFragment;
            if (faqFlowController == null && (faqFlowFragment = FragmentUtil.getFaqFlowFragment(this.getRetainedChildFragmentManager())) != null) {
                faqFlowController = faqFlowFragment.getFaqFlowController();
            }
            if (faqFlowController != null) {
                HSMenuItemCompat.setOnActionExpandListener(this.searchMenuItem, faqFlowController);
                this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)faqFlowController);
            }
        }
    }

    private void setMenuItemColors() {
        Context context = this.getContext();
        Styles.setActionButtonIconColor(context, this.searchMenuItem.getIcon());
        Styles.setActionButtonIconColor(context, this.contactUsMenuItem.getIcon());
        View contactUsView = HSMenuItemCompat.getActionView(this.contactUsMenuItem);
        TextView notificationBadge = (TextView)contactUsView.findViewById(R.id.hs__notification_badge);
        Styles.setActionButtonIconColor(context, notificationBadge.getBackground());
        Styles.setActionButtonIconColor(context, this.doneMenuItem.getIcon());
        Styles.setActionButtonIconColor(context, this.startNewConversationMenuItem.getIcon());
        Styles.setActionButtonIconColor(context, this.attachImageMenuItem.getIcon());
    }

    private void hideAllMenuItems() {
        this.searchMenuItem.setVisible(false);
        this.contactUsMenuItem.setVisible(false);
        this.doneMenuItem.setVisible(false);
        this.startNewConversationMenuItem.setVisible(false);
        this.attachImageMenuItem.setVisible(false);
    }

    public void addVisibleFragment(String fragment) {
        this.visibleFragments.add(fragment);
        this.refreshMenu();
    }

    public void removeVisibleFragment(String fragment) {
        this.visibleFragments.remove(fragment);
    }

    public void onFaqsLoaded() {
        this.faqLoaded = true;
        if (this.menuItemsPrepared && (this.visibleFragments.contains(FaqFragment.class.getName()) || this.visibleFragments.contains(QuestionListFragment.class.getName()))) {
            this.setSearchMenuVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMenu() {
        if (this.menuItemsPrepared) {
            this.hideAllMenuItems();
            this.setMenuItemColors();
            List<String> list = this.visibleFragments;
            synchronized (list) {
                for (String fragment : this.visibleFragments) {
                    if (fragment.equals(FaqFragment.class.getName())) {
                        this.showFaqFragmentMenu();
                        continue;
                    }
                    if (fragment.equals(SearchFragment.class.getName())) {
                        this.restoreSearchMenuItem();
                        continue;
                    }
                    if (fragment.equals(SingleQuestionFragment.class.getName() + 1)) {
                        this.showSingleQuestionFragmentMenu();
                        continue;
                    }
                    if (fragment.equals(SectionPagerFragment.class.getName())) {
                        this.showSectionPagerFragmentMenu();
                        continue;
                    }
                    if (fragment.equals(QuestionListFragment.class.getName())) {
                        this.showQuestionListFragmentMenu();
                        continue;
                    }
                    if (fragment.equals(NewConversationFragment.class.getName()) || fragment.equals(ConversationFragment.class.getName()) || fragment.equals(ConversationalFragment.class.getName())) {
                        this.restoreConversationFragmentMenu();
                        continue;
                    }
                    if (fragment.equals(SingleQuestionFragment.class.getName() + 2)) {
                        this.restoreSingleQuestionDoneModeFragmentMenu();
                        continue;
                    }
                    if (fragment.equals(DynamicFormFragment.class.getName())) {
                        this.showDynamicFormFragmentMenu();
                        continue;
                    }
                    if (!fragment.equals(UserSetupFragment.class.getName()) && !fragment.equals(AuthenticationFailureFragment.class.getName())) continue;
                    this.setRetainSearchFragmentState(true);
                    this.setSearchMenuVisible(false);
                    this.setContactUsMenuVisible(false);
                }
            }
        }
    }

    private void restoreSingleQuestionDoneModeFragmentMenu() {
        this.doneMenuItem.setVisible(true);
    }

    private void restoreConversationFragmentMenu() {
        this.setRetainSearchFragmentState(true);
        this.setSearchMenuVisible(false);
        this.setContactUsMenuVisible(false);
        BaseConversationFragment baseConversationFragment = (BaseConversationFragment)this.getRetainedChildFragmentManager().findFragmentByTag("HSNewConversationFragment");
        if (baseConversationFragment == null) {
            baseConversationFragment = (BaseConversationFragment)this.getRetainedChildFragmentManager().findFragmentByTag("HSConversationFragment");
        }
        if (baseConversationFragment != null) {
            this.doneMenuItem.setVisible(false);
        }
    }

    private void showQuestionListFragmentMenu() {
        this.setSearchMenuVisible(this.faqLoaded);
        this.setContactUsMenuVisible(ContactUsFilter.showContactUs(ContactUsFilter.LOCATION.ACTION_BAR));
    }

    private void showSectionPagerFragmentMenu() {
        this.setSearchMenuVisible(true);
        this.setContactUsMenuVisible(ContactUsFilter.showContactUs(ContactUsFilter.LOCATION.ACTION_BAR));
    }

    private void showSingleQuestionFragmentMenu() {
        if (!this.isScreenLarge()) {
            this.setRetainSearchFragmentState(true);
            this.setSearchMenuVisible(false);
        }
        this.setContactUsMenuVisible(ContactUsFilter.showContactUs(ContactUsFilter.LOCATION.QUESTION_ACTION_BAR));
    }

    private void setRetainSearchFragmentState(boolean retainSearchFragmentState) {
        FaqFlowFragment faqFlowFragment = (FaqFlowFragment)this.getRetainedChildFragmentManager().findFragmentByTag("Helpshift_FaqFlowFrag");
        if (faqFlowFragment != null && faqFlowFragment.getFaqFlowController() != null) {
            faqFlowFragment.getFaqFlowController().setRetainSearchFragmentState(retainSearchFragmentState);
        }
    }

    private void restoreSearchMenuItem() {
        SearchFragment searchFragment;
        FaqFlowFragment faqFlowFragment = FragmentUtil.getFaqFlowFragment(this.getRetainedChildFragmentManager());
        if (faqFlowFragment != null && (searchFragment = FragmentUtil.getSearchFragment(faqFlowFragment.getRetainedChildFragmentManager())) != null) {
            this.setSearchMenuQuery(searchFragment.getCurrentQuery());
        }
        this.setContactUsMenuVisible(ContactUsFilter.showContactUs(ContactUsFilter.LOCATION.ACTION_BAR));
        this.setRetainSearchFragmentState(false);
    }

    private void showFaqFragmentMenu() {
        this.setSearchMenuVisible(this.faqLoaded);
        this.setContactUsMenuVisible(ContactUsFilter.showContactUs(ContactUsFilter.LOCATION.ACTION_BAR));
    }

    private void showDynamicFormFragmentMenu() {
        this.setRetainSearchFragmentState(true);
        this.setContactUsMenuVisible(false);
        this.setSearchMenuVisible(false);
    }

    public void setContactUsMenuVisible(boolean visible) {
        if (HSMenuItemCompat.isActionViewExpanded(this.searchMenuItem)) {
            this.contactUsMenuItem.setVisible(false);
        } else {
            this.contactUsMenuItem.setVisible(visible);
        }
        this.updateBadgeIcon();
    }

    public void setSearchMenuVisible(boolean visible) {
        if (HSMenuItemCompat.isActionViewExpanded(this.searchMenuItem) && !this.visibleFragments.contains(SearchFragment.class.getName())) {
            HSMenuItemCompat.collapseActionView(this.searchMenuItem);
        }
        this.searchMenuItem.setVisible(visible);
    }

    public void setSearchMenuQuery(String query) {
        if (!HSMenuItemCompat.isActionViewExpanded(this.searchMenuItem)) {
            HSMenuItemCompat.expandActionView(this.searchMenuItem);
        }
        if (!TextUtils.isEmpty((CharSequence)query)) {
            this.searchView.setQuery((CharSequence)query, false);
        }
    }

    private void updateBadgeIcon() {
        View actionView;
        if (this.contactUsMenuItem != null && this.contactUsMenuItem.isVisible() && (actionView = HSMenuItemCompat.getActionView(this.contactUsMenuItem)) != null) {
            TextView badge = (TextView)actionView.findViewById(R.id.hs__notification_badge);
            View padding = actionView.findViewById(R.id.hs__notification_badge_padding);
            if (this.newMessageCount != 0) {
                badge.setText((CharSequence)String.valueOf(this.newMessageCount));
                padding.setVisibility(8);
                badge.setVisibility(0);
            } else {
                badge.setVisibility(8);
                padding.setVisibility(0);
            }
        }
    }

    public void resetNewMessageCount() {
        this.updateMessageBatchCount(0);
    }

    public void updateFaqLoadingUI(int state) {
        this.viewNoFaqs.setVisibility(8);
        this.viewFaqsLoading.setVisibility(8);
        this.viewFaqsLoadError.setVisibility(8);
        switch (state) {
            case 0: {
                this.viewFaqsLoading.setVisibility(0);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.viewNoFaqs.setVisibility(0);
                break;
            }
            case 3: {
                this.viewFaqsLoadError.setVisibility(0);
            }
        }
    }

    private void quitSupportFragment() {
        Activity activity = this.getActivity(this);
        if (activity instanceof ParentActivity) {
            activity.finish();
        } else {
            FragmentManager supportFragmentManager = ((AppCompatActivity)activity).getSupportFragmentManager();
            supportFragmentManager.beginTransaction().remove((Fragment)this).commit();
        }
    }

    private void startLiveUpdates() {
        ConversationFragment conversationFragment = (ConversationFragment)this.getRetainedChildFragmentManager().findFragmentByTag("HSConversationFragment");
        if (conversationFragment != null) {
            conversationFragment.startLiveUpdates();
        }
    }

    private void stopLiveUpdates() {
        ConversationFragment conversationFragment = (ConversationFragment)this.getRetainedChildFragmentManager().findFragmentByTag("HSConversationFragment");
        if (conversationFragment != null) {
            conversationFragment.stopLiveUpdates();
        }
    }

    public void onFocusChanged(boolean hasFocus) {
        List fragments = this.getRetainedChildFragmentManager().getFragments();
        if (fragments != null) {
            for (Fragment fragment : fragments) {
                if (!(fragment instanceof ConversationalFragment)) continue;
                ((ConversationalFragment)fragment).onFocusChanged(hasFocus);
            }
        }
    }

    public boolean onBackPressed() {
        List fragments = this.getRetainedChildFragmentManager().getFragments();
        if (fragments != null) {
            for (Fragment fragment : fragments) {
                if (fragment == null || !fragment.isVisible()) continue;
                if (fragment instanceof FaqFlowFragment || fragment instanceof BaseConversationFragment) {
                    FragmentManager childFragmentManager = fragment.getChildFragmentManager();
                    if (childFragmentManager.getBackStackEntryCount() > 0) {
                        childFragmentManager.popBackStack();
                        return true;
                    }
                    if (fragment instanceof ConversationalFragment && ((ConversationalFragment)fragment).onBackPressed()) {
                        return true;
                    }
                    if (!(fragment instanceof ConversationFragment)) continue;
                    ((ConversationFragment)fragment).stopLiveUpdates();
                    return false;
                }
                if (!(fragment instanceof ScreenshotPreviewFragment)) continue;
                ((ScreenshotPreviewFragment)fragment).deleteAttachmentLocalCopy();
                return false;
            }
        }
        return false;
    }

    public void setTitle(String title) {
        if (this.toolbar != null) {
            this.toolbar.setTitle((CharSequence)title);
        } else {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity(this)).getSupportActionBar();
            if (actionBar != null) {
                actionBar.setTitle((CharSequence)title);
            }
        }
    }

    public void showToolbarElevation(boolean visible) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.showToolbarElevationLollipop(visible);
        } else {
            this.showToolbarElevationPreLollipop(visible);
        }
    }

    @TargetApi(value=21)
    private void showToolbarElevationLollipop(boolean visible) {
        if (this.toolbar != null) {
            if (visible) {
                this.toolbar.setElevation(Styles.dpToPx(this.getContext(), 4.0f));
            } else {
                this.toolbar.setElevation(0.0f);
            }
        } else {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity(this)).getSupportActionBar();
            if (actionBar != null) {
                if (visible) {
                    actionBar.setElevation(Styles.dpToPx(this.getContext(), 4.0f));
                } else {
                    actionBar.setElevation(0.0f);
                }
            }
        }
    }

    private void showToolbarElevationPreLollipop(boolean visible) {
        FrameLayout flowFragmentContainer = (FrameLayout)this.getActivity(this).findViewById(R.id.flow_fragment_container);
        if (flowFragmentContainer != null) {
            if (visible) {
                Drawable shadow = this.getResources().getDrawable(R.drawable.hs__actionbar_compat_shadow);
                flowFragmentContainer.setForeground(shadow);
            } else {
                flowFragmentContainer.setForeground((Drawable)new ColorDrawable(0));
            }
        }
    }

    @Override
    public void exitSdkSession() {
        if (this.getActivity() instanceof ParentActivity) {
            this.getActivity().finish();
        } else {
            FragmentUtil.removeFragment(this.getActivity().getSupportFragmentManager(), this);
        }
    }

    @Override
    public void launchImagePicker(boolean checkPermission, Bundle extras) {
        if (checkPermission) {
            this.getImagePicker().checkPermissionAndLaunchImagePicker(extras);
        } else {
            this.getImagePicker().launchImagePicker(extras);
        }
    }

    public void onNewIntent(Bundle data) {
        if (isForeground) {
            this.supportController.onNewIntent(data);
        } else {
            this.newIntentData = data;
        }
        this.handleNewIntent = !isForeground;
    }

    private void updateMessageBatchCount(Integer newMessageCount) {
        this.newMessageCount = newMessageCount;
        this.updateBadgeIcon();
    }

    @Override
    public void onDataFetched(Integer newMessageCount) {
        this.updateMessageBatchCount(newMessageCount);
    }

    @Override
    public void onFailure(Integer count) {
    }

    public void registerToolbarMenuEventsListener(IMenuItemEventListener menuItemEventListener) {
        this.menuItemEventListener = new WeakReference<IMenuItemEventListener>(menuItemEventListener);
    }

    public void unRegisterToolbarMenuEventsListener(IMenuItemEventListener menuItemEventListener) {
        if (this.menuItemEventListener != null && this.menuItemEventListener.get() == menuItemEventListener) {
            this.menuItemEventListener = null;
        }
    }

    public void onClick(View v) {
        FaqFlowFragment faqFlowFragment;
        if (v.getId() == R.id.button_retry && (faqFlowFragment = FragmentUtil.getFaqFlowFragment(this.getRetainedChildFragmentManager())) != null) {
            faqFlowFragment.retryGetSections();
        }
    }

    private synchronized ImagePicker getImagePicker() {
        if (this.imagePicker == null) {
            this.imagePicker = new ImagePicker<SupportFragment>(this);
        }
        return this.imagePicker;
    }

    @Override
    public void updateMenuItemVisibility(HSMenuItemType menuType, boolean isVisible) {
        switch (menuType) {
            case START_NEW_CONVERSATION: {
                if (this.startNewConversationMenuItem == null) break;
                this.startNewConversationMenuItem.setVisible(isVisible);
                break;
            }
            case SCREENSHOT_ATTACHMENT: {
                if (this.attachImageMenuItem == null) break;
                this.attachImageMenuItem.setVisible(isVisible);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        if ((requestCode == 1 || requestCode == 2) && intent != null && resultCode == -1) {
            this.getImagePicker().onImagePickRequestResult(requestCode, intent);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        List fragments = this.getRetainedChildFragmentManager().getFragments();
        if (fragments != null) {
            for (Fragment fragment : fragments) {
                if (fragment == null || !fragment.isVisible() || !(fragment instanceof BaseConversationFragment)) continue;
                fragment.onRequestPermissionsResult(requestCode, permissions, grantResults);
                return;
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.toolbarId = bundle.getInt("toolbarId");
        }
        if (this.toolbarId == 0) {
            this.setHasOptionsMenu(true);
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__support_fragment, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.viewNoFaqs = view.findViewById(R.id.view_no_faqs);
        this.viewFaqsLoading = view.findViewById(R.id.view_faqs_loading);
        this.viewFaqsLoadError = view.findViewById(R.id.view_faqs_load_error);
        Button buttonRetry = (Button)view.findViewById(R.id.button_retry);
        buttonRetry.setOnClickListener((View.OnClickListener)this);
        if (HelpshiftContext.getCoreApi().getSDKConfigurationDM().isHelpshiftBrandingDisabled()) {
            ImageView hsLogo = (ImageView)view.findViewById(R.id.hs_logo);
            hsLogo.setVisibility(8);
        }
        if (this.toolbarId != 0) {
            this.toolbar = (Toolbar)this.getActivity(this).findViewById(this.toolbarId);
            Menu parentMenu = this.toolbar.getMenu();
            ArrayList<Integer> parentMenuItems = new ArrayList<Integer>();
            for (int i = 0; i < parentMenu.size(); ++i) {
                parentMenuItems.add(parentMenu.getItem(i).getItemId());
            }
            this.toolbar.inflateMenu(this.getMenuResourceId());
            this.attachMenuListeners(this.toolbar.getMenu());
            Menu fragmentMenu = this.toolbar.getMenu();
            this.fragmentMenuItems = new ArrayList<Integer>();
            for (int i = 0; i < fragmentMenu.size(); ++i) {
                int menuItemId = fragmentMenu.getItem(i).getItemId();
                if (parentMenuItems.contains(menuItemId)) continue;
                this.fragmentMenuItems.add(menuItemId);
            }
        }
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (savedInstanceState != null) {
            if (this.supportController != null) {
                this.supportController.onViewStateRestored(savedInstanceState);
            }
            this.getImagePicker().onViewStateRestored(savedInstanceState);
        }
    }

    public void onResume() {
        super.onResume();
        this.supportController.start();
        this.setToolbarTitle(this.getString(R.string.hs__help_header));
        this.showToolbarElevation(true);
        HelpshiftContext.getCoreApi().getConversationInboxDM().fetchConversationUpdatesListenerReference = new AtomicReference<SupportFragment>(this);
        this.startLiveUpdates();
        this.updateMessageBatchCount(HelpshiftContext.getCoreApi().getNotificationCountSync());
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.supportController != null) {
            this.supportController.onSaveInstanceState(outState);
        }
        this.getImagePicker().onSaveInstanceState(outState);
    }

    public void onDestroyView() {
        SnackbarUtil.hideSnackbar(this.getView());
        if (this.toolbar != null) {
            Menu toolbarMenu = this.toolbar.getMenu();
            for (Integer menuItem : this.fragmentMenuItems) {
                toolbarMenu.removeItem(menuItem.intValue());
            }
        }
        this.viewFaqsLoadError = null;
        this.viewFaqsLoading = null;
        this.viewNoFaqs = null;
        super.onDestroyView();
    }

    public void onDetach() {
        HelpshiftContext.getPlatform().setUIContext(null);
        ApplicationUtil.restoreApplicationLocale();
        if (!this.isChangingConfigurations()) {
            HelpshiftContext.getCoreApi().getConversationInboxPoller().startAppPoller(true);
        }
        super.onDetach();
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(this.getMenuResourceId(), menu2);
        this.attachMenuListeners(menu2);
        if (this.menuItemEventListener != null && this.menuItemEventListener.get() != null) {
            ((IMenuItemEventListener)this.menuItemEventListener.get()).onCreateOptionMenuCalled();
        }
        super.onCreateOptionsMenu(menu2, inflater);
    }

    @Override
    public void askForReadStoragePermission() {
        BaseConversationFragment baseConversationFragment = (BaseConversationFragment)this.getRetainedChildFragmentManager().findFragmentByTag("HSConversationFragment");
        if (baseConversationFragment == null) {
            baseConversationFragment = (BaseConversationFragment)this.getRetainedChildFragmentManager().findFragmentByTag("HSNewConversationFragment");
        }
        if (baseConversationFragment != null) {
            baseConversationFragment.requestPermission(true, 2);
        }
    }

    @Override
    public void onImagePickerResultSuccess(ImagePickerFile imagePickerFile, Bundle extraData) {
        this.getSupportController().startScreenshotPreviewFragment(imagePickerFile, extraData, ScreenshotPreviewFragment.LaunchSource.GALLERY_APP);
    }

    @Override
    public void onImagePickerResultFailure(int errorCode, Long data) {
        switch (errorCode) {
            case -4: {
                SnackbarUtil.showSnackbar(this.getView(), R.string.hs__network_error_msg, -1);
                break;
            }
            case -2: {
                SnackbarUtil.showSnackbar(this.getView(), R.string.hs__screenshot_upload_error_msg, -1);
                break;
            }
            case -1: {
                SnackbarUtil.showSnackbar(this.getView(), R.string.hs__screenshot_cloud_attach_error, -1);
                break;
            }
            case -3: {
                String errorString = String.format(this.getResources().getString(R.string.hs__screenshot_limit_error), Float.valueOf((float)data.longValue() / 1048576.0f));
                SnackbarUtil.showSnackbar(this.getView(), errorString, -1);
            }
        }
    }

    public void setToolbarImportanceForAccessibility(int mode) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (this.toolbar != null) {
            this.toolbarImportanceForAccessibility = this.toolbar.getImportantForAccessibility();
            this.toolbar.setImportantForAccessibility(mode);
        } else {
            Activity activity = this.getActivity(this);
            if (activity instanceof ParentActivity) {
                ((ParentActivity)activity).setToolbarImportanceForAccessibility(mode);
            }
        }
    }

    public void resetToolbarImportanceForAccessibility() {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (this.toolbar != null) {
            this.toolbar.setImportantForAccessibility(this.toolbarImportanceForAccessibility);
        } else {
            Activity activity = this.getActivity(this);
            if (activity instanceof ParentActivity) {
                ((ParentActivity)activity).setToolbarImportanceForAccessibility(0);
            }
        }
    }

    public static class SupportModes {
        public static final int CONVERSATION = 1;
        public static final int FAQ_SECTION = 2;
        public static final int SINGLE_QUESTION = 3;
        public static final int DYNAMIC_FORM = 4;
    }
}

