/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import com.helpshift.analytics.AnalyticsEventDAO;
import com.helpshift.common.StringUtils;
import com.helpshift.common.platform.KVStore;
import java.util.HashMap;
import java.util.Map;

public class AndroidAnalyticsEventDAO
implements AnalyticsEventDAO {
    private static final String KEY_UNSENT_ANALYTICS_EVENTS = "unsent_analytics_events";
    private KVStore kvStore;

    public AndroidAnalyticsEventDAO(KVStore kvStore) {
        this.kvStore = kvStore;
    }

    @Override
    public void saveUnsentAnalyticsData(String key, HashMap<String, String> data) {
        HashMap<String, HashMap<String, String>> listToStore = this.getUnSentAnalyticFromDB();
        listToStore.put(key, data);
        this.kvStore.setSerializable(KEY_UNSENT_ANALYTICS_EVENTS, listToStore);
    }

    @Override
    public void removeAnalyticsData(String key) {
        if (StringUtils.isEmpty(key)) {
            return;
        }
        HashMap<String, HashMap<String, String>> listToStore = this.getUnSentAnalyticFromDB();
        listToStore.remove(key);
        if (listToStore.size() == 0) {
            this.kvStore.setSerializable(KEY_UNSENT_ANALYTICS_EVENTS, null);
        } else {
            this.kvStore.setSerializable(KEY_UNSENT_ANALYTICS_EVENTS, listToStore);
        }
    }

    @Override
    public Map<String, HashMap<String, String>> getUnsentAnalytics() {
        return this.getUnSentAnalyticFromDB();
    }

    private HashMap<String, HashMap<String, String>> getUnSentAnalyticFromDB() {
        Object fromDB = this.kvStore.getSerializable(KEY_UNSENT_ANALYTICS_EVENTS);
        HashMap<String, HashMap<String, String>> listToStore = fromDB == null ? new HashMap<String, HashMap<String, String>>() : (HashMap<String, HashMap<String, String>>)fromDB;
        return listToStore;
    }
}

