/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.ContentResolver;
import android.provider.Settings;
import com.helpshift.CoreApi;
import com.helpshift.HelpshiftUser;
import com.helpshift.account.dao.ProfileDTO;
import com.helpshift.account.domainmodel.UserDM;
import com.helpshift.common.ListUtils;
import com.helpshift.common.StringUtils;
import com.helpshift.common.dao.BackupDAO;
import com.helpshift.common.domain.Domain;
import com.helpshift.common.platform.KVStore;
import com.helpshift.common.platform.network.KeyValuePair;
import com.helpshift.migration.LegacyAnalyticsEventIDDAO;
import com.helpshift.migration.LegacyProfileMigrationDAO;
import com.helpshift.migration.MigrationState;
import com.helpshift.migration.legacyUser.LegacyProfile;
import com.helpshift.migration.legacyUser.LegacyProfileDAO;
import com.helpshift.support.HSStorage;
import com.helpshift.support.storage.SDKMigrator;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.VersionName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class LegacyUserDataMigrator
implements SDKMigrator {
    private static final String LOGIN_IDENTIFIER = "loginIdentifier";
    private static final String DEFAULT_USER_LOGIN_KEY = "default_user_login";
    private static final String DEFAULT_USER_PROFILE = "default_user_profile";
    private static final String KEY_DEVICE_ID = "key_support_device_id";
    private CoreApi coreApi;
    private Domain domain;
    private KVStore kvStore;
    private HSStorage hsStorage;
    private LegacyProfileDAO legacyProfileDAO;
    private LegacyProfileMigrationDAO legacyProfileMigrationDAO;
    private LegacyAnalyticsEventIDDAO legacyAnalyticsEventIDDAO;
    private BackupDAO backupDAO;
    private String loginIdentifier;
    private String defaultIdentifier;
    private ProfileDTO defaultProfileDto;
    private List<ProfileDTO> loginProfileDtos;
    private VersionName fromVersion;

    public LegacyUserDataMigrator(CoreApi coreApi, HSStorage hsStorage, KVStore kvStore, LegacyProfileDAO legacyProfileDAO, BackupDAO backupDAO, LegacyProfileMigrationDAO userMigrationDataSource, LegacyAnalyticsEventIDDAO legacyAnalyticsEventIDDAO, VersionName fromVersion) {
        this.coreApi = coreApi;
        this.domain = coreApi.getDomain();
        this.hsStorage = hsStorage;
        this.kvStore = kvStore;
        this.legacyProfileDAO = legacyProfileDAO;
        this.backupDAO = backupDAO;
        this.legacyProfileMigrationDAO = userMigrationDataSource;
        this.legacyAnalyticsEventIDDAO = legacyAnalyticsEventIDDAO;
        this.fromVersion = fromVersion;
    }

    @Override
    public void backup(VersionName fromVersion) {
        if (fromVersion.isGreaterThanOrEqualTo(new VersionName("7.0.0"))) {
            return;
        }
        if (fromVersion.isLessThanOrEqualTo(new VersionName("4.9.1"))) {
            this.loginIdentifier = this.hsStorage.getString(LOGIN_IDENTIFIER);
            String defaultUserServerId = this.hsStorage.getString("identity");
            this.defaultIdentifier = this.hsStorage.getString("uuid");
            if (StringUtils.isEmpty(this.defaultIdentifier)) {
                this.defaultIdentifier = Settings.Secure.getString((ContentResolver)HelpshiftContext.getApplicationContext().getContentResolver(), (String)"android_id");
            }
            this.defaultProfileDto = new ProfileDTO(null, this.defaultIdentifier, defaultUserServerId, this.hsStorage.getString("username"), this.hsStorage.getString("email"), null, null, null, true);
            List<ProfileDTO> loginProfileDtosList = this.legacyProfileDAO.fetchProfiles();
            if (!ListUtils.isEmpty(loginProfileDtosList)) {
                this.loginProfileDtos = new ArrayList<ProfileDTO>();
                for (ProfileDTO profileDTO : loginProfileDtosList) {
                    String saltedIdentifier = profileDTO.identifier + "_" + profileDTO.saltedIdentifier;
                    ProfileDTO newProfileDTO = new ProfileDTO(profileDTO.localId, profileDTO.identifier, profileDTO.serverId, profileDTO.name, profileDTO.email, saltedIdentifier, profileDTO.uid, profileDTO.did, profileDTO.isPushTokenSynced);
                    this.loginProfileDtos.add(newProfileDTO);
                }
            }
        } else {
            Object defaultProfile;
            this.loginIdentifier = this.kvStore.getString(LOGIN_IDENTIFIER);
            this.defaultIdentifier = this.kvStore.getString(DEFAULT_USER_LOGIN_KEY);
            if (!StringUtils.isEmpty(this.defaultIdentifier) && (defaultProfile = this.kvStore.getSerializable(DEFAULT_USER_PROFILE)) instanceof ProfileDTO) {
                this.defaultProfileDto = (ProfileDTO)defaultProfile;
            }
            this.loginProfileDtos = this.legacyProfileDAO.fetchProfiles();
        }
    }

    @Override
    public void restore() {
        if (this.fromVersion.isGreaterThanOrEqualTo(new VersionName("7.0.0"))) {
            return;
        }
        if (this.defaultIdentifier != null) {
            this.kvStore.setString(KEY_DEVICE_ID, this.defaultIdentifier);
            this.backupDAO.storeValue(KEY_DEVICE_ID, (Serializable)((Object)this.defaultIdentifier));
        }
        ArrayList<KeyValuePair> legacyAnalyticEventIDs = new ArrayList<KeyValuePair>();
        ArrayList<LegacyProfile> legacyProfiles = new ArrayList<LegacyProfile>();
        if (this.defaultProfileDto != null && !StringUtils.isEmpty(this.defaultProfileDto.serverId)) {
            UserDM anonymousUser = this.domain.getUserManagerDM().getAnonymousUser();
            if (anonymousUser == null) {
                anonymousUser = this.domain.getUserManagerDM().createAnonymousUser();
            }
            legacyProfiles.add(new LegacyProfile(anonymousUser.getIdentifier(), this.defaultProfileDto.email, this.defaultProfileDto.name, this.defaultProfileDto.serverId, MigrationState.NOT_STARTED));
        }
        if (!ListUtils.isEmpty(this.loginProfileDtos)) {
            for (ProfileDTO profileDTO : this.loginProfileDtos) {
                if (!StringUtils.isEmpty(profileDTO.serverId)) {
                    legacyProfiles.add(new LegacyProfile(profileDTO.identifier, profileDTO.email, profileDTO.name, profileDTO.serverId, MigrationState.NOT_STARTED));
                }
                KeyValuePair keyValuePair = new KeyValuePair(profileDTO.identifier, profileDTO.saltedIdentifier);
                legacyAnalyticEventIDs.add(keyValuePair);
            }
        }
        if (!ListUtils.isEmpty(legacyProfiles)) {
            this.legacyProfileMigrationDAO.storeLegacyProfiles(legacyProfiles);
        }
        if (!ListUtils.isEmpty(legacyAnalyticEventIDs)) {
            this.legacyAnalyticsEventIDDAO.storeLegacyAnalyticsEventIDs(legacyAnalyticEventIDs);
        }
        if (StringUtils.isEmpty(this.loginIdentifier)) {
            this.coreApi.logout();
        } else if (this.loginProfileDtos != null) {
            for (ProfileDTO profileDTO : this.loginProfileDtos) {
                if (!this.loginIdentifier.equals(profileDTO.identifier)) continue;
                this.coreApi.login(new HelpshiftUser.Builder(profileDTO.identifier, profileDTO.email).setName(profileDTO.email).build());
                break;
            }
        }
    }

    public void dropProfileDB() {
        this.legacyProfileDAO.deleteProfiles();
    }
}

