/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.helpshift.support.Faq;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.Section;
import com.helpshift.support.storage.FaqDAO;
import com.helpshift.support.storage.FaqsDBHelper;
import com.helpshift.support.storage.FaqsDataSource;
import com.helpshift.support.storage.SectionDAO;
import com.helpshift.util.HSLogger;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SectionsDataSource
implements SectionDAO {
    private static final String TAG = "HelpShiftDebug";
    private final FaqsDBHelper dbHelper = FaqsDBHelper.getInstance();
    private FaqDAO faqDAO = FaqsDataSource.getInstance();

    private SectionsDataSource() {
    }

    private static Section cursorToSection(Cursor cursor) {
        return new Section(cursor.getLong(0), cursor.getString(1), cursor.getString(3), cursor.getString(2));
    }

    private static ContentValues sectionToContentValues(JSONObject section) throws JSONException {
        ContentValues values = new ContentValues();
        values.put("title", section.getString("title"));
        values.put("publish_id", section.getString("publish_id"));
        values.put("section_id", section.getString("id"));
        return values;
    }

    public static SectionsDataSource getInstance() {
        return LazyHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void storeSections(JSONArray sections) {
        SQLiteDatabase database = this.dbHelper.getWritableDatabase();
        try {
            database.beginTransaction();
            for (int i = 0; i < sections.length(); ++i) {
                JSONObject section = sections.getJSONObject(i);
                database.insert("sections", null, SectionsDataSource.sectionToContentValues(section));
                JSONArray faqs = section.optJSONArray("faqs");
                if (faqs == null) continue;
                String sectionPublishId = section.getString("publish_id");
                FaqsDataSource.addFaqsUnsafe(database, sectionPublishId, faqs);
            }
            database.setTransactionSuccessful();
        }
        catch (JSONException e) {
            HSLogger.e(TAG, "Error in storeSections", e);
        }
        finally {
            try {
                if (database != null && database.inTransaction()) {
                    database.endTransaction();
                }
            }
            catch (Exception e) {
                HSLogger.e(TAG, "Error in storeSections inside finally block", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Section getSection(String publishId) {
        if (publishId == null || publishId.equals("")) {
            return new Section();
        }
        Section section = null;
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query("sections", null, "publish_id = ?", new String[]{publishId}, null, null, null);
            cursor.moveToFirst();
            if (!cursor.isAfterLast()) {
                section = SectionsDataSource.cursorToSection(cursor);
            }
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<Section> getAllSections() {
        ArrayList<Section> sections = new ArrayList<Section>();
        try (Cursor cursor = null;){
            SQLiteDatabase database = this.dbHelper.getReadableDatabase();
            cursor = database.query("sections", null, null, null, null, null, null);
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                Section section = SectionsDataSource.cursorToSection(cursor);
                sections.add(section);
                cursor.moveToNext();
            }
        }
        return sections;
    }

    @Override
    public List<Section> getAllSections(FaqTagFilter faqTagFilter) {
        List<Section> allSections = this.getAllSections();
        if (faqTagFilter == null) {
            return allSections;
        }
        ArrayList<Section> filteredSections = new ArrayList<Section>();
        for (Section section : allSections) {
            List<Faq> faqsForSection = this.faqDAO.getFaqsForSection(section.getPublishId(), faqTagFilter);
            if (faqsForSection.isEmpty()) continue;
            filteredSections.add(section);
        }
        return filteredSections;
    }

    @Override
    public synchronized void clearSectionsData() {
        try {
            SQLiteDatabase database = this.dbHelper.getWritableDatabase();
            this.dbHelper.clearDatabase(database);
        }
        catch (Exception e) {
            HSLogger.e(TAG, "Error in clearSectionsData", e);
        }
    }

    private static final class LazyHolder {
        static final SectionsDataSource INSTANCE = new SectionsDataSource();

        private LazyHolder() {
        }
    }
}

