/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import com.helpshift.common.StringUtils;
import com.helpshift.common.platform.KVStore;
import com.helpshift.common.platform.Platform;
import com.helpshift.common.platform.network.NetworkRequestDAO;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.meta.dao.MetaDataDAO;
import com.helpshift.support.HSStorage;
import com.helpshift.support.storage.SDKMigrator;
import com.helpshift.support.util.ConfigUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.VersionName;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONObject;

public class SupportKVStoreMigrator
implements SDKMigrator {
    private static final String TAG = "Helpshift_KVStoreMigratorr";
    private HSStorage hsStorage;
    private SDKConfigurationDM sdkConfigurationDM;
    private NetworkRequestDAO networkRequestDAO;
    private MetaDataDAO metaDataDAO;
    private KVStore kvStore;
    private Boolean requireEmail;
    private Boolean fullPrivacy;
    private Boolean hideNameEmail;
    private Boolean showSearchOnNewConversation;
    private Boolean gotoConversationAfterContactUs;
    private Boolean showConversationResolutionQuestion;
    private Boolean showConversationInfoScreen;
    private Boolean enableTypingIndicator;
    private float serverTimeDelta;
    private HashMap<String, Serializable> customMetaData;
    private String deviceId;

    public SupportKVStoreMigrator(HSStorage hsStorage) {
        this.hsStorage = hsStorage;
        this.sdkConfigurationDM = HelpshiftContext.getCoreApi().getSDKConfigurationDM();
        Platform platform = HelpshiftContext.getPlatform();
        this.networkRequestDAO = platform.getNetworkRequestDAO();
        this.metaDataDAO = platform.getMetaDataDAO();
        this.kvStore = HelpshiftContext.getPlatform().getKVStore();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void backup(VersionName fromVersion) {
        this.requireEmail = this.hsStorage.contains("requireEmail") ? this.hsStorage.storageGetBoolean("requireEmail") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("requireEmail"));
        this.fullPrivacy = this.hsStorage.contains("fullPrivacy") ? this.hsStorage.storageGetBoolean("fullPrivacy") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("fullPrivacy"));
        this.hideNameEmail = this.hsStorage.contains("hideNameAndEmail") ? this.hsStorage.storageGetBoolean("hideNameAndEmail") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("hideNameAndEmail"));
        this.showSearchOnNewConversation = this.hsStorage.contains("showSearchOnNewConversation") ? this.hsStorage.storageGetBoolean("showSearchOnNewConversation") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("showSearchOnNewConversation"));
        this.gotoConversationAfterContactUs = this.hsStorage.contains("gotoConversationAfterContactUs") ? this.hsStorage.storageGetBoolean("gotoConversationAfterContactUs") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("gotoConversationAfterContactUs"));
        this.showConversationResolutionQuestion = this.hsStorage.contains("showConversationResolutionQuestion") ? this.hsStorage.storageGetBoolean("showConversationResolutionQuestion") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("showConversationResolutionQuestion"));
        this.showConversationInfoScreen = this.hsStorage.contains("showConversationInfoScreen") ? this.hsStorage.storageGetBoolean("showConversationInfoScreen") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("showConversationInfoScreen"));
        this.enableTypingIndicator = this.hsStorage.contains("enableTypingIndicator") ? this.hsStorage.storageGetBoolean("enableTypingIndicator") : Boolean.valueOf(this.sdkConfigurationDM.getBoolean("enableTypingIndicator"));
        this.deviceId = this.kvStore.getString("key_support_device_id");
        this.serverTimeDelta = this.hsStorage.contains("serverTimeDelta") ? this.hsStorage.storageGetFloat("serverTimeDelta").floatValue() : this.networkRequestDAO.getServerTimeDelta();
        if (this.hsStorage.contains("customMetaData")) {
            String metaString = this.hsStorage.getString("customMetaData");
            try {
                if (StringUtils.isEmpty(metaString)) return;
                JSONObject metaObj = new JSONObject(metaString);
                Iterator iterator = metaObj.keys();
                this.customMetaData = new HashMap();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object value = metaObj.get(key);
                    if (!(value instanceof Serializable)) continue;
                    this.customMetaData.put(key, (Serializable)value);
                }
                return;
            }
            catch (Exception e) {
                HSLogger.d(TAG, "Exception converting meta from storage", e);
                return;
            }
        } else {
            this.customMetaData = this.metaDataDAO.getCustomMetaData();
        }
    }

    @Override
    public void restore() {
        HashMap<String, Boolean> configEntriesToRestore = new HashMap<String, Boolean>();
        configEntriesToRestore.put("requireEmail", this.requireEmail);
        configEntriesToRestore.put("fullPrivacy", this.fullPrivacy);
        configEntriesToRestore.put("hideNameAndEmail", this.hideNameEmail);
        configEntriesToRestore.put("showSearchOnNewConversation", this.showSearchOnNewConversation);
        configEntriesToRestore.put("gotoConversationAfterContactUs", this.gotoConversationAfterContactUs);
        configEntriesToRestore.put("showConversationResolutionQuestion", this.showConversationResolutionQuestion);
        configEntriesToRestore.put("showConversationInfoScreen", this.showConversationInfoScreen);
        configEntriesToRestore.put("enableTypingIndicator", this.enableTypingIndicator);
        HashMap<String, Object> configMap = new HashMap<String, Object>(ConfigUtil.getDefaultApiConfig());
        configMap.putAll(configEntriesToRestore);
        HelpshiftContext.getCoreApi().updateApiConfig(configMap);
        this.networkRequestDAO.storeServerTimeDelta(this.serverTimeDelta);
        this.metaDataDAO.saveCustomMetaData(this.customMetaData);
        if (!StringUtils.isEmpty(this.deviceId)) {
            this.kvStore.setString("key_support_device_id", this.deviceId);
        }
    }
}

