/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.Context;
import android.support.annotation.NonNull;
import com.helpshift.common.platform.KVStore;
import com.helpshift.storage.CachedKeyValueStorage;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.support.storage.SupportRetryKeyValueDBStorage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SupportKeyValueDBStorage
implements KVStore {
    private KeyValueStorage storage;

    public SupportKeyValueDBStorage(Context context) {
        SupportRetryKeyValueDBStorage dbStorage = new SupportRetryKeyValueDBStorage(context);
        this.storage = new CachedKeyValueStorage(dbStorage, this.getCacheWhitelistKeys());
    }

    @NonNull
    private Set<String> getCacheWhitelistKeys() {
        return new HashSet<String>(Arrays.asList("sdkLanguage", "disableInAppConversation", "debugLogLimit", "showAgentName", "enableTypingIndicatorAgent", "enableTypingIndicator", "fullPrivacy", "showConversationInfoScreen", "runtimeVersion", "sdkType", "disableAppLaunchEvent", "pluginVersion", "profileFormEnable", "requireNameAndEmail", "requireEmail", "hideNameAndEmail", "gotoConversationAfterContactUs", "showSearchOnNewConversation", "supportNotificationChannelId", "notificationIconId", "notificationLargeIconId", "app_reviewed", "defaultFallbackLanguageEnable", "conversationGreetingMessage", "conversationalIssueFiling", "showConversationResolutionQuestion", "showConversationResolutionQuestionAgent", "allowUserAttachments", "server_time_delta", "disableHelpshiftBrandingAgent", "disableHelpshiftBranding", "periodicReviewEnabled", "periodicReviewInterval", "periodicReviewType", "customerSatisfactionSurvey", "showConversationHistoryAgent", "enableDefaultConversationalFiling"));
    }

    @Override
    public void setBoolean(String key, Boolean value) {
        this.setOrRemoveKeyInternal(key, value);
    }

    @Override
    public void setInt(String key, Integer value) {
        this.setOrRemoveKeyInternal(key, value);
    }

    @Override
    public void setFloat(String key, Float value) {
        this.setOrRemoveKeyInternal(key, value);
    }

    @Override
    public void setLong(String key, Long value) {
        this.setOrRemoveKeyInternal(key, value);
    }

    @Override
    public void setString(String key, String value) {
        this.setOrRemoveKeyInternal(key, (Serializable)((Object)value));
    }

    @Override
    public Boolean getBoolean(String key) {
        Object value = this.storage.get(key);
        if (value == null) {
            return null;
        }
        return (Boolean)value;
    }

    @Override
    public Boolean getBoolean(String key, Boolean defValue) {
        Object value = this.storage.get(key);
        if (value == null) {
            return defValue;
        }
        return (Boolean)value;
    }

    @Override
    public Integer getInt(String key) {
        Object value = this.storage.get(key);
        if (value == null) {
            return null;
        }
        return (Integer)value;
    }

    @Override
    public Integer getInt(String key, Integer defValue) {
        Object value = this.storage.get(key);
        if (value == null) {
            return defValue;
        }
        return (Integer)value;
    }

    @Override
    public Float getFloat(String key) {
        Object value = this.storage.get(key);
        if (value == null) {
            return null;
        }
        return (Float)value;
    }

    @Override
    public Float getFloat(String key, Float defValue) {
        Object value = this.storage.get(key);
        if (value == null) {
            return defValue;
        }
        return (Float)value;
    }

    @Override
    public Long getLong(String key) {
        Object value = this.storage.get(key);
        if (value == null) {
            return null;
        }
        return (Long)value;
    }

    @Override
    public Long getLong(String key, Long defValue) {
        Object value = this.storage.get(key);
        if (value == null) {
            return defValue;
        }
        return (Long)value;
    }

    @Override
    public String getString(String key) {
        Object value = this.storage.get(key);
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    @Override
    public String getString(String key, String defValue) {
        Object value = this.storage.get(key);
        if (value == null) {
            return defValue;
        }
        return (String)value;
    }

    @Override
    public void setSerializable(String key, Serializable value) {
        this.setOrRemoveKeyInternal(key, value);
    }

    @Override
    public Object getSerializable(String key) {
        Object value = this.storage.get(key);
        return value;
    }

    @Override
    public void removeAllKeys() {
        this.storage.removeAllKeys();
    }

    @Override
    public void setKeyValues(Map<String, Serializable> keyValues) {
        this.storage.setKeyValues(keyValues);
    }

    private void setOrRemoveKeyInternal(String key, Serializable value) {
        if (value == null) {
            this.storage.removeKey(key);
        } else {
            this.storage.set(key, value);
        }
    }
}

