/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.content.Context;
import com.helpshift.support.flows.ConversationFlow;
import com.helpshift.support.flows.DynamicFormFlow;
import com.helpshift.support.flows.FAQSectionFlow;
import com.helpshift.support.flows.FAQsFlow;
import com.helpshift.support.flows.Flow;
import com.helpshift.support.flows.SingleFAQFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynamicFormUtil {
    public static List<Flow> toFlowList(Context context, List<HashMap<String, Object>> flowArray) {
        ArrayList<Flow> flowList = new ArrayList<Flow>();
        for (HashMap<String, Object> flowMap : flowArray) {
            flowList.add(DynamicFormUtil.toFlow(context, flowMap));
        }
        return flowList;
    }

    public static Flow toFlow(Context context, HashMap flowMap) {
        Flow flow = null;
        String type = (String)flowMap.get("type");
        HashMap config = new HashMap();
        if (flowMap.containsKey("config")) {
            config = (HashMap)flowMap.get("config");
        }
        String titleResName = (String)flowMap.get("titleResourceName");
        int resId = 0;
        if (titleResName != null) {
            resId = context.getResources().getIdentifier(titleResName, "string", context.getPackageName());
        }
        String title = "";
        if (resId == 0) {
            title = (String)flowMap.get("title");
        }
        if (type.equals("faqsFlow")) {
            flow = resId != 0 ? new FAQsFlow(resId, (Map)config) : new FAQsFlow(title, (Map)config);
        } else if (type.equals("conversationFlow")) {
            flow = resId != 0 ? new ConversationFlow(resId, (Map)config) : new ConversationFlow(title, (Map)config);
        } else if (type.equals("faqSectionFlow")) {
            String sectionId = (String)flowMap.get("data");
            flow = resId != 0 ? new FAQSectionFlow(resId, sectionId, (Map)config) : new FAQSectionFlow(title, sectionId, (Map)config);
        } else if (type.equals("singleFaqFlow")) {
            String faqId = (String)flowMap.get("data");
            flow = resId != 0 ? new SingleFAQFlow(resId, faqId, (Map)config) : new SingleFAQFlow(title, faqId, (Map)config);
        } else if (type.equals("dynamicFormFlow")) {
            ArrayList flowArray = (ArrayList)flowMap.get("data");
            List<Flow> flowList = DynamicFormUtil.toFlowList(context, flowArray);
            flow = resId != 0 ? new DynamicFormFlow(resId, flowList) : new DynamicFormFlow(title, flowList);
        }
        return flow;
    }
}

