/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import com.helpshift.R;
import com.helpshift.support.activities.ParentActivity;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.AssetsUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.Xml;
import java.io.Serializable;

public final class SupportNotification {
    public static final String APP_NAME = "app_name";
    public static final String BUNGLE_ARG_NOTIFICATION_CONVERSATION_ID = "conversationIdInPush";

    public static NotificationCompat.Builder createNotification(Context context, Long conversationLocalId, String conversationLocalUUID, int newMessCnt, String contentTitle) {
        Uri soundUri;
        Integer largeNotificationIconFromConfig;
        String TAG = "Helpshift_SupportNotif";
        HSLogger.d(TAG, "Creating Support notification : \n Id : " + conversationLocalUUID + "\n Title : " + contentTitle + "\n Message count : " + newMessCnt);
        HelpshiftContext.getCoreApi().getDelegate().didReceiveNotification(newMessCnt);
        String notifText = context.getResources().getQuantityString(R.plurals.hs__notification_content_title, newMessCnt, new Object[]{newMessCnt});
        int notificationIcon = Xml.getLogoResourceValue(context);
        Bitmap largeNotificationIcon = null;
        Integer notificationIconFromConfig = HelpshiftContext.getCoreApi().getSDKConfigurationDM().getInt("notificationIconId");
        if (notificationIconFromConfig != null) {
            notificationIcon = notificationIconFromConfig;
        }
        if ((largeNotificationIconFromConfig = HelpshiftContext.getCoreApi().getSDKConfigurationDM().getInt("notificationLargeIconId")) != null) {
            largeNotificationIcon = BitmapFactory.decodeResource((Resources)context.getResources(), (int)largeNotificationIconFromConfig);
        }
        int notificationId = 0;
        if (conversationLocalUUID != null) {
            notificationId = Math.abs(conversationLocalUUID.hashCode());
        }
        Intent notificationIntent = new Intent(context, ParentActivity.class);
        notificationIntent.setFlags(0x10000000);
        notificationIntent.putExtra("support_mode", 1);
        notificationIntent.putExtra(BUNGLE_ARG_NOTIFICATION_CONVERSATION_ID, (Serializable)conversationLocalId);
        notificationIntent.putExtra("isRoot", true);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)notificationId, (Intent)notificationIntent, (int)0);
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(context);
        notificationBuilder.setSmallIcon(notificationIcon);
        notificationBuilder.setContentTitle((CharSequence)contentTitle);
        notificationBuilder.setContentText((CharSequence)notifText);
        notificationBuilder.setContentIntent(contentIntent);
        notificationBuilder.setAutoCancel(true);
        if (largeNotificationIcon != null) {
            notificationBuilder.setLargeIcon(largeNotificationIcon);
        }
        if ((soundUri = AssetsUtil.getNotificationSoundUri()) == null) {
            if (ApplicationUtil.isPermissionGranted(context, "android.permission.VIBRATE")) {
                notificationBuilder.setDefaults(-1);
            } else {
                notificationBuilder.setDefaults(5);
            }
        } else {
            notificationBuilder.setSound(soundUri);
            if (ApplicationUtil.isPermissionGranted(context, "android.permission.VIBRATE")) {
                notificationBuilder.setDefaults(6);
            } else {
                notificationBuilder.setDefaults(4);
            }
        }
        return notificationBuilder;
    }
}

