/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.views;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;

public class DotView
extends View
implements ValueAnimator.AnimatorUpdateListener {
    private int dotColor;
    private Paint paint;
    private float centerX = -1.0f;
    private float centerY = -1.0f;
    private float radius;
    private RectF ovalRectF;

    public DotView(Context context, int dotColor) {
        super(context);
        this.dotColor = dotColor;
        this.setup();
    }

    public DotView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DotView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setDotColor(int dotColor) {
        this.dotColor = dotColor;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawOval(this.ovalRectF, this.paint);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
        this.radius = Math.min(this.centerX, this.centerY);
        this.updateOvalRectF();
    }

    private void updateOvalRectF() {
        this.ovalRectF.left = this.centerX - this.radius;
        this.ovalRectF.right = this.centerX + this.radius;
        this.ovalRectF.top = this.centerY - this.radius;
        this.ovalRectF.bottom = this.centerY + this.radius;
    }

    private void setup() {
        this.ovalRectF = new RectF();
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setColor(this.dotColor);
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        this.dotColor = Color.argb((int)((Integer)animation.getAnimatedValue()), (int)Color.red((int)this.dotColor), (int)Color.green((int)this.dotColor), (int)Color.blue((int)this.dotColor));
        this.paint.setColor(this.dotColor);
        this.invalidate();
    }
}

