/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.views;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.helpshift.conversation.activeconversation.message.input.OptionInput;
import com.helpshift.util.Styles;
import java.util.ArrayList;
import java.util.List;

public class HSAdjustableSelectOptionsViewInflater {
    private Context context;
    private LinearLayout containerView;
    private int selectOptionInflaterLayout;
    private int optionTextViewId;
    private int optionDrawableId;
    private int optionColorId;
    private View.OnClickListener optionSelectionListener;
    private List<OptionInput.Option> options;
    private double maxAvailableWidthScaleFactor;
    private int rightEndPadding;

    public HSAdjustableSelectOptionsViewInflater(Context context, double maxAvailableWidthScaleFactor, int rightEndPadding, LinearLayout containerView, int selectOptionInflaterLayout, int optionTextViewId, int optionDrawableId, int optionColorId, List<OptionInput.Option> options, View.OnClickListener optionSelectionListener) {
        this.context = context;
        this.maxAvailableWidthScaleFactor = maxAvailableWidthScaleFactor;
        this.rightEndPadding = rightEndPadding;
        this.containerView = containerView;
        this.selectOptionInflaterLayout = selectOptionInflaterLayout;
        this.optionTextViewId = optionTextViewId;
        this.optionDrawableId = optionDrawableId;
        this.optionColorId = optionColorId;
        this.optionSelectionListener = optionSelectionListener;
        this.options = options;
    }

    public void inflate() {
        ArrayList<LinearLayout> layouts = new ArrayList<LinearLayout>();
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        int totalAvailableWidth = (int)((double)displayMetrics.widthPixels * this.maxAvailableWidthScaleFactor) - (int)((float)this.rightEndPadding * displayMetrics.density);
        int size = this.options.size();
        int i = 0;
        block0: while (i < size) {
            LinearLayout linearLayout = new LinearLayout(this.context);
            linearLayout.setOrientation(0);
            linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            linearLayout.setGravity(0x800005);
            do {
                View optionContentView = LayoutInflater.from((Context)this.context).inflate(this.selectOptionInflaterLayout, null, false);
                TextView optionTextView = (TextView)optionContentView.findViewById(this.optionTextViewId);
                int paddingLeft = optionTextView.getPaddingLeft();
                int paddingTop = optionTextView.getPaddingTop();
                int paddingRight = optionTextView.getPaddingRight();
                int paddingBottom = optionTextView.getPaddingBottom();
                Styles.setDrawable(this.context, (View)optionTextView, this.optionDrawableId, this.optionColorId);
                optionTextView.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
                optionTextView.setMaxWidth(totalAvailableWidth);
                OptionInput.Option option = this.options.get(i);
                optionTextView.setTag((Object)option);
                optionTextView.setText((CharSequence)option.title);
                optionTextView.setOnClickListener(this.optionSelectionListener);
                linearLayout.addView(optionContentView);
                linearLayout.measure(0, 0);
                int occupiedWidth = linearLayout.getMeasuredWidth();
                if (occupiedWidth > totalAvailableWidth) {
                    if (linearLayout.getChildCount() == 1) {
                        ++i;
                    } else {
                        linearLayout.removeView(optionContentView);
                    }
                    layouts.add(linearLayout);
                    continue block0;
                }
                if (i != size - 1) continue;
                layouts.add(linearLayout);
            } while (++i < size);
        }
        for (LinearLayout l : layouts) {
            this.containerView.addView((View)l);
        }
    }
}

