/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.helpshift.R;
import com.helpshift.support.util.AttachmentUtil;

public class HSRoundedImageView
extends AppCompatImageView {
    private final Matrix shaderMatrix = new Matrix();
    private ImageView.ScaleType SCALE_TYPE = ImageView.ScaleType.CENTER_CROP;
    private Bitmap imageBitmap;
    private RectF drawableRect = new RectF();
    private RectF borderRect = new RectF();
    private Paint bitmapPaint;
    private Paint borderPaint;
    private Paint backgroundPaint;
    private BitmapShader bitmapShader;
    private float borderWidth;
    private float cornerRadius;
    private boolean[] isCornerRounded = new boolean[4];
    private String imagePath;
    private Bitmap defaultImageBitmap;

    public HSRoundedImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HSRoundedImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.HSRoundedImageView, 0, 0);
        int borderColor = a.getColor(R.styleable.HSRoundedImageView_hs__borderColor, -1);
        int backgroundColor = a.getColor(R.styleable.HSRoundedImageView_hs__backgroundColor, -1);
        this.borderWidth = a.getDimension(R.styleable.HSRoundedImageView_hs__borderWidth, 0.0f);
        if (this.borderWidth < 0.0f) {
            this.borderWidth = 0.0f;
        }
        this.cornerRadius = a.getDimension(R.styleable.HSRoundedImageView_hs__cornerRadius, 0.0f);
        this.isCornerRounded[0] = a.getBoolean(R.styleable.HSRoundedImageView_hs__roundedTopLeft, true);
        this.isCornerRounded[1] = a.getBoolean(R.styleable.HSRoundedImageView_hs__roundedTopRight, true);
        this.isCornerRounded[2] = a.getBoolean(R.styleable.HSRoundedImageView_hs__roundedBottomLeft, true);
        this.isCornerRounded[3] = a.getBoolean(R.styleable.HSRoundedImageView_hs__roundedBottomRight, true);
        Drawable defaultDrawable = a.getDrawable(R.styleable.HSRoundedImageView_hs__placeholder);
        if (defaultDrawable instanceof BitmapDrawable) {
            this.defaultImageBitmap = ((BitmapDrawable)defaultDrawable).getBitmap();
        }
        a.recycle();
        this.bitmapPaint = new Paint();
        this.bitmapPaint.setStyle(Paint.Style.FILL);
        this.bitmapPaint.setAntiAlias(true);
        this.borderPaint = new Paint();
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setAntiAlias(true);
        this.borderPaint.setColor(borderColor);
        this.borderPaint.setStrokeWidth(this.borderWidth);
        if (backgroundColor != -1) {
            this.backgroundPaint = new Paint();
            this.backgroundPaint.setStyle(Paint.Style.FILL);
            this.backgroundPaint.setColor(backgroundColor);
            this.backgroundPaint.setAntiAlias(true);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.setup();
    }

    private void setup() {
        this.loadImageBitmap();
        if (this.imageBitmap != null) {
            this.updateGlobalParamsAndBitmapShader(this.imageBitmap);
        } else if (this.defaultImageBitmap != null) {
            this.updateGlobalParamsAndBitmapShader(this.defaultImageBitmap);
        } else {
            this.invalidate();
        }
    }

    private void updateGlobalParamsAndBitmapShader(Bitmap bitmap) {
        if (bitmap != null && this.getWidth() > 0 && this.getHeight() > 0) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            this.borderRect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            this.drawableRect.set(this.borderRect);
            this.borderRect.inset(this.borderWidth / 2.0f, this.borderWidth / 2.0f);
            this.drawableRect.inset(this.borderWidth, this.borderWidth);
            this.bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.updateShaderMatrix(this.bitmapShader, width, height);
            this.invalidate();
        }
    }

    private void loadImageBitmap() {
        this.imageBitmap = !TextUtils.isEmpty((CharSequence)this.imagePath) && this.getWidth() > 0 ? AttachmentUtil.getBitmap(this.imagePath, this.getWidth()) : null;
    }

    public void loadImage(String filePath) {
        if (filePath != null) {
            if ((filePath = filePath.trim()).equals(this.imagePath)) {
                if (this.imageBitmap == null) {
                    this.setup();
                }
            } else {
                this.imagePath = filePath;
                this.setup();
            }
        } else {
            this.imagePath = null;
            this.setup();
        }
    }

    public ImageView.ScaleType getScaleType() {
        return this.SCALE_TYPE;
    }

    protected void onDraw(Canvas canvas) {
        this.bitmapPaint.setShader((Shader)this.bitmapShader);
        if (this.borderWidth > 0.0f) {
            if (this.backgroundPaint != null) {
                canvas.drawRoundRect(this.drawableRect, this.cornerRadius - this.borderWidth, this.cornerRadius - this.borderWidth, this.backgroundPaint);
            }
            canvas.drawRoundRect(this.drawableRect, this.cornerRadius - this.borderWidth, this.cornerRadius - this.borderWidth, this.bitmapPaint);
            canvas.drawRoundRect(this.borderRect, this.cornerRadius, this.cornerRadius, this.borderPaint);
            this.redrawBitmapForSquareCorners(canvas, this.backgroundPaint);
            this.redrawBitmapForSquareCorners(canvas, this.bitmapPaint);
            this.redrawBorderForSquareCorners(canvas);
        } else {
            if (this.backgroundPaint != null) {
                canvas.drawRoundRect(this.drawableRect, this.cornerRadius, this.cornerRadius, this.backgroundPaint);
            }
            canvas.drawRoundRect(this.drawableRect, this.cornerRadius, this.cornerRadius, this.bitmapPaint);
            this.redrawBitmapForSquareCorners(canvas, this.backgroundPaint);
            this.redrawBitmapForSquareCorners(canvas, this.bitmapPaint);
        }
    }

    private void redrawBitmapForSquareCorners(Canvas canvas, Paint paint) {
        if (this.cornerRadius <= 0.0f || paint == null) {
            return;
        }
        float left = this.drawableRect.left;
        float top = this.drawableRect.top;
        float right = left + this.drawableRect.width();
        float bottom = top + this.drawableRect.height();
        float radius = this.cornerRadius;
        RectF squareRect = new RectF();
        if (!this.isCornerRounded[0]) {
            squareRect.set(left, top, left + radius, top + radius);
            canvas.drawRect(squareRect, paint);
        }
        if (!this.isCornerRounded[1]) {
            squareRect.set(right - radius, top, right, top + radius);
            canvas.drawRect(squareRect, paint);
        }
        if (!this.isCornerRounded[2]) {
            squareRect.set(left, bottom - radius, left + radius, bottom);
            canvas.drawRect(squareRect, paint);
        }
        if (!this.isCornerRounded[3]) {
            squareRect.set(right - radius, bottom - radius, right, bottom);
            canvas.drawRect(squareRect, paint);
        }
    }

    private void redrawBorderForSquareCorners(Canvas canvas) {
        if (this.cornerRadius > 0.0f) {
            float left = this.borderRect.left;
            float top = this.borderRect.top;
            float right = left + this.borderRect.width();
            float bottom = top + this.borderRect.height();
            float radius = this.cornerRadius;
            float offset = this.borderWidth;
            if (!this.isCornerRounded[0]) {
                canvas.drawLine(left - offset, top, left + radius, top, this.borderPaint);
                canvas.drawLine(left, top - offset, left, top + radius, this.borderPaint);
            }
            if (!this.isCornerRounded[1]) {
                canvas.drawLine(right - radius - offset, top, right, top, this.borderPaint);
                canvas.drawLine(right, top - offset, right, top + radius, this.borderPaint);
            }
            if (!this.isCornerRounded[3]) {
                canvas.drawLine(right - radius - offset, bottom, right + offset, bottom, this.borderPaint);
                canvas.drawLine(right, bottom - radius, right, bottom, this.borderPaint);
            }
            if (!this.isCornerRounded[2]) {
                canvas.drawLine(left - offset, bottom, left + radius, bottom, this.borderPaint);
                canvas.drawLine(left, bottom - radius, left, bottom, this.borderPaint);
            }
        }
    }

    private void updateShaderMatrix(BitmapShader bitmapShader, int bitmapWidth, int bitmapHeight) {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            float imageScale;
            float dx = 0.0f;
            float dy = 0.0f;
            if (bitmapWidth > bitmapHeight) {
                imageScale = this.drawableRect.height() / (float)bitmapHeight;
                dx = (this.drawableRect.width() - (float)bitmapWidth * imageScale) * 0.5f;
            } else {
                imageScale = this.drawableRect.width() / (float)bitmapWidth;
                dy = (this.drawableRect.height() - (float)bitmapHeight * imageScale) * 0.5f;
            }
            this.shaderMatrix.setScale(imageScale, imageScale);
            this.shaderMatrix.postTranslate((float)((int)(dx + 0.5f)) + this.borderWidth, (float)((int)(dy + 0.5f)) + this.borderWidth);
            bitmapShader.setLocalMatrix(this.shaderMatrix);
        }
    }

    private static class Corner {
        static final int TOP_LEFT = 0;
        static final int TOP_RIGHT = 1;
        static final int BOTTOM_LEFT = 2;
        static final int BOTTOM_RIGHT = 3;

        private Corner() {
        }
    }
}

