/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.webkit;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.helpshift.analytics.AnalyticsEventType;
import com.helpshift.util.FileUtil;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class CustomWebViewClient
extends WebViewClient {
    public static final String TAG = CustomWebViewClient.class.getSimpleName();
    private final CustomWebViewClientListeners customWebViewClientListeners;
    private Context context;

    public CustomWebViewClient(Context context, CustomWebViewClientListeners customWebViewClientListeners) {
        this.customWebViewClientListeners = customWebViewClientListeners;
        this.context = context;
    }

    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        if (Build.VERSION.SDK_INT >= 24 && this.handleUrlClick(view, request.getUrl().toString())) {
            return true;
        }
        return super.shouldOverrideUrlLoading(view, request);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (Build.VERSION.SDK_INT < 24 && this.handleUrlClick(view, url)) {
            return true;
        }
        return super.shouldOverrideUrlLoading(view, url);
    }

    private boolean handleUrlClick(WebView view, String url) {
        Context context = view.getContext();
        if (!TextUtils.isEmpty((CharSequence)url)) {
            url = url.trim();
            Intent intent = new Intent("android.intent.action.VIEW");
            Uri data = Uri.parse((String)url);
            intent.setData(data);
            if (intent.resolveActivity(context.getPackageManager()) != null) {
                String protocol = data.getScheme();
                this.pushFAQDeeplinkClickEvent(url, protocol);
                context.startActivity(intent);
                return true;
            }
        }
        return false;
    }

    private void pushFAQDeeplinkClickEvent(String url, String protocol) {
        HashMap<String, Object> analyticsData = new HashMap<String, Object>();
        analyticsData.put("p", protocol);
        analyticsData.put("u", url);
        HelpshiftContext.getCoreApi().getAnalyticsEventDM().pushEvent(AnalyticsEventType.LINK_VIA_FAQ, analyticsData);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        this.customWebViewClientListeners.onPageStarted();
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        this.customWebViewClientListeners.onPageFinished();
    }

    private WebResourceResponse interceptRequest(String inputUrl) {
        URL url = null;
        File storagePath = this.context.getExternalCacheDir();
        try {
            url = new URL(inputUrl);
        }
        catch (MalformedURLException e) {
            HSLogger.d(TAG, "MalformedURLException", e);
        }
        if (url != null) {
            File saveFile = new File(storagePath, inputUrl.replace("/", "_"));
            if (saveFile.exists()) {
                try {
                    return new WebResourceResponse("", "", (InputStream)new FileInputStream(saveFile));
                }
                catch (FileNotFoundException e) {
                    HSLogger.w(TAG, "FileNotFoundException", e);
                }
            } else if (FileUtil.isSupportedMimeType(FileUtil.getMimeType(url))) {
                FileUtil.saveFile(url, saveFile);
            }
        }
        return null;
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        WebResourceResponse response;
        if (Build.VERSION.SDK_INT >= 21 && (response = this.interceptRequest(request.getUrl().toString())) != null) {
            return response;
        }
        return super.shouldInterceptRequest(view, request);
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, String inputUrl) {
        WebResourceResponse response;
        if (Build.VERSION.SDK_INT < 21 && (response = this.interceptRequest(inputUrl)) != null) {
            return response;
        }
        return super.shouldInterceptRequest(view, inputUrl);
    }

    public static interface CustomWebViewClientListeners {
        public void onPageStarted();

        public void onPageFinished();
    }
}

