/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import com.helpshift.util.HSLogger;
import com.helpshift.util.HelpshiftContext;
import java.util.Locale;

public final class ApplicationUtil {
    private static final String TAG = "Helpshift_AppUtil";
    private static final int NOTIFICATION_ID = 1;

    public static String getApplicationVersion(Context context) {
        String appVersion = null;
        try {
            String packageName = context.getPackageName();
            PackageInfo p = context.getPackageManager().getPackageInfo(packageName, 0);
            appVersion = p.versionName;
        }
        catch (Exception e) {
            HSLogger.d(TAG, "Error getting app version", e);
        }
        return appVersion;
    }

    public static int getTargetSDKVersion(Context c) {
        int targetVersion = 0;
        try {
            ApplicationInfo applicationInfo = c.getApplicationInfo();
            targetVersion = applicationInfo.targetSdkVersion;
        }
        catch (Exception e) {
            HSLogger.d(TAG, "Target SDK version not found", e);
        }
        return targetVersion;
    }

    public static String getApplicationName(Context context) {
        String appName = null;
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = context.getApplicationInfo();
            appName = pm.getApplicationLabel(ai).toString();
        }
        catch (Exception e) {
            HSLogger.d(TAG, "Error getting application name", e);
        }
        if (appName == null) {
            return "Support";
        }
        return appName;
    }

    public static boolean isPermissionGranted(Context context, String permissionName) {
        boolean isPermissionGranted = false;
        try {
            isPermissionGranted = ContextCompat.checkSelfPermission((Context)context, (String)permissionName) == 0;
        }
        catch (Exception e) {
            HSLogger.d(TAG, "Error checking for permission : " + permissionName, e);
        }
        return isPermissionGranted;
    }

    public static void showNotification(Context context, String tag, Notification notification) {
        if (notification == null) {
            return;
        }
        HSLogger.d(TAG, "Showing notification : Tag : " + tag);
        NotificationManager notificationManager = ApplicationUtil.getNotificationManager(context);
        if (notificationManager != null) {
            notificationManager.notify(tag, 1, notification);
        }
    }

    public static void cancelNotification(String tag) {
        HSLogger.d(TAG, "Cancelling notification : Tag : " + tag);
        ApplicationUtil.cancelNotification(HelpshiftContext.getApplicationContext(), tag, 1);
    }

    public static void cancelNotification(Context context, String tag, int id2) {
        HSLogger.d(TAG, "Cancelling notification : Tag : " + tag + ", id : " + id2);
        NotificationManager notificationManager = ApplicationUtil.getNotificationManager(context);
        if (notificationManager != null) {
            notificationManager.cancel(tag, id2);
        }
    }

    @Nullable
    public static NotificationManager getNotificationManager(Context context) {
        NotificationManager notificationManager = null;
        try {
            notificationManager = (NotificationManager)context.getSystemService("notification");
        }
        catch (Exception e) {
            HSLogger.e(TAG, "Unable to get notification manager from System service", e);
        }
        return notificationManager;
    }

    public static Intent getLaunchIntent(Context context, String packageName) {
        Intent launchIntentForPackage = null;
        try {
            PackageManager pm = context.getPackageManager();
            launchIntentForPackage = pm.getLaunchIntentForPackage(packageName);
        }
        catch (Exception e) {
            HSLogger.d(TAG, "Error getting launch activity for package : " + packageName, e);
        }
        return launchIntentForPackage;
    }

    public static Context getContextWithUpdatedLocale(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            return context;
        }
        Locale locale = HelpshiftContext.getCoreApi().getLocaleProviderDM().getCurrentLocaleFromStorage();
        if (locale != null) {
            Resources res = context.getResources();
            Configuration config = new Configuration(res.getConfiguration());
            config.setLocale(locale);
            context = context.createConfigurationContext(config);
        }
        return context;
    }

    public static Context getContextWithUpdatedLocaleLegacy(Context context) {
        Locale locale = HelpshiftContext.getCoreApi().getLocaleProviderDM().getCurrentLocaleFromStorage();
        if (locale != null) {
            HelpshiftContext.getCoreApi().getLocaleProviderDM().backupApplicationLocale();
            Resources res = context.getResources();
            Configuration config = new Configuration(res.getConfiguration());
            config.locale = locale;
            res.updateConfiguration(config, res.getDisplayMetrics());
        }
        return context;
    }

    public static void restoreApplicationLocale() {
        HelpshiftContext.getCoreApi().getLocaleProviderDM().restoreApplicationLocale();
    }

    @Nullable
    public static String getSupportLibVersion(Context context) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInfo.metaData != null) {
                return appInfo.metaData.getString("android.support.VERSION");
            }
        }
        catch (Exception e) {
            HSLogger.d(TAG, "Error getting SupportLib version : ", e);
        }
        return null;
    }

    public static boolean isSupportLibVersionEqualAndAbove(Context context, int version) {
        try {
            String supportLibVersion = ApplicationUtil.getSupportLibVersion(context);
            if (supportLibVersion != null) {
                String[] parts = supportLibVersion.split("\\.");
                int majorVersion = Integer.parseInt(parts[0]);
                return majorVersion >= version;
            }
        }
        catch (Exception e) {
            HSLogger.d(TAG, "Error in doing comparison check for supportLib version : ", e);
        }
        return false;
    }

    public static boolean isApplicationDebuggable(Context context) {
        return 0 != (context.getApplicationInfo().flags & 2);
    }
}

