/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.helpshift.util.HSLogger;
import java.util.ArrayList;
import java.util.List;

public class DatabaseUtils {
    public static final int MAX_WILDCARD_COUNT = 900;

    public static boolean exists(SQLiteDatabase database, String table, String query, String[] selectionArgs) {
        return android.database.DatabaseUtils.longForQuery((SQLiteDatabase)database, (String)("SELECT COUNT(*) FROM " + table + " WHERE " + query + " LIMIT 1"), (String[])selectionArgs) > 0L;
    }

    public static String makePlaceholders(int len) {
        if (len >= 1) {
            StringBuilder sb = new StringBuilder(len * 2 - 1);
            sb.append("?");
            for (int i = 1; i < len; ++i) {
                sb.append(",?");
            }
            return sb.toString();
        }
        return null;
    }

    public static <T> List<List<T>> createBatches(int batchSize, List<T> data) {
        ArrayList<List<T>> batches = new ArrayList<List<T>>();
        if (batchSize > data.size()) {
            batches.add(data);
        } else {
            int end = batchSize;
            for (int start = 0; end <= data.size() && start <= end; start += batchSize) {
                List<T> batch = data.subList(start, end);
                end = Math.min(batch.size() + end, data.size());
                if (batch.size() <= 0) continue;
                batches.add(batch);
            }
        }
        return batches;
    }

    public static <T> T parseColumnSafe(Cursor cursor, String columnName, Class<T> type) {
        T result = null;
        try {
            int columnIndex = cursor.getColumnIndex(columnName);
            if (type == Long.class) {
                if (!cursor.isNull(columnIndex)) {
                    Long val = cursor.getLong(columnIndex);
                    result = type.cast(val);
                }
            } else if (type == Integer.class) {
                if (!cursor.isNull(columnIndex)) {
                    Integer val = cursor.getInt(columnIndex);
                    result = type.cast(val);
                }
            } else if (type == String.class) {
                String val = cursor.getString(cursor.getColumnIndex(columnName));
                result = type.cast(val);
            }
        }
        catch (Exception ex) {
            HSLogger.e("DatabaseUtils", "Error in parse long column : " + columnName, ex);
        }
        return result;
    }

    public static boolean parseBooleanColumnSafe(Cursor cursor, String columnName, boolean defaultValue) {
        Boolean value = DatabaseUtils.parseBooleanColumnSafe(cursor, columnName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static Boolean parseBooleanColumnSafe(Cursor cursor, String columnName) {
        Integer value = DatabaseUtils.parseColumnSafe(cursor, columnName, Integer.class);
        if (value == null) {
            return null;
        }
        return value == 1;
    }
}

