/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.webkit.MimeTypeMap;
import com.helpshift.util.HSLogger;
import com.helpshift.util.TextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FileUtil {
    public static final String TAG = FileUtil.class.getSimpleName();
    private static final Set<String> imageMimeTypes = new HashSet<String>(Arrays.asList("image/jpeg", "image/png", "image/gif", "image/x-png", "image/x-citrix-pjpeg", "image/x-citrix-gif", "image/pjpeg"));

    public static boolean isSupportedMimeType(String mimeType) {
        return imageMimeTypes.contains(mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(URL url, File saveFile) {
        try {
            InputStream input = url.openStream();
            FileOutputStream output = new FileOutputStream(saveFile);
            try {
                int bytesRead;
                byte[] buffer = new byte[500];
                while ((bytesRead = input.read(buffer, 0, buffer.length)) >= 0) {
                    ((OutputStream)output).write(buffer, 0, bytesRead);
                }
            }
            finally {
                ((OutputStream)output).close();
                input.close();
            }
        }
        catch (Exception e) {
            HSLogger.d(TAG, "saveFile Exception :", e);
        }
    }

    public static String getMimeType(URL url) {
        try {
            return url.openConnection().getContentType();
        }
        catch (Exception e) {
            HSLogger.d(TAG, "openConnection() Exception :", e);
            return null;
        }
    }

    public static String getMimeType(String fileLocation) {
        try {
            return FileUtil.getMimeType(new URL("file://" + fileLocation));
        }
        catch (MalformedURLException e) {
            HSLogger.d(TAG, "error in getting mimeType :", e);
            return null;
        }
    }

    public static String getFileExtension(String fileLocation) {
        int extensionStartIndex;
        int lastSlashIndex = fileLocation.lastIndexOf(47);
        if (lastSlashIndex < (extensionStartIndex = fileLocation.lastIndexOf(46))) {
            return fileLocation.substring(extensionStartIndex);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesFileFromUriExistAndCanRead(Uri uri, Context context) {
        ParcelFileDescriptor parcelFileDescriptor = null;
        try {
            parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
            boolean bl = parcelFileDescriptor != null;
            return bl;
        }
        catch (Exception e) {
            HSLogger.d(TAG, "Unable to open input file descriptor for doesFileFromUriExistAndCanRead: " + uri, e);
        }
        finally {
            try {
                if (parcelFileDescriptor != null) {
                    parcelFileDescriptor.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public static String getFileExtensionFromMimeType(Context context, @NonNull Uri uri) {
        String extension;
        if ("content".equals(uri.getScheme())) {
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            extension = mime.getExtensionFromMimeType(context.getContentResolver().getType(uri));
        } else {
            extension = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
        }
        return extension;
    }

    @Nullable
    public static File validateAndCreateFile(String filePath) {
        File file;
        if (!TextUtils.isEmpty(filePath) && (file = new File(filePath)).exists()) {
            return file;
        }
        return null;
    }
}

