/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import com.helpshift.common.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HSPattern {
    private static final int IDENTIFIER_LIMIT = 750;
    private static final int EMAIL_LIMIT = 256;
    private static Pattern specialCharPattern;
    private static Pattern namePattern;
    private static Pattern emailPattern;
    private static Pattern ipPattern;
    private static Pattern timeStampPattern;
    private static Pattern domainNamePattern;
    private static Pattern customPropertyPattern;
    private static Pattern propertyKeyPattern;
    private static Pattern urlPattern;
    private static Pattern positiveNumbersPattern;

    public static boolean isValidEmail(String email) {
        if (email == null) {
            return false;
        }
        Matcher m = HSPattern.getEmailPattern().matcher(email.trim());
        return m.matches();
    }

    public static boolean isValidName(String name) {
        if (null == namePattern) {
            namePattern = Pattern.compile("^[\\p{L}\\p{M}\\p{N}].*");
        }
        Matcher m = namePattern.matcher(name.trim());
        return m.matches();
    }

    public static boolean isValidLoginIdentifier(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return true;
        }
        String trimmedIdentifier = identifier.trim();
        if (identifier.length() != trimmedIdentifier.length()) {
            return false;
        }
        return identifier.length() <= 750;
    }

    public static boolean isValidLoginEmail(String email) {
        if (email == null || email.length() == 0) {
            return true;
        }
        String trimmedEmail = email.trim();
        if (email.length() != trimmedEmail.length()) {
            return false;
        }
        if (email.length() > 256) {
            return false;
        }
        Matcher m = HSPattern.getEmailPattern().matcher(email);
        return m.matches();
    }

    public static boolean hasOnlySpecialCharacters(String issueText) {
        if (null == specialCharPattern) {
            specialCharPattern = Pattern.compile("\\W+");
        }
        Matcher m = specialCharPattern.matcher(issueText.trim());
        return m.matches();
    }

    public static String sanitiseCustomPropertyKey(String key) {
        if (null == customPropertyPattern) {
            customPropertyPattern = Pattern.compile("^[A-Za-z0-9_]+$");
        }
        String sanitisedKey = key.trim();
        Matcher m = customPropertyPattern.matcher(sanitisedKey = sanitisedKey.replace("-", "_").replace(" ", "_"));
        if (!m.matches()) {
            sanitisedKey = null;
        }
        return sanitisedKey;
    }

    public static boolean checkIpv4Address(String ipAddress) {
        if (null == ipPattern) {
            ipPattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)$");
        }
        if (ipAddress == null || ipAddress.trim().length() == 0) {
            return false;
        }
        Matcher m = ipPattern.matcher(ipAddress.trim());
        if (m.matches()) {
            for (int i = 1; i < m.groupCount(); ++i) {
                String componentString = m.group(i);
                Integer component = Integer.parseInt(componentString);
                if (component >= 0 && component <= 255) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Pattern getComponentPlaceHolderPattern(String component) {
        return Pattern.compile("^[\\p{L}\\p{N}-]+_" + component + "_\\d{17}-[0-9a-z]{15}$");
    }

    public static Pattern getTimeStampPattern() {
        if (null == timeStampPattern) {
            timeStampPattern = Pattern.compile("^\\d+.\\d{3}$");
        }
        return timeStampPattern;
    }

    public static Pattern getDomainNamePattern() {
        if (null == domainNamePattern) {
            domainNamePattern = Pattern.compile("^[\\p{L}\\p{N}][\\p{L}\\p{N}-]*[\\p{L}\\p{N}]\\.helpshift\\.(com|mobi)$");
        }
        return domainNamePattern;
    }

    public static Pattern getPropertyKeyPattern() {
        if (null == propertyKeyPattern) {
            propertyKeyPattern = Pattern.compile("^[\\p{L}\\p{N}][\\p{L}\\p{N}\\p{Pd}\\p{Pc}]*[\\p{L}\\p{N}]$");
        }
        return propertyKeyPattern;
    }

    public static Pattern getUrlPattern() {
        if (null == urlPattern) {
            urlPattern = Pattern.compile("[^\\p{Z}\\n\\p{Ps}]+://[^\\p{Z}\\n\\p{Pe}]*");
        }
        return urlPattern;
    }

    public static boolean isPositiveNumber(String value) {
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        return HSPattern.getPositiveNumbersPattern().matcher(value).matches();
    }

    private static Pattern getEmailPattern() {
        if (null == emailPattern) {
            emailPattern = Pattern.compile("(?i)^[\\p{L}\\p{N}\\p{M}\\p{S}\\p{Po}A-Z0-9._%'-]{1,64}(\\+.*)?@[\\p{L}\\p{M}\\p{N}\\p{S}A-Z0-9'.-]{1,246}\\.[\\p{L}\\p{M}\\p{N}\\p{S}A-Z]{2,8}[^\\s]*$");
        }
        return emailPattern;
    }

    private static Pattern getPositiveNumbersPattern() {
        if (positiveNumbersPattern == null) {
            positiveNumbersPattern = Pattern.compile("^[+]?\\p{N}+(\\.\\p{N}+)?$");
        }
        return positiveNumbersPattern;
    }
}

