/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.helpshift.CoreApi;
import com.helpshift.JavaCore;
import com.helpshift.app.CampaignAppLifeCycleListener;
import com.helpshift.common.platform.AndroidPlatform;
import com.helpshift.common.platform.Platform;
import com.helpshift.exceptions.HelpshiftInitializationException;
import com.helpshift.util.ApplicationUtil;
import java.util.concurrent.atomic.AtomicBoolean;

public class HelpshiftContext {
    private static final String TAG = "Helpshift_Context";
    private static final Object lock = new Object();
    private static Context context;
    private static CoreApi coreApi;
    private static Platform platform;
    public static AtomicBoolean installCallSuccessful;
    public static AtomicBoolean installAPICalled;
    private static CampaignAppLifeCycleListener campaignAppLifeCycleListener;

    private HelpshiftContext() {
    }

    public static Context getApplicationContext() {
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setApplicationContext(Context c) {
        Object object = lock;
        synchronized (object) {
            if (context == null) {
                context = c;
            }
        }
    }

    public static CampaignAppLifeCycleListener getCampaignAppLifeCycleListener() {
        return campaignAppLifeCycleListener;
    }

    public static void setCampaignAppLifeCycleListener(@NonNull CampaignAppLifeCycleListener lifeCycleListener) {
        if (campaignAppLifeCycleListener == null) {
            campaignAppLifeCycleListener = lifeCycleListener;
        }
    }

    public static void initializeCore(String apiKey, String domain, String appId) {
        if (platform == null) {
            platform = new AndroidPlatform(context, apiKey, domain, appId);
        }
        if (coreApi == null) {
            coreApi = new JavaCore(platform);
        }
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static CoreApi getCoreApi() {
        return coreApi;
    }

    public static boolean verifyInstall() {
        if (!installAPICalled.get()) {
            String errorString = "com.helpshift.Core.install() method not called with valid arguments";
            if (context == null || context.getApplicationInfo() == null) {
                Log.e((String)TAG, (String)"com.helpshift.Core.install() method not called with valid arguments");
                return false;
            }
            boolean isDebuggable = ApplicationUtil.isApplicationDebuggable(context);
            if (isDebuggable) {
                throw new HelpshiftInitializationException("com.helpshift.Core.install() method not called with valid arguments");
            }
            Log.e((String)TAG, (String)"com.helpshift.Core.install() method not called with valid arguments");
            return false;
        }
        return true;
    }

    static {
        installCallSuccessful = new AtomicBoolean(false);
        installAPICalled = new AtomicBoolean(false);
    }
}

