/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import com.helpshift.util.FileUtil;
import com.helpshift.util.HSLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ImageUtil {
    private static final String TAG = "Helpshift_ImageUtil";
    private static final Set<String> resizableImageMimeTypes = new HashSet<String>(Arrays.asList("image/jpeg", "image/png", "image/x-png", "image/x-citrix-pjpeg", "image/pjpeg"));
    private static Set<String> supportedImageMimeTypes = new HashSet<String>(Arrays.asList("image/jpeg", "image/png", "image/bmp"));

    public static boolean isImageFileFormatSupported(String filePath) {
        String imageMimeType = FileUtil.getMimeType(filePath);
        return supportedImageMimeTypes.contains(imageMimeType);
    }

    public static boolean isResizableImage(String fileLocation) {
        return resizableImageMimeTypes.contains(FileUtil.getMimeType(fileLocation));
    }

    public static boolean isResizableImage(Uri uri, Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        String mimeType = contentResolver.getType(uri);
        return resizableImageMimeTypes.contains(mimeType);
    }

    public static Bitmap getBitmap(String filePath, int sampleSize) {
        File imageFile;
        if (!TextUtils.isEmpty((CharSequence)filePath) && (imageFile = new File(filePath)).canRead()) {
            int defaultSampleSize = 1;
            int count = 0;
            int maxTries = 3;
            while (true) {
                try {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inSampleSize = defaultSampleSize;
                    options.inJustDecodeBounds = false;
                    return BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)options);
                }
                catch (OutOfMemoryError e) {
                    if (sampleSize > 0) {
                        defaultSampleSize = sampleSize;
                        continue;
                    }
                    defaultSampleSize *= 2;
                    if (++count != maxTries) continue;
                }
                break;
            }
        }
        return null;
    }

    public static Bitmap getBitmap(Resources resources, int resId, int sampleSize) {
        int defaultSampleSize = 1;
        int count = 0;
        int maxTries = 3;
        while (true) {
            try {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inSampleSize = defaultSampleSize;
                options.inJustDecodeBounds = false;
                return BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)options);
            }
            catch (OutOfMemoryError e) {
                if (sampleSize > 0) {
                    defaultSampleSize = sampleSize;
                    continue;
                }
                defaultSampleSize *= 2;
                if (++count != maxTries) continue;
                return null;
            }
            break;
        }
    }

    private static Bitmap getBitmapWithMaxDimension(Bitmap bitmap, int maxDimension) {
        int originalWidth = bitmap.getWidth();
        int originalHeight = bitmap.getHeight();
        float scale = (float)maxDimension / (float)Math.max(originalHeight, originalWidth);
        if (scale >= 1.0f) {
            return bitmap;
        }
        int newWidth = (int)((float)originalWidth * scale);
        int newHeight = (int)((float)originalHeight * scale);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)newWidth, (int)newHeight, (boolean)true);
    }

    public static void scaleDownAndSave(String filePath, int maxBitmapMemoryInMb) {
        if (!TextUtils.isEmpty((CharSequence)filePath) && maxBitmapMemoryInMb > 0) {
            File imageFile = new File(filePath);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)options);
            int imageHeight = options.outHeight;
            int imageWidth = options.outWidth;
            int reqWidth = 100 * (int)Math.sqrt((float)(25 * maxBitmapMemoryInMb) * ((float)imageWidth / (float)imageHeight));
            int reqHeight = (int)((float)reqWidth * ((float)imageHeight / (float)imageWidth));
            options.inSampleSize = ImageUtil.calculateInSampleSize(options, reqWidth, reqHeight);
            if (options.inSampleSize > 1) {
                options.inJustDecodeBounds = false;
                Bitmap bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
                if (bitmap != null) {
                    ImageUtil.saveBitmapToFile(bitmap, filePath, FileUtil.getMimeType(filePath));
                }
            }
        }
    }

    public static void scaleDownAndSaveWithMaxDimension(String filePath, int maxDimension) {
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            File imageFile = new File(filePath);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)options);
            int imageHeight = options.outHeight;
            int imageWidth = options.outWidth;
            float scale = (float)maxDimension / (float)Math.max(imageHeight, imageWidth);
            if (scale < 1.0f) {
                int reqWidth = (int)((float)imageWidth * scale);
                int reqHeight = (int)((float)imageHeight * scale);
                options.inSampleSize = ImageUtil.calculateInSampleSize(options, reqWidth, reqHeight);
                options.inJustDecodeBounds = false;
                Bitmap bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
                if (bitmap != null) {
                    bitmap = ImageUtil.getBitmapWithMaxDimension(bitmap, maxDimension);
                    ImageUtil.saveBitmapToFile(bitmap, filePath, FileUtil.getMimeType(filePath));
                }
            }
        }
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveBitmapToFile(Bitmap bitmap, String filePath, String targetMimeType) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileOutputStream fos = null;
        Bitmap.CompressFormat compressionFormat = targetMimeType.contains("png") ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG;
        boolean isCompressionsSuccessful = bitmap.compress(compressionFormat, 70, (OutputStream)bos);
        if (isCompressionsSuccessful) {
            byte[] bitmapdata = bos.toByteArray();
            try {
                fos = new FileOutputStream(filePath, false);
                fos.write(bitmapdata);
                fos.flush();
            }
            catch (IOException e) {
                HSLogger.d(TAG, "saveBitmapToFile : ", e);
            }
            finally {
                try {
                    bos.close();
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            HSLogger.e(TAG, "saveBitmapToFile : Compression Failed");
        }
    }
}

