/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.support.annotation.NonNull;

public class VersionName
implements Comparable<VersionName> {
    @NonNull
    public final int[] numbers;

    public VersionName(@NonNull String version) {
        String[] split = version.split("-")[0].split("\\.");
        this.numbers = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            this.numbers[i] = Integer.valueOf(split[i]);
        }
    }

    @Override
    public int compareTo(@NonNull VersionName another) {
        int maxLength = Math.max(this.numbers.length, another.numbers.length);
        for (int i = 0; i < maxLength; ++i) {
            int right;
            int left = i < this.numbers.length ? this.numbers[i] : 0;
            int n = right = i < another.numbers.length ? another.numbers[i] : 0;
            if (left == right) continue;
            return left < right ? -1 : 1;
        }
        return 0;
    }

    public boolean isGreaterThanOrEqualTo(VersionName another) {
        int result = this.compareTo(another);
        return result == 1 || result == 0;
    }

    public boolean isLessThanOrEqualTo(VersionName another) {
        int result = this.compareTo(another);
        return result == -1 || result == 0;
    }
}

