/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util.concurrent;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.helpshift.util.concurrent.ApiExecutor;
import com.helpshift.util.concurrent.NotifyingRunnable;

public class HandlerThreadExecutor
implements ApiExecutor {
    private final Object syncLock = new Object();
    Handler uiHandler;
    private Handler handler;

    public HandlerThreadExecutor(String name) {
        HandlerThread handlerThread = new HandlerThread(name);
        handlerThread.start();
        this.handler = new Handler(handlerThread.getLooper());
        this.uiHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void runAsync(Runnable r) {
        this.handler.post(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runSync(Runnable r) {
        NotifyingRunnable runnable = new NotifyingRunnable(r);
        Object object = this.syncLock;
        synchronized (object) {
            this.handler.post((Runnable)runnable);
            runnable.waitForCompletion();
        }
    }

    @Override
    public void runOnUiThread(final Runnable r) {
        this.runAsync(new Runnable(){

            @Override
            public void run() {
                HandlerThreadExecutor.this.uiHandler.post(r);
            }
        });
    }

    @Override
    public void awaitForSyncExecution() {
        this.runSync(new Runnable(){

            @Override
            public void run() {
            }
        });
    }
}

