/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.views.bottomsheet;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.view.ViewCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import com.helpshift.R;
import com.helpshift.views.bottomsheet.HSBottomSheetBehaviour;
import java.util.ArrayList;
import java.util.List;

public class HSBottomSheet {
    final View contentView;
    final View referenceWindowView;
    final View bottomSheetParentView;
    final ViewGroup bottomSheet;
    final Window bottomSheetWindow;
    final View viewToDim;
    List<BottomSheetBehavior.BottomSheetCallback> callbacks = new ArrayList<BottomSheetBehavior.BottomSheetCallback>();
    final boolean enableDimAnimation;
    final float dimOpacity;

    HSBottomSheet(View contentView, Window bottomSheetWindow, View referenceWindowView, @Nullable View viewToDim, boolean enableDimAnimation, float dimOpacity, View container, ViewGroup bottomSheet) {
        this.contentView = contentView;
        this.bottomSheetWindow = bottomSheetWindow;
        this.referenceWindowView = referenceWindowView;
        this.viewToDim = viewToDim;
        this.enableDimAnimation = enableDimAnimation;
        this.dimOpacity = dimOpacity;
        this.bottomSheetParentView = container;
        this.bottomSheet = bottomSheet;
    }

    public void show() {
        this.bottomSheet.addView(this.contentView);
        this.attachBehaviourCallback();
        if (this.referenceWindowView != null) {
            this.initiateReferenceViewAttachment();
        } else {
            this.bottomSheetWindow.addContentView(this.bottomSheetParentView, this.getParamsForWindow());
        }
    }

    public void remove() {
        if (ViewCompat.isAttachedToWindow((View)this.bottomSheetParentView)) {
            ((ViewGroup)this.bottomSheetParentView.getParent()).removeView(this.bottomSheetParentView);
        }
        if (this.viewToDim != null && ViewCompat.isAttachedToWindow((View)this.viewToDim)) {
            ((ViewGroup)this.viewToDim.getParent()).removeView(this.viewToDim);
        }
    }

    public void setDraggable(boolean isDraggable) {
        ((HSBottomSheetBehaviour)this.getBottomSheetBehaviour()).setDraggable(isDraggable);
    }

    public void addBottomSheetCallback(@Nullable BottomSheetBehavior.BottomSheetCallback callback) {
        this.callbacks.add(callback);
    }

    public void removeAllBottomSheetCallbacks() {
        this.callbacks.clear();
    }

    private void initiateReferenceViewAttachment() {
        if (ViewCompat.isLaidOut((View)this.referenceWindowView)) {
            this.showOnReferenceView();
        } else {
            this.referenceWindowView.post(new Runnable(){

                @Override
                public void run() {
                    HSBottomSheet.this.showOnReferenceView();
                }
            });
        }
    }

    public View getBottomSheetContentView() {
        return this.contentView;
    }

    void showOnReferenceView() {
        this.setupBottomSheetView();
        this.attachBottomSheetToWindow(this.getParamsForReferenceView());
    }

    ViewGroup.LayoutParams getParamsForWindow() {
        ViewGroup.LayoutParams params = this.contentView.getLayoutParams();
        params.height = -1;
        params.width = -1;
        return params;
    }

    ViewGroup.LayoutParams getParamsForReferenceView() {
        ViewGroup.LayoutParams params = this.contentView.getLayoutParams();
        params.height = -1;
        params.width = this.referenceWindowView.getWidth();
        return params;
    }

    private void attachBottomSheetToWindow(ViewGroup.LayoutParams params) {
        this.bottomSheetWindow.addContentView(this.bottomSheetParentView, params);
    }

    private void attachBehaviourCallback() {
        this.getBottomSheetBehaviour().setBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(){

            public void onStateChanged(@NonNull View view, int state) {
                if (HSBottomSheet.this.viewToDim != null) {
                    if (state == 3) {
                        HSBottomSheet.this.viewToDim.setClickable(true);
                    } else if (state == 4) {
                        HSBottomSheet.this.viewToDim.setClickable(false);
                    }
                }
                if (HSBottomSheet.this.callbacks.size() > 0) {
                    for (BottomSheetBehavior.BottomSheetCallback callback : HSBottomSheet.this.callbacks) {
                        callback.onStateChanged(view, state);
                    }
                }
            }

            public void onSlide(@NonNull View view, float slideOffset) {
                if (HSBottomSheet.this.enableDimAnimation && HSBottomSheet.this.viewToDim != null) {
                    float offset = (slideOffset > 0.0f ? slideOffset : 0.0f) * HSBottomSheet.this.dimOpacity;
                    HSBottomSheet.this.viewToDim.setBackgroundColor(ColorUtils.blendARGB((int)0, (int)-16777216, (float)offset));
                }
                if (HSBottomSheet.this.callbacks.size() > 0) {
                    for (BottomSheetBehavior.BottomSheetCallback callback : HSBottomSheet.this.callbacks) {
                        callback.onSlide(view, slideOffset);
                    }
                }
            }
        });
    }

    void setupBottomSheetView() {
        View rootContentView;
        int[] referenceViewLocations = new int[2];
        this.referenceWindowView.getLocationInWindow(referenceViewLocations);
        int rootViewLeftOffset = 0;
        View windowDecorView = this.bottomSheetWindow.getDecorView();
        if (windowDecorView != null && (rootContentView = windowDecorView.findViewById(0x1020002)) != null) {
            int[] contentViewLocations = new int[2];
            rootContentView.getLocationInWindow(contentViewLocations);
            rootViewLeftOffset = contentViewLocations[0];
        }
        this.bottomSheetParentView.setX((float)Math.max(0, referenceViewLocations[0] - rootViewLeftOffset));
    }

    public BottomSheetBehavior getBottomSheetBehaviour() {
        return BottomSheetBehavior.from((View)this.bottomSheet);
    }

    public static class Builder {
        private Window layoutWindow;
        private int layoutId;
        private View referenceView;
        private View content;
        private boolean enableDimAnimation;
        private float dimOpacity = 1.0f;

        public Builder(@NonNull Window bottomSheetWindow) {
            this.layoutWindow = bottomSheetWindow;
        }

        public Builder contentView(@LayoutRes int layoutId) {
            this.layoutId = layoutId;
            return this;
        }

        public Builder referenceView(@Nullable View referenceView) {
            this.referenceView = referenceView;
            return this;
        }

        public Builder enableDimAnimation(boolean enableDimAnimation) {
            this.enableDimAnimation = enableDimAnimation;
            return this;
        }

        public Builder dimOpacity(float opacity) {
            this.dimOpacity = opacity;
            return this;
        }

        @SuppressLint(value={"InflateParams"})
        public HSBottomSheet inflateAndBuild() {
            if (this.layoutWindow == null) {
                throw new IllegalArgumentException("Bottomsheet layout window can not be null");
            }
            View viewToDim = null;
            if (this.enableDimAnimation) {
                viewToDim = new View(this.referenceView.getContext());
                this.layoutWindow.addContentView(viewToDim, (ViewGroup.LayoutParams)this.layoutWindow.getAttributes());
            }
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.layoutWindow.getContext());
            this.content = layoutInflater.inflate(this.layoutId, null);
            CoordinatorLayout container = (CoordinatorLayout)layoutInflater.inflate(R.layout.hs__bottomsheet_wrapper, null);
            FrameLayout parent = (FrameLayout)container.findViewById(R.id.hs__bottom_sheet);
            return new HSBottomSheet(this.content, this.layoutWindow, this.referenceView, viewToDim, this.enableDimAnimation, this.dimOpacity, (View)container, (ViewGroup)parent);
        }
    }
}

