/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.websockets;

import com.helpshift.websockets.Misc;
import com.helpshift.websockets.WebSocketFrame;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class WebSocketOutputStream
extends FilterOutputStream {
    public WebSocketOutputStream(OutputStream out) {
        super(out);
    }

    public void write(String string2) throws IOException {
        byte[] bytes = Misc.getBytesUTF8(string2);
        this.write(bytes);
    }

    public void write(WebSocketFrame frame) throws IOException {
        this.writeFrame0(frame);
        this.writeFrame1(frame);
        this.writeFrameExtendedPayloadLength(frame);
        byte[] maskingKey = Misc.nextBytes(4);
        this.write(maskingKey);
        this.writeFramePayload(frame, maskingKey);
    }

    private void writeFrame0(WebSocketFrame frame) throws IOException {
        int b = (frame.getFin() ? 128 : 0) | (frame.getRsv1() ? 64 : 0) | (frame.getRsv2() ? 32 : 0) | (frame.getRsv3() ? 16 : 0) | frame.getOpcode() & 0xF;
        this.write(b);
    }

    private void writeFrame1(WebSocketFrame frame) throws IOException {
        int b = 128;
        int len = frame.getPayloadLength();
        b = len <= 125 ? (b |= len) : (len <= 65535 ? (b |= 0x7E) : (b |= 0x7F));
        this.write(b);
    }

    private void writeFrameExtendedPayloadLength(WebSocketFrame frame) throws IOException {
        int len = frame.getPayloadLength();
        if (len <= 125) {
            return;
        }
        if (len <= 65535) {
            this.write(len >> 8 & 0xFF);
            this.write(len & 0xFF);
            return;
        }
        this.write(0);
        this.write(0);
        this.write(0);
        this.write(0);
        this.write(len >> 24 & 0xFF);
        this.write(len >> 16 & 0xFF);
        this.write(len >> 8 & 0xFF);
        this.write(len & 0xFF);
    }

    private void writeFramePayload(WebSocketFrame frame, byte[] maskingKey) throws IOException {
        byte[] payload = frame.getPayload();
        if (payload == null) {
            return;
        }
        for (int i = 0; i < payload.length; ++i) {
            int b = (payload[i] ^ maskingKey[i % 4]) & 0xFF;
            this.write(b);
        }
    }
}

