/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.widget;

import com.helpshift.widget.Widget;
import java.util.regex.Pattern;

public abstract class TextWidget
extends Widget {
    public static final Pattern specialCharactersPattern = Pattern.compile("\\W+");
    private String text;
    private TextWidgetError error;

    public TextWidgetError getError() {
        return this.error;
    }

    protected void setError(TextWidgetError error) {
        this.error = error;
        this.notifyChanged();
    }

    public String getText() {
        return this.text == null ? "" : this.text.trim();
    }

    public void setText(String text) {
        if (!this.getText().equals(text)) {
            this.text = text;
            if (this.getError() != null) {
                this.setError(null);
            }
        }
    }

    public abstract void validateText();

    public static enum TextWidgetError {
        EMPTY,
        LESS_THAN_MINIMUM_LENGTH,
        ONLY_SPECIAL_CHARACTERS,
        INVALID_EMAIL;

    }
}

