/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.widget;

import com.helpshift.common.StringUtils;
import com.helpshift.configuration.domainmodel.SDKConfigurationDM;
import com.helpshift.conversation.activeconversation.ConversationDM;
import com.helpshift.conversation.activeconversation.message.ConversationFooterState;
import com.helpshift.conversation.domainmodel.ConversationInboxDM;
import com.helpshift.conversation.dto.ConversationDetailDTO;
import com.helpshift.conversation.dto.IssueState;
import com.helpshift.widget.ButtonWidget;
import com.helpshift.widget.ConversationFooterWidget;
import com.helpshift.widget.DescriptionWidget;
import com.helpshift.widget.EmailWidget;
import com.helpshift.widget.ImageAttachmentWidget;
import com.helpshift.widget.NameWidget;
import com.helpshift.widget.ProfileFormWidget;
import com.helpshift.widget.ProgressBarWidget;
import com.helpshift.widget.ReplyFieldWidget;
import com.helpshift.widget.ScrollJumperWidget;
import com.helpshift.widget.TextWidget;
import java.util.concurrent.TimeUnit;

public class WidgetGateway {
    private final SDKConfigurationDM config;
    private final ConversationInboxDM conversationInboxDM;

    public WidgetGateway(SDKConfigurationDM config, ConversationInboxDM conversationInboxDM) {
        this.config = config;
        this.conversationInboxDM = conversationInboxDM;
    }

    public ButtonWidget makeStartConversationButtonWidget() {
        ButtonWidget buttonWidget = new ButtonWidget();
        buttonWidget.setVisible(!this.conversationInboxDM.isCreateConversationInProgress());
        return buttonWidget;
    }

    public ReplyFieldWidget makeReplyFieldWidget() {
        return new ReplyFieldWidget(true);
    }

    public ButtonWidget makeReplyBoxWidget(ConversationDM conversationDM, boolean shouldShowReplyBoxOnConversationRejected) {
        ButtonWidget replyBoxWidget = new ButtonWidget();
        this.updateReplyBoxWidget(replyBoxWidget, conversationDM, shouldShowReplyBoxOnConversationRejected);
        return replyBoxWidget;
    }

    public void updateReplyBoxWidget(ButtonWidget replyBoxWidget, ConversationDM conversationDM, boolean shouldShowReplyBoxOnConversationRejected) {
        boolean isVisible = false;
        if (conversationDM.isRedacted) {
            isVisible = false;
        } else if (conversationDM.isIssueInProgress()) {
            isVisible = true;
        } else if (conversationDM.state == IssueState.RESOLUTION_REJECTED && shouldShowReplyBoxOnConversationRejected) {
            isVisible = true;
        }
        replyBoxWidget.setVisible(isVisible);
    }

    public ScrollJumperWidget makeScrollJumperWidget() {
        return new ScrollJumperWidget(false, false);
    }

    public boolean getDefaultVisibilityForConversationInfoButtonWidget() {
        return this.config.getBoolean("showConversationInfoScreen");
    }

    public ConversationFooterWidget makeConversationFooterWidget(ConversationDM conversationDM, boolean shouldShowMessageBoxOnConversationRejected) {
        ConversationFooterWidget widget = new ConversationFooterWidget();
        this.updateConversationFooterWidget(widget, conversationDM, shouldShowMessageBoxOnConversationRejected);
        return widget;
    }

    public void updateConversationFooterWidget(ConversationFooterWidget widget, ConversationDM conversationDM, boolean shouldShowMessageBoxOnConversationRejected) {
        ConversationFooterState state = ConversationFooterState.NONE;
        if (conversationDM.isRedacted) {
            state = ConversationFooterState.REDACTED_STATE;
        } else if (conversationDM.state == IssueState.RESOLUTION_ACCEPTED) {
            state = conversationDM.shouldShowCSATInFooter() ? ConversationFooterState.CSAT_RATING : ConversationFooterState.START_NEW_CONVERSATION;
        } else if (conversationDM.state == IssueState.REJECTED) {
            state = ConversationFooterState.REJECTED_MESSAGE;
        } else if (conversationDM.state == IssueState.ARCHIVED) {
            state = ConversationFooterState.ARCHIVAL_MESSAGE;
        } else if (conversationDM.state == IssueState.RESOLUTION_REQUESTED && this.config.shouldShowConversationResolutionQuestion()) {
            state = ConversationFooterState.CONVERSATION_ENDED_MESSAGE;
        } else if (conversationDM.state == IssueState.RESOLUTION_REJECTED) {
            state = shouldShowMessageBoxOnConversationRejected ? ConversationFooterState.NONE : (conversationDM.shouldShowCSATInFooter() ? ConversationFooterState.CSAT_RATING : ConversationFooterState.START_NEW_CONVERSATION);
        } else if (conversationDM.state == IssueState.AUTHOR_MISMATCH) {
            state = ConversationFooterState.AUTHOR_MISMATCH;
        }
        widget.setState(state);
    }

    public ButtonWidget makeConfirmationBoxWidget(ConversationDM conversationDM) {
        ButtonWidget confirmationBoxWidget = new ButtonWidget();
        this.updateConfirmationBoxWidget(confirmationBoxWidget, conversationDM);
        return confirmationBoxWidget;
    }

    public void updateConfirmationBoxWidget(ButtonWidget confirmationBoxWidget, ConversationDM conversationDM) {
        boolean isVisible = false;
        if (!conversationDM.isRedacted && conversationDM.state == IssueState.RESOLUTION_REQUESTED && this.config.shouldShowConversationResolutionQuestion()) {
            isVisible = true;
        }
        confirmationBoxWidget.setVisible(isVisible);
    }

    public ButtonWidget makeAttachImageButtonWidget() {
        ButtonWidget buttonWidget = new ButtonWidget();
        buttonWidget.setVisible(this.getDefaultVisibilityForAttachImageButton());
        return buttonWidget;
    }

    public ButtonWidget makeNewConversationAttachImageButtonWidget(ImageAttachmentWidget imageAttachmentWidget) {
        ButtonWidget buttonWidget = new ButtonWidget();
        buttonWidget.setVisible(this.getVisibilityForNewConversationAttachImageButton(imageAttachmentWidget));
        return buttonWidget;
    }

    private boolean getVisibilityForNewConversationAttachImageButton(ImageAttachmentWidget imageAttachmentWidget) {
        if (this.getDefaultVisibilityForAttachImageButton()) {
            boolean imageNotYetAttached = StringUtils.isEmpty(imageAttachmentWidget.getImagePath());
            return imageNotYetAttached && !this.conversationInboxDM.isCreateConversationInProgress();
        }
        return false;
    }

    public boolean getDefaultVisibilityForAttachImageButton() {
        return !this.config.getBoolean("fullPrivacy") && this.config.getBoolean("allowUserAttachments");
    }

    public DescriptionWidget makeDescriptionWidget() {
        DescriptionWidget widget = new DescriptionWidget(this.config.getMinimumConversationDescriptionLength());
        String description = "";
        String descriptionDraft = "";
        String archText = this.conversationInboxDM.getConversationArchivalPrefillText();
        String prefillText = this.config.getString("conversationPrefillText");
        ConversationDetailDTO descriptionDetail = this.conversationInboxDM.getConversationDetail();
        if (descriptionDetail != null && descriptionDetail.type == 1) {
            descriptionDraft = descriptionDetail.title;
            long timeDiff = System.nanoTime() - descriptionDetail.timestamp;
            if (timeDiff < 0L || TimeUnit.NANOSECONDS.toSeconds(timeDiff) > 7200L) {
                this.conversationInboxDM.saveDescriptionDetail("", 0);
                descriptionDraft = "";
            }
        }
        if (!StringUtils.isEmpty(descriptionDraft)) {
            description = descriptionDraft;
        } else if (!StringUtils.isEmpty(archText)) {
            description = archText;
            this.conversationInboxDM.saveDescriptionDetail(description, 3);
        } else if (!StringUtils.isEmpty(prefillText)) {
            description = prefillText;
            this.conversationInboxDM.saveDescriptionDetail(description, 2);
        }
        widget.setText(description);
        return widget;
    }

    public void save(DescriptionWidget descriptionWidget) {
        this.conversationInboxDM.saveDescriptionDetail(descriptionWidget.getText(), 1);
    }

    public NameWidget makeNameWidget() {
        NameWidget widget = new NameWidget();
        String result = !this.config.shouldCreateConversationAnonymously() ? this.conversationInboxDM.getName() : "Anonymous";
        widget.setText(result);
        return widget;
    }

    public EmailWidget makeEmailWidget() {
        EmailWidget emailWidget = new EmailWidget();
        emailWidget.setRequired(this.isEmailRequired());
        if (!this.config.shouldCreateConversationAnonymously()) {
            emailWidget.setText(this.conversationInboxDM.getEmail());
        }
        return emailWidget;
    }

    private boolean isEmailRequired() {
        if (this.config.getBoolean("fullPrivacy")) {
            return false;
        }
        if (this.config.getBoolean("requireNameAndEmail")) {
            return true;
        }
        return this.config.getBoolean("profileFormEnable") && this.config.getBoolean("requireEmail");
    }

    public ImageAttachmentWidget makeImageAttachmentWidget() {
        ImageAttachmentWidget widget = new ImageAttachmentWidget();
        if (this.config.getBoolean("fullPrivacy")) {
            widget.setImagePickerFile(null);
            this.save(widget);
        } else {
            widget.setImagePickerFile(this.conversationInboxDM.getImageAttachmentDraft());
            widget.setClickable(!this.conversationInboxDM.isCreateConversationInProgress());
        }
        return widget;
    }

    public void save(ImageAttachmentWidget widget) {
        this.conversationInboxDM.saveImageAttachmentDraft(widget.getImagePickerFile());
    }

    public ProfileFormWidget makeProfileFormWidget(TextWidget nameWidget, TextWidget emailWidget) {
        ProfileFormWidget profileFormWidget = new ProfileFormWidget();
        profileFormWidget.setVisible(this.isProfileFormVisible(nameWidget, emailWidget));
        return profileFormWidget;
    }

    private boolean isProfileFormVisible(TextWidget nameWidget, TextWidget emailWidget) {
        boolean isEmailAvailable;
        if (this.config.getBoolean("fullPrivacy")) {
            return false;
        }
        boolean isProfileFormEnable = this.config.getBoolean("profileFormEnable");
        boolean isHideNameAndEmail = this.config.getBoolean("hideNameAndEmail");
        boolean isNameAvailable = nameWidget.getText().length() > 0;
        boolean bl = isEmailAvailable = emailWidget.getText().length() > 0;
        if (this.config.getBoolean("requireNameAndEmail") && isHideNameAndEmail) {
            return !isNameAvailable || !isEmailAvailable;
        }
        return isProfileFormEnable && (!isHideNameAndEmail || this.config.getBoolean("requireEmail") && !isEmailAvailable || !isNameAvailable);
    }

    public ProgressBarWidget makeProgressBarWidget() {
        ProgressBarWidget progressBarWidget = new ProgressBarWidget();
        progressBarWidget.setVisible(this.conversationInboxDM.isCreateConversationInProgress());
        return progressBarWidget;
    }
}

