/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.http;

import com.hexagonkt.helpers.Jvm;
import com.hexagonkt.http.HttpKt;
import com.hexagonkt.http.Method;
import com.hexagonkt.http.Path;
import com.hexagonkt.http.Route;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\b\u001a\u0010\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u000e\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010\u0012\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u000b\u001a\u0010\u0010\u0017\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u0018\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\n\u0010\u001b\u001a\u00020\u000b*\u00020\u000b\u001a\n\u0010\u001c\u001a\u00020\u000b*\u00020\u000b\"+\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001d"}, d2={"ALL", "Ljava/util/LinkedHashSet;", "Lcom/hexagonkt/http/Method;", "Lkotlin/collections/LinkedHashSet;", "getALL", "()Ljava/util/LinkedHashSet;", "ALL$delegate", "Lkotlin/Lazy;", "any", "Lcom/hexagonkt/http/Route;", "path", "", "delete", "get", "head", "httpDate", "date", "Ljava/time/LocalDateTime;", "options", "parseQueryParameters", "", "", "query", "patch", "post", "put", "trace", "urlDecode", "urlEncode", "hexagon_http"})
public final class HttpKt {
    @NotNull
    private static final Lazy ALL$delegate = LazyKt.lazy((Function0)ALL.2.INSTANCE);

    @NotNull
    public static final LinkedHashSet<Method> getALL() {
        Lazy lazy = ALL$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (LinkedHashSet)lazy.getValue();
    }

    @NotNull
    public static final Route any(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new Route(new Path(path), HttpKt.getALL());
    }

    public static /* synthetic */ Route any$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/";
        }
        return HttpKt.any(string);
    }

    @NotNull
    public static final Route get(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new Route(path, Method.GET);
    }

    public static /* synthetic */ Route get$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/";
        }
        return HttpKt.get(string);
    }

    @NotNull
    public static final Route head(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new Route(path, Method.HEAD);
    }

    public static /* synthetic */ Route head$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/";
        }
        return HttpKt.head(string);
    }

    @NotNull
    public static final Route post(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new Route(path, Method.POST);
    }

    public static /* synthetic */ Route post$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/";
        }
        return HttpKt.post(string);
    }

    @NotNull
    public static final Route put(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new Route(path, Method.PUT);
    }

    public static /* synthetic */ Route put$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/";
        }
        return HttpKt.put(string);
    }

    @NotNull
    public static final Route delete(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new Route(path, Method.DELETE);
    }

    public static /* synthetic */ Route delete$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/";
        }
        return HttpKt.delete(string);
    }

    @NotNull
    public static final Route trace(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new Route(path, Method.TRACE);
    }

    public static /* synthetic */ Route trace$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/";
        }
        return HttpKt.trace(string);
    }

    @NotNull
    public static final Route options(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new Route(path, Method.OPTIONS);
    }

    public static /* synthetic */ Route options$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/";
        }
        return HttpKt.options(string);
    }

    @NotNull
    public static final Route patch(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new Route(path, Method.PATCH);
    }

    public static /* synthetic */ Route patch$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/";
        }
        return HttpKt.patch(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, List<String>> parseQueryParameters(@NotNull String query) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (StringsKt.isBlank((CharSequence)query)) {
            boolean bl = false;
            object = MapsKt.emptyMap();
        } else {
            void $this$mapValuesTo$iv$iv;
            Object key$iv$iv;
            Object $this$groupByTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Object object2;
            CharSequence key;
            List keyValue;
            Iterable iterable;
            Pair it;
            Object object3;
            Iterable $this$mapTo$iv$iv;
            CharSequence charSequence = query;
            String string = "&";
            int n = 0;
            string = new Regex(string);
            n = 0;
            boolean bl = false;
            Iterable $this$map$iv = string.split(charSequence, n);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                String string2 = (String)item$iv$iv;
                object3 = destination$iv$iv;
                boolean bl2 = false;
                Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)((CharSequence)it), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map2 = false;
                Iterable iterable3 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void p1;
                    String string3 = (String)item$iv$iv2;
                    iterable = destination$iv$iv2;
                    boolean bl3 = false;
                    void var20_38 = p1;
                    boolean bl4 = false;
                    void v1 = var20_38;
                    if (v1 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string4 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                    iterable.add(string4);
                }
                keyValue = (List)destination$iv$iv2;
                key = (String)keyValue.get(0);
                String value = keyValue.size() == 2 ? (String)keyValue.get(1) : "";
                object2 = TuplesKt.to((Object)HttpKt.urlDecode((String)key), (Object)HttpKt.urlDecode(value));
                object3.add(object2);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pair)element$iv$iv;
                boolean bl5 = false;
                key = (CharSequence)it.getFirst();
                boolean value = false;
                if (!(!StringsKt.isBlank((CharSequence)key))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object4;
                Object element$iv$iv;
                element$iv$iv = iterator.next();
                it = (Pair)element$iv$iv;
                boolean bl6 = false;
                key$iv$iv = (String)it.getFirst();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl7 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object4 = answer$iv$iv$iv;
                } else {
                    object4 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object4;
                list$iv$iv.add(element$iv$iv);
            }
            Object $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $this$mapTo$iv$iv3;
                void pair;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object object5 = destination$iv$iv;
                boolean bl8 = false;
                Object k = it$iv$iv.getKey();
                Map.Entry answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                object2 = k;
                object3 = object5;
                boolean bl9 = false;
                Iterable $this$map$iv3 = (Iterable)pair.getValue();
                boolean $i$f$map3 = false;
                iterable = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                    void it2;
                    keyValue = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl10 = false;
                    String string5 = (String)it2.getSecond();
                    collection.add(string5);
                }
                List list = (List)destination$iv$iv3;
                object3.put(object2, list);
            }
            object = destination$iv$iv;
        }
        return object;
    }

    @NotNull
    public static final String httpDate(@NotNull LocalDateTime date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string = DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.of(date, ZoneId.of("GMT")));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RFC_1123_DATE_TIME.forma\u2026(date, ZoneId.of(\"GMT\")))");
        return string;
    }

    public static /* synthetic */ String httpDate$default(LocalDateTime localDateTime, int n, Object object) {
        if ((n & 1) != 0) {
            LocalDateTime localDateTime2 = LocalDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"LocalDateTime.now()");
            localDateTime = localDateTime2;
        }
        return HttpKt.httpDate(localDateTime);
    }

    @NotNull
    public static final String urlDecode(@NotNull String $this$urlDecode) {
        Intrinsics.checkNotNullParameter((Object)$this$urlDecode, (String)"$this$urlDecode");
        String string = URLDecoder.decode($this$urlDecode, Jvm.INSTANCE.getCharset().name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLDecoder.decode(this, charset.name())");
        return string;
    }

    @NotNull
    public static final String urlEncode(@NotNull String $this$urlEncode) {
        Intrinsics.checkNotNullParameter((Object)$this$urlEncode, (String)"$this$urlEncode");
        String string = URLEncoder.encode($this$urlEncode, Jvm.INSTANCE.getCharset().name());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLEncoder.encode(this, charset.name())");
        return string;
    }
}

