/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.http;

import com.hexagonkt.http.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 -2\u00020\u0001:\u0001-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J7\u0010\u001f\u001a\u00020\u00032*\u0010 \u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\"0!\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\"\u00a2\u0006\u0002\u0010#J\u0013\u0010$\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030'2\u0006\u0010(\u001a\u00020\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\u000e\u0010+\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0003J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\n\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\n\u001a\u0004\b\u001b\u0010\u0011\u00a8\u0006."}, d2={"Lcom/hexagonkt/http/Path;", "", "pattern", "", "(Ljava/lang/String;)V", "hasParameters", "", "getHasParameters", "()Z", "hasParameters$delegate", "Lkotlin/Lazy;", "hasWildcards", "getHasWildcards", "hasWildcards$delegate", "parameterIndex", "", "getParameterIndex", "()Ljava/util/List;", "parameterIndex$delegate", "getPattern", "()Ljava/lang/String;", "regex", "Lkotlin/text/Regex;", "getRegex", "()Lkotlin/text/Regex;", "regex$delegate", "segments", "getSegments", "segments$delegate", "component1", "copy", "create", "parameters", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)Ljava/lang/String;", "equals", "other", "extractParameters", "", "requestUrl", "hashCode", "", "matches", "toString", "Companion", "hexagon_http"})
public final class Path {
    @NotNull
    private final Lazy hasWildcards$delegate;
    @NotNull
    private final Lazy hasParameters$delegate;
    @NotNull
    private final Lazy parameterIndex$delegate;
    @Nullable
    private final Lazy regex$delegate;
    @NotNull
    private final Lazy segments$delegate;
    @NotNull
    private final String pattern;
    @NotNull
    public static final String PARAMETER_PREFIX = "{";
    @NotNull
    public static final String PARAMETER_SUFFIX = "}";
    @NotNull
    public static final String WILDCARD = "*";
    @NotNull
    private static final Regex WILDCARD_REGEX;
    @NotNull
    private static final Regex PARAMETER_REGEX;
    @NotNull
    private static final Regex PLACEHOLDER_REGEX;
    @NotNull
    private static final Companion Companion;

    public final boolean getHasWildcards() {
        Lazy lazy = this.hasWildcards$delegate;
        Path path = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    public final boolean getHasParameters() {
        Lazy lazy = this.hasParameters$delegate;
        Path path = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final List<String> getParameterIndex() {
        Lazy lazy = this.parameterIndex$delegate;
        Path path = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @Nullable
    public final Regex getRegex() {
        Lazy lazy = this.regex$delegate;
        Path path = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Regex)lazy.getValue();
    }

    @NotNull
    public final List<String> getSegments() {
        Lazy lazy = this.segments$delegate;
        Path path = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public final boolean matches(@NotNull String requestUrl) {
        Intrinsics.checkNotNullParameter((Object)requestUrl, (String)"requestUrl");
        Regex regex2 = this.getRegex();
        return regex2 != null ? regex2.matches((CharSequence)requestUrl) : Intrinsics.areEqual((Object)this.pattern, (Object)requestUrl);
    }

    @NotNull
    public final Map<String, String> extractParameters(@NotNull String requestUrl) {
        Intrinsics.checkNotNullParameter((Object)requestUrl, (String)"requestUrl");
        boolean bl = this.matches(requestUrl);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "URL '" + requestUrl + "' does not match path";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        var $fun$parameters$2 = new Function1<Regex, Map<String, ? extends String>>(this, requestUrl){
            final /* synthetic */ Path this$0;
            final /* synthetic */ String $requestUrl;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, String> invoke(@NotNull Regex re) {
                void $this$filterTo$iv$iv;
                Iterable $this$mapIndexedTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)re, (String)"re");
                Iterable $this$mapIndexed$iv = com.hexagonkt.helpers.StringsKt.findGroups((Regex)re, (String)this.$requestUrl);
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void idx;
                    void $dstr$value;
                    int n = index$iv$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    MatchGroup matchGroup = (MatchGroup)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    String value = $dstr$value.component1();
                    Pair pair = TuplesKt.to((Object)this.this$0.getParameterIndex().get((int)idx), (Object)value);
                    collection.add(pair);
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapIndexedTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Pair $dstr$first = (Pair)element$iv$iv;
                    boolean bl = false;
                    String first = (String)$dstr$first.component1();
                    if (!(Intrinsics.areEqual((Object)first, (Object)"") ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return MapsKt.toMap((Iterable)((List)destination$iv$iv));
            }
            {
                this.this$0 = path;
                this.$requestUrl = string;
                super(1);
            }
        };
        Regex re = this.getRegex();
        return this.getHasParameters() && re != null ? $fun$parameters$2.invoke(re) : MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String create(Pair<String, ? extends Object> ... parameters) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        if (this.getHasWildcards() || parameters.length != this.getParameterIndex().size()) {
            int expectedParams = this.getParameterIndex().size();
            int paramCount = parameters.length;
            String string = "Path has wildcards or different parameters: " + expectedParams + '/' + paramCount;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Pair<String, ? extends Object>[] $this$map$iv = parameters;
        boolean $i$f$map = false;
        Pair<String, ? extends Object>[] pairArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_12 = $this$mapTo$iv$iv;
        int n = ((void)var8_12).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_16 = item$iv$iv = var8_12[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getFirst(), (Object)it.getSecond().toString());
            collection.add(pair);
        }
        List map = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = map;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray2 = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return com.hexagonkt.helpers.StringsKt.filter((String)this.pattern, (String)PARAMETER_PREFIX, (String)PARAMETER_SUFFIX, (Pair[])Arrays.copyOf(pairArray2, pairArray2.length));
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    public Path(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.pattern = pattern;
        boolean validPrefix = StringsKt.startsWith$default((String)this.pattern, (String)"/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.pattern, (String)WILDCARD, (boolean)false, (int)2, null);
        boolean bl = false;
        boolean bl2 = false;
        if (!validPrefix) {
            boolean bl3 = false;
            String string = '\'' + this.pattern + "' must start with '/' or '*'";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = !StringsKt.contains$default((CharSequence)this.pattern, (CharSequence)":", (boolean)false, (int)2, null);
        bl2 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Variables have {var} format. Path cannot have ':' " + this.pattern;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.hasWildcards$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ Path this$0;

            public final boolean invoke() {
                CharSequence charSequence = this.this$0.getPattern();
                Regex regex2 = Path.access$Companion().getWILDCARD_REGEX$hexagon_http();
                boolean bl = false;
                return regex2.containsMatchIn(charSequence);
            }
            {
                this.this$0 = path;
                super(0);
            }
        }));
        this.hasParameters$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ Path this$0;

            public final boolean invoke() {
                CharSequence charSequence = this.this$0.getPattern();
                Regex regex2 = Path.access$Companion().getPARAMETER_REGEX$hexagon_http();
                boolean bl = false;
                return regex2.containsMatchIn(charSequence);
            }
            {
                this.this$0 = path;
                super(0);
            }
        }));
        this.parameterIndex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ Path this$0;

            @NotNull
            public final List<String> invoke() {
                return this.this$0.getHasParameters() ? SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)Path.access$Companion().getPLACEHOLDER_REGEX$hexagon_http(), (CharSequence)this.this$0.getPattern(), (int)0, (int)2, null), (Function1)parameterIndex.1.INSTANCE)) : CollectionsKt.emptyList();
            }
            {
                this.this$0 = path;
                super(0);
            }
        }));
        this.regex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Regex>(this){
            final /* synthetic */ Path this$0;

            @Nullable
            public final Regex invoke() {
                Regex regex2;
                Pair pair = new Pair((Object)this.this$0.getHasWildcards(), (Object)this.this$0.getHasParameters());
                if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)true, (Object)true))) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = this.this$0.getPattern();
                    Path.access$Companion();
                    CharSequence charSequence = StringsKt.replace$default((String)string, (String)"*", (String)"(.*?)", (boolean)false, (int)4, null);
                    Regex regex3 = Path.access$Companion().getPARAMETER_REGEX$hexagon_http();
                    String string2 = "(.+?)";
                    boolean bl = false;
                    Regex regex4 = new Regex(stringBuilder.append(regex3.replace(charSequence, string2)).append("$").toString());
                    regex2 = regex4;
                } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)true, (Object)false))) {
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = this.this$0.getPattern();
                    Path.access$Companion();
                    regex2 = new Regex(stringBuilder.append(StringsKt.replace$default((String)string, (String)"*", (String)"(.*?)", (boolean)false, (int)4, null)).append("$").toString());
                } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)false, (Object)true))) {
                    CharSequence charSequence = this.this$0.getPattern();
                    Regex regex5 = Path.access$Companion().getPARAMETER_REGEX$hexagon_http();
                    String string = "(.+?)";
                    boolean bl = false;
                    Regex regex6 = new Regex(regex5.replace(charSequence, string) + "$");
                    regex2 = regex6;
                } else {
                    regex2 = null;
                }
                return regex2;
            }
            {
                this.this$0 = path;
                super(0);
            }
        }));
        this.segments$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ Path this$0;

            @NotNull
            public final List<String> invoke() {
                CharSequence charSequence = this.this$0.getPattern();
                Regex regex2 = Path.access$Companion().getPLACEHOLDER_REGEX$hexagon_http();
                int n = 0;
                boolean bl = false;
                return regex2.split(charSequence, n);
            }
            {
                this.this$0 = path;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        WILDCARD_REGEX = new Regex("\\*");
        PARAMETER_REGEX = new Regex("\\{\\w+}");
        PLACEHOLDER_REGEX = new Regex("\\*|\\{\\w+}");
    }

    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @NotNull
    public final String component1() {
        return this.pattern;
    }

    @NotNull
    public final Path copy(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return new Path(pattern);
    }

    public static /* synthetic */ Path copy$default(Path path, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = path.pattern;
        }
        return path.copy(string);
    }

    @NotNull
    public String toString() {
        return "Path(pattern=" + this.pattern + ")";
    }

    public int hashCode() {
        String string = this.pattern;
        return string != null ? string.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Path)) break block3;
                Path path = (Path)object;
                if (!Intrinsics.areEqual((Object)this.pattern, (Object)path.pattern)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/hexagonkt/http/Path$Companion;", "", "()V", "PARAMETER_PREFIX", "", "PARAMETER_REGEX", "Lkotlin/text/Regex;", "getPARAMETER_REGEX$hexagon_http", "()Lkotlin/text/Regex;", "PARAMETER_SUFFIX", "PLACEHOLDER_REGEX", "getPLACEHOLDER_REGEX$hexagon_http", "WILDCARD", "WILDCARD_REGEX", "getWILDCARD_REGEX$hexagon_http", "hexagon_http"})
    private static final class Companion {
        @NotNull
        public final Regex getWILDCARD_REGEX$hexagon_http() {
            return WILDCARD_REGEX;
        }

        @NotNull
        public final Regex getPARAMETER_REGEX$hexagon_http() {
            return PARAMETER_REGEX;
        }

        @NotNull
        public final Regex getPLACEHOLDER_REGEX$hexagon_http() {
            return PLACEHOLDER_REGEX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

