/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.logging.slf4j.jul;

import com.hexagonkt.core.logging.LoggerPort;
import com.hexagonkt.core.logging.LoggingLevel;
import com.hexagonkt.core.logging.LoggingPort;
import com.hexagonkt.core.logging.jul.JulLoggingAdapter;
import com.hexagonkt.logging.slf4j.jul.Slf4jJulLoggingAdapter;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/hexagonkt/logging/slf4j/jul/Slf4jJulLoggingAdapter;", "Lcom/hexagonkt/core/logging/LoggingPort;", "()V", "julLoggingAdapter", "Lcom/hexagonkt/core/logging/jul/JulLoggingAdapter;", "createLogger", "Lcom/hexagonkt/core/logging/LoggerPort;", "name", "", "isLoggerLevelEnabled", "", "level", "Lcom/hexagonkt/core/logging/LoggingLevel;", "setLoggerLevel", "", "logging_slf4j_jul"})
public final class Slf4jJulLoggingAdapter
implements LoggingPort {
    @NotNull
    private final JulLoggingAdapter julLoggingAdapter = new JulLoggingAdapter();

    @NotNull
    public LoggerPort createLogger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new LoggerPort(name){
            @NotNull
            private final Logger log;
            {
                Logger logger = LoggerFactory.getLogger((String)$name);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(name)");
                this.log = logger;
            }

            @NotNull
            public final Logger getLog() {
                return this.log;
            }

            public void log(@NotNull LoggingLevel level, @NotNull Function0<? extends Object> message) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter(message, (String)"message");
                switch (createLogger.WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                    case 1: {
                        if (!this.log.isTraceEnabled()) break;
                        this.log.trace(String.valueOf(message.invoke()));
                        break;
                    }
                    case 2: {
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug(String.valueOf(message.invoke()));
                        break;
                    }
                    case 3: {
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info(String.valueOf(message.invoke()));
                        break;
                    }
                    case 4: {
                        if (!this.log.isWarnEnabled()) break;
                        this.log.warn(String.valueOf(message.invoke()));
                        break;
                    }
                    case 5: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error(String.valueOf(message.invoke()));
                    }
                }
            }

            public <E extends Throwable> void log(@NotNull LoggingLevel level, @NotNull E exception, @NotNull Function1<? super E, ? extends Object> message) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter(exception, (String)"exception");
                Intrinsics.checkNotNullParameter(message, (String)"message");
                switch (createLogger.WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                    case 1: {
                        if (!this.log.isTraceEnabled()) break;
                        this.log.trace(String.valueOf(message.invoke(exception)), exception);
                        break;
                    }
                    case 2: {
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug(String.valueOf(message.invoke(exception)), exception);
                        break;
                    }
                    case 3: {
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info(String.valueOf(message.invoke(exception)), exception);
                        break;
                    }
                    case 4: {
                        if (!this.log.isWarnEnabled()) break;
                        this.log.warn(String.valueOf(message.invoke(exception)), exception);
                        break;
                    }
                    case 5: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error(String.valueOf(message.invoke(exception)), exception);
                    }
                }
            }
        };
    }

    public void setLoggerLevel(@NotNull String name, @NotNull LoggingLevel level) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        CharSequence charSequence2 = name;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "ROOT";
        } else {
            charSequence = charSequence2;
        }
        String loggerName = (String)charSequence;
        this.julLoggingAdapter.setLoggerLevel(loggerName, level);
    }

    public boolean isLoggerLevelEnabled(@NotNull String name, @NotNull LoggingLevel level) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        JulLoggingAdapter julLoggingAdapter = this.julLoggingAdapter;
        CharSequence charSequence2 = name;
        if (charSequence2.length() == 0) {
            JulLoggingAdapter julLoggingAdapter2 = julLoggingAdapter;
            boolean bl = false;
            charSequence = "ROOT";
            julLoggingAdapter = julLoggingAdapter2;
        } else {
            charSequence = charSequence2;
        }
        return julLoggingAdapter.isLoggerLevelEnabled((String)charSequence, level);
    }
}

